/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.streaming.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.math.Centroid;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class CentroidWritable
implements Writable {
    private Centroid centroid = null;

    public CentroidWritable() {
    }

    public CentroidWritable(Centroid centroid) {
        this.centroid = centroid;
    }

    public Centroid getCentroid() {
        return this.centroid;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.centroid.getIndex());
        dataOutput.writeDouble(this.centroid.getWeight());
        VectorWritable.writeVector(dataOutput, this.centroid.getVector());
    }

    public void readFields(DataInput dataInput) throws IOException {
        if (this.centroid == null) {
            this.centroid = CentroidWritable.read(dataInput);
            return;
        }
        this.centroid.setIndex(dataInput.readInt());
        this.centroid.setWeight(dataInput.readDouble());
        this.centroid.assign(VectorWritable.readVector(dataInput));
    }

    public static Centroid read(DataInput dataInput) throws IOException {
        int index = dataInput.readInt();
        double weight = dataInput.readDouble();
        Vector v = VectorWritable.readVector(dataInput);
        return new Centroid(index, v, weight);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CentroidWritable)) {
            return false;
        }
        CentroidWritable writable = (CentroidWritable)o;
        return this.centroid.equals((Object)writable.centroid);
    }

    public int hashCode() {
        return this.centroid.hashCode();
    }

    public String toString() {
        return this.centroid.toString();
    }
}

