/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.nlp;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NGrams {
    private static final Splitter SPACE_TAB = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)" \t"));
    private final String line;
    private final int gramSize;

    public NGrams(String line, int gramSize) {
        this.line = line;
        this.gramSize = gramSize;
    }

    public Map<String, List<String>> generateNGrams() {
        HashMap returnDocument = Maps.newHashMap();
        Iterator tokenizer = SPACE_TAB.split((CharSequence)this.line).iterator();
        ArrayList tokens = Lists.newArrayList();
        String labelName = (String)tokenizer.next();
        ArrayList previousN1Grams = Lists.newArrayList();
        while (tokenizer.hasNext()) {
            String nextToken = (String)tokenizer.next();
            if (previousN1Grams.size() == this.gramSize) {
                previousN1Grams.remove(0);
            }
            previousN1Grams.add(nextToken);
            StringBuilder gramBuilder = new StringBuilder();
            for (String gram : previousN1Grams) {
                gramBuilder.append(gram);
                String token = gramBuilder.toString();
                tokens.add(token);
                gramBuilder.append(' ');
            }
        }
        returnDocument.put(labelName, tokens);
        return returnDocument;
    }

    public List<String> generateNGramsWithoutLabel() {
        ArrayList tokens = Lists.newArrayList();
        ArrayList previousN1Grams = Lists.newArrayList();
        for (String nextToken : SPACE_TAB.split((CharSequence)this.line)) {
            if (previousN1Grams.size() == this.gramSize) {
                previousN1Grams.remove(0);
            }
            previousN1Grams.add(nextToken);
            StringBuilder gramBuilder = new StringBuilder();
            for (String gram : previousN1Grams) {
                gramBuilder.append(gram);
                String token = gramBuilder.toString();
                tokens.add(token);
                gramBuilder.append(' ');
            }
        }
        return tokens;
    }
}

