/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.hadoop.MatrixColumnMeansJob;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDHelper;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDSolver;

public class SSVDCli
extends AbstractJob {
    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOutputOption();
        this.addOption("rank", "k", "decomposition rank", true);
        this.addOption("oversampling", "p", "oversampling", String.valueOf(15));
        this.addOption("blockHeight", "r", "Y block height (must be > (k+p))", String.valueOf(10000));
        this.addOption("outerProdBlockHeight", "oh", "block height of outer products during multiplication, increase for sparse inputs", String.valueOf(30000));
        this.addOption("abtBlockHeight", "abth", "block height of Y_i in ABtJob during AB' multiplication, increase for extremely sparse inputs", String.valueOf(200000));
        this.addOption("minSplitSize", "s", "minimum split size", String.valueOf(-1));
        this.addOption("computeU", "U", "compute U (true/false)", String.valueOf(true));
        this.addOption("uHalfSigma", "uhs", "Compute U * Sigma^0.5", String.valueOf(false));
        this.addOption("uSigma", "us", "Compute U * Sigma", String.valueOf(false));
        this.addOption("computeV", "V", "compute V (true/false)", String.valueOf(true));
        this.addOption("vHalfSigma", "vhs", "compute V * Sigma^0.5", String.valueOf(false));
        this.addOption("reduceTasks", "t", "number of reduce tasks (where applicable)", true);
        this.addOption("powerIter", "q", "number of additional power iterations (0..2 is good)", String.valueOf(0));
        this.addOption("broadcast", "br", "whether use distributed cache to broadcast matrices wherever possible", String.valueOf(true));
        this.addOption("pca", "pca", "run in pca mode: compute column-wise mean and subtract from input", String.valueOf(false));
        this.addOption("pcaOffset", "xi", "path(glob) of external pca mean (optional, dont compute, use external mean");
        this.addOption((Option)DefaultOptionCreator.overwriteOption().create());
        Map<String, List<String>> pargs = this.parseArguments(args);
        if (pargs == null) {
            return -1;
        }
        int k = Integer.parseInt(this.getOption("rank"));
        int p = Integer.parseInt(this.getOption("oversampling"));
        int r = Integer.parseInt(this.getOption("blockHeight"));
        int h = Integer.parseInt(this.getOption("outerProdBlockHeight"));
        int abh = Integer.parseInt(this.getOption("abtBlockHeight"));
        int q = Integer.parseInt(this.getOption("powerIter"));
        int minSplitSize = Integer.parseInt(this.getOption("minSplitSize"));
        boolean computeU = Boolean.parseBoolean(this.getOption("computeU"));
        boolean computeV = Boolean.parseBoolean(this.getOption("computeV"));
        boolean cUHalfSigma = Boolean.parseBoolean(this.getOption("uHalfSigma"));
        boolean cUSigma = Boolean.parseBoolean(this.getOption("uSigma"));
        boolean cVHalfSigma = Boolean.parseBoolean(this.getOption("vHalfSigma"));
        int reduceTasks = Integer.parseInt(this.getOption("reduceTasks"));
        boolean broadcast = Boolean.parseBoolean(this.getOption("broadcast"));
        String xiPathStr = this.getOption("pcaOffset");
        Path xiPath = xiPathStr == null ? null : new Path(xiPathStr);
        boolean pca = Boolean.parseBoolean(this.getOption("pca")) || xiPath != null;
        boolean overwrite = this.hasOption("overwrite");
        Configuration conf = this.getConf();
        if (conf == null) {
            throw new IOException("No Hadoop configuration present");
        }
        Path[] inputPaths = new Path[]{this.getInputPath()};
        Path tempPath = this.getTempPath();
        FileSystem fs = FileSystem.get((URI)this.getTempPath().toUri(), (Configuration)conf);
        if (overwrite) {
            HadoopUtil.delete(this.getConf(), this.getOutputPath());
            HadoopUtil.delete(this.getConf(), this.getTempPath());
        }
        fs.mkdirs(this.getOutputPath());
        if (pca && xiPath == null) {
            xiPath = new Path(tempPath, "xi");
            if (overwrite) {
                fs.delete(xiPath, true);
            }
            MatrixColumnMeansJob.run(conf, inputPaths[0], xiPath);
        }
        SSVDSolver solver = new SSVDSolver(conf, inputPaths, new Path(tempPath, "ssvd"), r, k, p, reduceTasks);
        solver.setMinSplitSize(minSplitSize);
        solver.setComputeU(computeU);
        solver.setComputeV(computeV);
        solver.setcUHalfSigma(cUHalfSigma);
        solver.setcVHalfSigma(cVHalfSigma);
        solver.setcUSigma(cUSigma);
        solver.setOuterBlockHeight(h);
        solver.setAbtBlockHeight(abh);
        solver.setQ(q);
        solver.setBroadcast(broadcast);
        solver.setOverwrite(overwrite);
        if (xiPath != null) {
            solver.setPcaMeanPath(new Path(xiPath, "part-*"));
        }
        solver.run();
        Vector svalues = solver.getSingularValues().viewPart(0, k);
        SSVDHelper.saveVector(svalues, this.getOutputPath("sigma"), conf);
        if (computeU && !fs.rename(new Path(solver.getUPath()), this.getOutputPath())) {
            throw new IOException("Unable to move U results to the output path.");
        }
        if (cUHalfSigma && !fs.rename(new Path(solver.getuHalfSigmaPath()), this.getOutputPath())) {
            throw new IOException("Unable to move U*Sigma^0.5 results to the output path.");
        }
        if (cUSigma && !fs.rename(new Path(solver.getuSigmaPath()), this.getOutputPath())) {
            throw new IOException("Unable to move U*Sigma results to the output path.");
        }
        if (computeV && !fs.rename(new Path(solver.getVPath()), this.getOutputPath())) {
            throw new IOException("Unable to move V results to the output path.");
        }
        if (cVHalfSigma && !fs.rename(new Path(solver.getvHalfSigmaPath()), this.getOutputPath())) {
            throw new IOException("Unable to move V*Sigma^0.5 results to the output path.");
        }
        fs.deleteOnExit(this.getTempPath());
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new SSVDCli(), (String[])args);
    }
}

