/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.math.Varint;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.PlusMult;

public class SparseRowBlockWritable
implements Writable {
    private int[] rowIndices;
    private Vector[] rows;
    private int numRows;

    public SparseRowBlockWritable() {
        this(10);
    }

    public SparseRowBlockWritable(int initialCapacity) {
        this.rowIndices = new int[initialCapacity];
        this.rows = new Vector[initialCapacity];
    }

    public int[] getRowIndices() {
        return this.rowIndices;
    }

    public Vector[] getRows() {
        return this.rows;
    }

    public void readFields(DataInput in) throws IOException {
        this.numRows = Varint.readUnsignedVarInt(in);
        if (this.rows == null || this.rows.length < this.numRows) {
            this.rows = new Vector[this.numRows];
            this.rowIndices = new int[this.numRows];
        }
        VectorWritable vw = new VectorWritable();
        for (int i = 0; i < this.numRows; ++i) {
            this.rowIndices[i] = Varint.readUnsignedVarInt(in);
            vw.readFields(in);
            this.rows[i] = vw.get().clone();
        }
    }

    public void write(DataOutput out) throws IOException {
        Varint.writeUnsignedVarInt(this.numRows, out);
        VectorWritable vw = new VectorWritable();
        for (int i = 0; i < this.numRows; ++i) {
            Varint.writeUnsignedVarInt(this.rowIndices[i], out);
            vw.set(this.rows[i]);
            vw.write(out);
        }
    }

    public void plusRow(int index, Vector row) {
        int pos;
        int n = pos = this.numRows == 0 || this.rowIndices[this.numRows - 1] < index ? -this.numRows - 1 : Arrays.binarySearch(this.rowIndices, 0, this.numRows, index);
        if (pos >= 0) {
            this.rows[pos].assign(row, (DoubleDoubleFunction)PlusMult.plusMult((double)1.0));
        } else {
            this.insertIntoPos(-pos - 1, index, row);
        }
    }

    private void insertIntoPos(int pos, int rowIndex, Vector row) {
        if (this.numRows == this.rows.length) {
            this.rows = Arrays.copyOf(this.rows, this.numRows + 1 << 1);
            this.rowIndices = Arrays.copyOf(this.rowIndices, this.numRows + 1 << 1);
        }
        System.arraycopy(this.rows, pos, this.rows, pos + 1, this.numRows - pos);
        System.arraycopy(this.rowIndices, pos, this.rowIndices, pos + 1, this.numRows - pos);
        this.rowIndices[pos] = rowIndex;
        this.rows[pos] = row.clone();
        ++this.numRows;
    }

    public void plusBlock(SparseRowBlockWritable bOther) {
        int i = 0;
        int j = 0;
        while (i < this.numRows && j < bOther.numRows) {
            while (i < this.numRows && this.rowIndices[i] < bOther.rowIndices[j]) {
                ++i;
            }
            if (i >= this.numRows) continue;
            if (this.rowIndices[i] == bOther.rowIndices[j]) {
                this.rows[i].assign(bOther.rows[j], (DoubleDoubleFunction)PlusMult.plusMult((double)1.0));
            } else {
                this.insertIntoPos(i, bOther.rowIndices[j], bOther.rows[j]);
            }
            ++i;
            ++j;
        }
        while (j < bOther.numRows) {
            this.insertIntoPos(this.numRows, bOther.rowIndices[j], bOther.rows[j]);
            ++j;
        }
    }

    public int getNumRows() {
        return this.numRows;
    }

    public void clear() {
        this.numRows = 0;
        Arrays.fill(this.rows, null);
    }
}

