/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.mapreduce.partial;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.classifier.df.DFUtils;
import org.apache.mahout.classifier.df.DecisionForest;
import org.apache.mahout.classifier.df.builder.TreeBuilder;
import org.apache.mahout.classifier.df.mapreduce.Builder;
import org.apache.mahout.classifier.df.mapreduce.MapredOutput;
import org.apache.mahout.classifier.df.mapreduce.partial.Step1Mapper;
import org.apache.mahout.classifier.df.mapreduce.partial.TreeID;
import org.apache.mahout.classifier.df.node.Node;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;

public class PartialBuilder
extends Builder {
    public PartialBuilder(TreeBuilder treeBuilder, Path dataPath, Path datasetPath, Long seed) {
        this(treeBuilder, dataPath, datasetPath, seed, new Configuration());
    }

    public PartialBuilder(TreeBuilder treeBuilder, Path dataPath, Path datasetPath, Long seed, Configuration conf) {
        super(treeBuilder, dataPath, datasetPath, seed, conf);
    }

    @Override
    protected void configureJob(Job job) throws IOException {
        Configuration conf = job.getConfiguration();
        job.setJarByClass(PartialBuilder.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{this.getDataPath()});
        FileOutputFormat.setOutputPath((Job)job, (Path)this.getOutputPath(conf));
        job.setOutputKeyClass(TreeID.class);
        job.setOutputValueClass(MapredOutput.class);
        job.setMapperClass(Step1Mapper.class);
        job.setNumReduceTasks(0);
        job.setInputFormatClass(TextInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
    }

    @Override
    protected DecisionForest parseOutput(Job job) throws IOException {
        Configuration conf = job.getConfiguration();
        int numTrees = Builder.getNbTrees(conf);
        Path outputPath = this.getOutputPath(conf);
        TreeID[] keys = new TreeID[numTrees];
        Node[] trees = new Node[numTrees];
        PartialBuilder.processOutput((JobContext)job, outputPath, keys, trees);
        return new DecisionForest(Arrays.asList(trees));
    }

    protected static void processOutput(JobContext job, Path outputPath, TreeID[] keys, Node[] trees) throws IOException {
        Preconditions.checkArgument(keys == null && trees == null || keys != null && trees != null, "if keys is null, trees should also be null");
        Preconditions.checkArgument(keys == null || keys.length == trees.length, "keys.length != trees.length");
        Configuration conf = job.getConfiguration();
        FileSystem fs = outputPath.getFileSystem(conf);
        Path[] outfiles = DFUtils.listOutputFiles(fs, outputPath);
        int index = 0;
        for (Path path : outfiles) {
            for (Pair record : new SequenceFileIterable(path, conf)) {
                TreeID key = (TreeID)record.getFirst();
                MapredOutput value = (MapredOutput)record.getSecond();
                if (keys != null) {
                    keys[index] = key;
                }
                if (trees != null) {
                    trees[index] = value.getTree();
                }
                ++index;
            }
        }
        if (keys != null && index != keys.length) {
            throw new IllegalStateException("Some key/values are missing from the output");
        }
    }
}

