/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterator;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.Functions;

public final class TimesSquaredJob {
    public static final String INPUT_VECTOR = "DistributedMatrix.times.inputVector";
    public static final String IS_SPARSE_OUTPUT = "DistributedMatrix.times.outputVector.sparse";
    public static final String OUTPUT_VECTOR_DIMENSION = "DistributedMatrix.times.output.dimension";
    public static final String OUTPUT_VECTOR_FILENAME = "DistributedMatrix.times.outputVector";

    private TimesSquaredJob() {
    }

    public static Configuration createTimesSquaredJobConf(Vector v, Path matrixInputPath, Path outputVectorPath) throws IOException {
        return TimesSquaredJob.createTimesSquaredJobConf(new Configuration(), v, matrixInputPath, outputVectorPath);
    }

    public static Configuration createTimesSquaredJobConf(Configuration initialConf, Vector v, Path matrixInputPath, Path outputVectorPath) throws IOException {
        return TimesSquaredJob.createTimesSquaredJobConf(initialConf, v, matrixInputPath, outputVectorPath, TimesSquaredMapper.class, VectorSummingReducer.class);
    }

    public static Configuration createTimesJobConf(Vector v, int outDim, Path matrixInputPath, Path outputVectorPath) throws IOException {
        return TimesSquaredJob.createTimesJobConf(new Configuration(), v, outDim, matrixInputPath, outputVectorPath);
    }

    public static Configuration createTimesJobConf(Configuration initialConf, Vector v, int outDim, Path matrixInputPath, Path outputVectorPath) throws IOException {
        return TimesSquaredJob.createTimesSquaredJobConf(initialConf, v, outDim, matrixInputPath, outputVectorPath, TimesMapper.class, VectorSummingReducer.class);
    }

    public static Configuration createTimesSquaredJobConf(Vector v, Path matrixInputPath, Path outputVectorPathBase, Class<? extends TimesSquaredMapper> mapClass, Class<? extends VectorSummingReducer> redClass) throws IOException {
        return TimesSquaredJob.createTimesSquaredJobConf(new Configuration(), v, matrixInputPath, outputVectorPathBase, mapClass, redClass);
    }

    public static Configuration createTimesSquaredJobConf(Configuration initialConf, Vector v, Path matrixInputPath, Path outputVectorPathBase, Class<? extends TimesSquaredMapper> mapClass, Class<? extends VectorSummingReducer> redClass) throws IOException {
        return TimesSquaredJob.createTimesSquaredJobConf(initialConf, v, v.size(), matrixInputPath, outputVectorPathBase, mapClass, redClass);
    }

    public static Configuration createTimesSquaredJobConf(Vector v, int outputVectorDim, Path matrixInputPath, Path outputVectorPathBase, Class<? extends TimesSquaredMapper> mapClass, Class<? extends VectorSummingReducer> redClass) throws IOException {
        return TimesSquaredJob.createTimesSquaredJobConf(new Configuration(), v, outputVectorDim, matrixInputPath, outputVectorPathBase, mapClass, redClass);
    }

    public static Configuration createTimesSquaredJobConf(Configuration initialConf, Vector v, int outputVectorDim, Path matrixInputPath, Path outputVectorPathBase, Class<? extends TimesSquaredMapper> mapClass, Class<? extends VectorSummingReducer> redClass) throws IOException {
        JobConf conf = new JobConf(initialConf, TimesSquaredJob.class);
        conf.setJobName("TimesSquaredJob: " + matrixInputPath);
        FileSystem fs = FileSystem.get((URI)matrixInputPath.toUri(), (Configuration)conf);
        matrixInputPath = fs.makeQualified(matrixInputPath);
        outputVectorPathBase = fs.makeQualified(outputVectorPathBase);
        long now = System.nanoTime();
        Path inputVectorPath = new Path(outputVectorPathBase, "DistributedMatrix.times.inputVector/" + now);
        SequenceFile.Writer inputVectorPathWriter = new SequenceFile.Writer(fs, (Configuration)conf, inputVectorPath, NullWritable.class, VectorWritable.class);
        VectorWritable inputVW = new VectorWritable(v);
        inputVectorPathWriter.append((Writable)NullWritable.get(), (Writable)inputVW);
        Closeables.close((Closeable)inputVectorPathWriter, false);
        URI ivpURI = inputVectorPath.toUri();
        DistributedCache.setCacheFiles((URI[])new URI[]{ivpURI}, (Configuration)conf);
        conf.set(INPUT_VECTOR, ivpURI.toString());
        conf.setBoolean(IS_SPARSE_OUTPUT, !v.isDense());
        conf.setInt(OUTPUT_VECTOR_DIMENSION, outputVectorDim);
        FileInputFormat.addInputPath((JobConf)conf, (Path)matrixInputPath);
        conf.setInputFormat(SequenceFileInputFormat.class);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputVectorPathBase, OUTPUT_VECTOR_FILENAME));
        conf.setMapperClass(mapClass);
        conf.setMapOutputKeyClass(NullWritable.class);
        conf.setMapOutputValueClass(VectorWritable.class);
        conf.setReducerClass(redClass);
        conf.setCombinerClass(redClass);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.setOutputKeyClass(NullWritable.class);
        conf.setOutputValueClass(VectorWritable.class);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector retrieveTimesSquaredOutputVector(Configuration conf) throws IOException {
        Path outputPath = FileOutputFormat.getOutputPath((JobConf)new JobConf(conf));
        Path outputFile = new Path(outputPath, "part-00000");
        SequenceFileValueIterator iterator = new SequenceFileValueIterator(outputFile, true, conf);
        try {
            Vector vector = ((VectorWritable)((Object)iterator.next())).get();
            return vector;
        }
        finally {
            Closeables.close(iterator, true);
        }
    }

    public static class VectorSummingReducer
    extends MapReduceBase
    implements Reducer<NullWritable, VectorWritable, NullWritable, VectorWritable> {
        private Vector outputVector;

        public void configure(JobConf conf) {
            int outputDimension = conf.getInt(TimesSquaredJob.OUTPUT_VECTOR_DIMENSION, Integer.MAX_VALUE);
            this.outputVector = conf.getBoolean(TimesSquaredJob.IS_SPARSE_OUTPUT, false) ? new RandomAccessSparseVector(outputDimension, 10) : new DenseVector(outputDimension);
        }

        public void reduce(NullWritable n, Iterator<VectorWritable> vectors, OutputCollector<NullWritable, VectorWritable> out, Reporter reporter) throws IOException {
            while (vectors.hasNext()) {
                VectorWritable v = vectors.next();
                if (v == null) continue;
                this.outputVector.assign(v.get(), Functions.PLUS);
            }
            out.collect((Object)NullWritable.get(), (Object)new VectorWritable(this.outputVector));
        }
    }

    public static class TimesMapper
    extends TimesSquaredMapper<IntWritable> {
        @Override
        public void map(IntWritable rowNum, VectorWritable v, OutputCollector<NullWritable, VectorWritable> out, Reporter rep) {
            this.setOut(out);
            double d = this.scale(v);
            if (d != 0.0) {
                this.getOutputVector().setQuick(rowNum.get(), d);
            }
        }
    }

    public static class TimesSquaredMapper<T extends WritableComparable>
    extends MapReduceBase
    implements Mapper<T, VectorWritable, NullWritable, VectorWritable> {
        private Vector outputVector;
        private OutputCollector<NullWritable, VectorWritable> out;
        private Vector inputVector;

        Vector getOutputVector() {
            return this.outputVector;
        }

        void setOut(OutputCollector<NullWritable, VectorWritable> out) {
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void configure(JobConf conf) {
            try {
                Path[] localFiles = DistributedCache.getLocalCacheFiles((Configuration)conf);
                Preconditions.checkArgument(localFiles != null && localFiles.length >= 1, "missing paths from the DistributedCache");
                Path inputVectorPath = HadoopUtil.getSingleCachedFile((Configuration)conf);
                SequenceFileValueIterator iterator = new SequenceFileValueIterator(inputVectorPath, true, (Configuration)conf);
                try {
                    this.inputVector = ((VectorWritable)((Object)iterator.next())).get();
                }
                finally {
                    Closeables.close(iterator, true);
                }
                int outDim = conf.getInt(TimesSquaredJob.OUTPUT_VECTOR_DIMENSION, Integer.MAX_VALUE);
                this.outputVector = conf.getBoolean(TimesSquaredJob.IS_SPARSE_OUTPUT, false) ? new RandomAccessSparseVector(outDim, 10) : new DenseVector(outDim);
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        }

        public void map(T rowNum, VectorWritable v, OutputCollector<NullWritable, VectorWritable> out, Reporter rep) throws IOException {
            this.setOut(out);
            double d = this.scale(v);
            if (d == 1.0) {
                this.outputVector.assign(v.get(), Functions.PLUS);
            } else if (d != 0.0) {
                this.outputVector.assign(v.get(), Functions.plusMult(d));
            }
        }

        protected double scale(VectorWritable v) {
            return v.get().dot(this.inputVector);
        }

        public void close() throws IOException {
            if (this.out != null) {
                this.out.collect((Object)NullWritable.get(), (Object)new VectorWritable(this.outputVector));
            }
        }
    }
}

