/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stats;

import java.io.IOException;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;

public class StandardDeviationCalculatorMapper
extends Mapper<IntWritable, Writable, IntWritable, DoubleWritable> {
    public static final IntWritable SUM_OF_SQUARES = new IntWritable(1);
    public static final IntWritable SUM = new IntWritable(2);
    public static final IntWritable TOTAL_COUNT = new IntWritable(-1);

    protected void map(IntWritable key, Writable value, Mapper.Context context) throws IOException, InterruptedException {
        if (key.get() == -1) {
            return;
        }
        double df = Double.NaN;
        if (value instanceof LongWritable) {
            df = ((LongWritable)value).get();
        } else if (value instanceof DoubleWritable) {
            df = ((DoubleWritable)value).get();
        }
        if (!Double.isNaN(df)) {
            context.write((Object)SUM_OF_SQUARES, (Object)new DoubleWritable(df * df));
            context.write((Object)SUM, (Object)new DoubleWritable(df));
            context.write((Object)TOTAL_COUNT, (Object)new DoubleWritable(1.0));
        }
    }
}

