/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.list;

import org.apache.mahout.collections.Arithmetic;
import org.apache.mahout.math.Arrays;
import org.apache.mahout.math.BinarySearch;
import org.apache.mahout.math.function.LongProcedure;
import org.apache.mahout.math.list.AbstractLongList;

public class LongArrayList
extends AbstractLongList
implements Cloneable {
    private long[] elements;

    public LongArrayList() {
        this(10);
    }

    public LongArrayList(long[] elements) {
        this.elements(elements);
    }

    public LongArrayList(int initialCapacity) {
        this(new long[initialCapacity]);
        this.setSizeRaw(0);
    }

    @Override
    public void add(long element) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = element;
    }

    @Override
    public void beforeInsert(int index, long element) {
        if (this.size == index) {
            this.add(element);
            return;
        }
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        this.elements[index] = element;
        ++this.size;
    }

    @Override
    public int binarySearchFromTo(long key, int from, int to) {
        return BinarySearch.binarySearchFromTo(this.elements, key, from, to);
    }

    @Override
    public Object clone() {
        LongArrayList clone = new LongArrayList((long[])this.elements.clone());
        clone.setSizeRaw(this.size);
        return clone;
    }

    public LongArrayList copy() {
        return (LongArrayList)this.clone();
    }

    @Override
    public long[] elements() {
        return this.elements;
    }

    @Override
    public AbstractLongList elements(long[] elements) {
        this.elements = elements;
        this.size = elements.length;
        return this;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements = Arrays.ensureCapacity(this.elements, minCapacity);
    }

    @Override
    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (!(otherObj instanceof LongArrayList)) {
            return super.equals(otherObj);
        }
        if (this == otherObj) {
            return true;
        }
        LongArrayList other = (LongArrayList)otherObj;
        if (this.size() != other.size()) {
            return false;
        }
        long[] theElements = this.elements();
        long[] otherElements = other.elements();
        int i = this.size();
        while (--i >= 0) {
            if (theElements[i] == otherElements[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEach(LongProcedure procedure) {
        long[] theElements = this.elements;
        int theSize = this.size;
        int i = 0;
        while (i < theSize) {
            if (procedure.apply(theElements[i++])) continue;
            return false;
        }
        return true;
    }

    @Override
    public long get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.elements[index];
    }

    @Override
    public long getQuick(int index) {
        return this.elements[index];
    }

    @Override
    public int indexOfFromTo(long element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        LongArrayList.checkRangeFromTo(from, to, this.size);
        long[] theElements = this.elements;
        for (int i = from; i <= to; ++i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOfFromTo(long element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        LongArrayList.checkRangeFromTo(from, to, this.size);
        long[] theElements = this.elements;
        for (int i = to; i >= from; --i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public AbstractLongList partFromTo(int from, int to) {
        if (this.size == 0) {
            return new LongArrayList(0);
        }
        LongArrayList.checkRangeFromTo(from, to, this.size);
        long[] part = new long[to - from + 1];
        System.arraycopy(this.elements, from, part, 0, to - from + 1);
        return new LongArrayList(part);
    }

    @Override
    public boolean removeAll(AbstractLongList other) {
        double M;
        if (!(other instanceof LongArrayList)) {
            return super.removeAll(other);
        }
        if (other.isEmpty()) {
            return false;
        }
        int limit = other.size() - 1;
        int j = 0;
        long[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * Arithmetic.log2(N) < M * N) {
            LongArrayList sortedList = (LongArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    @Override
    public void replaceFromToWithFrom(int from, int to, AbstractLongList other, int otherFrom) {
        if (!(other instanceof LongArrayList)) {
            super.replaceFromToWithFrom(from, to, other, otherFrom);
            return;
        }
        int length = to - from + 1;
        if (length > 0) {
            LongArrayList.checkRangeFromTo(from, to, this.size());
            LongArrayList.checkRangeFromTo(otherFrom, otherFrom + length - 1, other.size());
            System.arraycopy(((LongArrayList)other).elements, otherFrom, this.elements, from, length);
        }
    }

    @Override
    public boolean retainAll(AbstractLongList other) {
        double M;
        if (!(other instanceof LongArrayList)) {
            return super.retainAll(other);
        }
        int limit = other.size() - 1;
        int j = 0;
        long[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * Arithmetic.log2(N) < M * N) {
            LongArrayList sortedList = (LongArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    @Override
    public void reverse() {
        int limit = this.size / 2;
        int j = this.size - 1;
        long[] theElements = this.elements;
        int i = 0;
        while (i < limit) {
            long tmp = theElements[i];
            theElements[i++] = theElements[j];
            theElements[j--] = tmp;
        }
    }

    @Override
    public void set(int index, long element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.elements[index] = element;
    }

    @Override
    public void setQuick(int index, long element) {
        this.elements[index] = element;
    }

    @Override
    public void sortFromTo(int from, int to) {
        if (this.size == 0) {
            return;
        }
        LongArrayList.checkRangeFromTo(from, to, this.size);
        long min = this.elements[from];
        long max = this.elements[from];
        long[] theElements = this.elements;
        int i = from + 1;
        while (i <= to) {
            long elem;
            if ((elem = theElements[i++]) > max) {
                max = elem;
                continue;
            }
            if (elem >= min) continue;
            min = elem;
        }
        this.quickSortFromTo(from, to);
    }

    @Override
    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

