/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.option;

import java.util.Comparator;
import java.util.Set;
import org.apache.commons.cli2.HelpLine;
import org.apache.commons.cli2.Option;

public class HelpLineImpl
implements HelpLine {
    private final Option option;
    private final int indent;
    private transient Set cachedHelpSettings;
    private transient Comparator cachedComparator;
    private transient String cachedUsage;

    public HelpLineImpl(Option option, int indent) {
        this.option = option;
        this.indent = indent;
    }

    public String getDescription() {
        return this.option.getDescription();
    }

    public int getIndent() {
        return this.indent;
    }

    public Option getOption() {
        return this.option;
    }

    public String usage(Set helpSettings, Comparator comparator) {
        if (this.cachedUsage == null || this.cachedHelpSettings != helpSettings || this.cachedComparator != comparator) {
            this.cachedHelpSettings = helpSettings;
            this.cachedComparator = comparator;
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < this.indent; ++i) {
                buffer.append("  ");
            }
            this.option.appendUsage(buffer, helpSettings, comparator);
            this.cachedUsage = buffer.toString();
        }
        return this.cachedUsage;
    }
}

