/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.store.Directory;

public class OpenReaderTask
extends PerfTask {
    public static final String USER_DATA = "userData";
    private String commitUserData = null;

    public OpenReaderTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public int doLogic() throws IOException {
        Directory dir = this.getRunData().getDirectory();
        DirectoryReader r = null;
        r = this.commitUserData != null ? DirectoryReader.open(OpenReaderTask.findIndexCommit(dir, this.commitUserData)) : DirectoryReader.open(dir);
        this.getRunData().setIndexReader(r);
        r.decRef();
        return 1;
    }

    @Override
    public void setParams(String params) {
        String[] split;
        super.setParams(params);
        if (params != null && (split = params.split(",")).length > 0) {
            this.commitUserData = split[0];
        }
    }

    @Override
    public boolean supportsParams() {
        return true;
    }

    public static IndexCommit findIndexCommit(Directory dir, String userData) throws IOException {
        List<IndexCommit> commits = DirectoryReader.listCommits(dir);
        for (IndexCommit ic : commits) {
            Map<String, String> map = ic.getUserData();
            String ud = null;
            if (map != null) {
                ud = map.get(USER_DATA);
            }
            if (ud == null || !ud.equals(userData)) continue;
            return ic;
        }
        throw new IOException("index does not contain commit with userData: " + userData);
    }
}

