/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.quality.utils;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.IndexSearcher;

public class DocNameExtractor {
    private final String docNameField;

    public DocNameExtractor(String docNameField) {
        this.docNameField = docNameField;
    }

    public String docName(IndexSearcher searcher, int docid) throws IOException {
        final ArrayList name = new ArrayList();
        searcher.getIndexReader().document(docid, new StoredFieldVisitor(){

            @Override
            public void stringField(FieldInfo fieldInfo, String value) {
                name.add(value);
            }

            @Override
            public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
                if (!name.isEmpty()) {
                    return StoredFieldVisitor.Status.STOP;
                }
                if (fieldInfo.name.equals(DocNameExtractor.this.docNameField)) {
                    return StoredFieldVisitor.Status.YES;
                }
                return StoredFieldVisitor.Status.NO;
            }
        });
        if (name.size() != 0) {
            return (String)name.get(0);
        }
        return null;
    }
}

