/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public final class PrefAndSimilarityColumnWritable
implements Writable {
    private float prefValue;
    private Vector similarityColumn;

    public PrefAndSimilarityColumnWritable() {
    }

    public PrefAndSimilarityColumnWritable(float prefValue, Vector similarityColumn) {
        this.set(prefValue, similarityColumn);
    }

    public void set(float prefValue, Vector similarityColumn) {
        this.prefValue = prefValue;
        this.similarityColumn = similarityColumn;
    }

    public float getPrefValue() {
        return this.prefValue;
    }

    public Vector getSimilarityColumn() {
        return this.similarityColumn;
    }

    public void readFields(DataInput in) throws IOException {
        this.prefValue = in.readFloat();
        VectorWritable vw = new VectorWritable();
        vw.readFields(in);
        this.similarityColumn = vw.get();
    }

    public void write(DataOutput out) throws IOException {
        out.writeFloat(this.prefValue);
        VectorWritable vw = new VectorWritable(this.similarityColumn);
        vw.setWritesLaxPrecision(true);
        vw.write(out);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PrefAndSimilarityColumnWritable) {
            PrefAndSimilarityColumnWritable other = (PrefAndSimilarityColumnWritable)obj;
            return this.prefValue == other.prefValue && this.similarityColumn.equals(other.similarityColumn);
        }
        return false;
    }

    public int hashCode() {
        return RandomUtils.hashFloat(this.prefValue) + 31 * this.similarityColumn.hashCode();
    }
}

