/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.mahout.cf.taste.impl.common.InvertedRunningAverage;
import org.apache.mahout.cf.taste.impl.common.RunningAverage;

public class WeightedRunningAverage
implements RunningAverage,
Serializable {
    private double totalWeight = 0.0;
    private double average = Double.NaN;

    @Override
    public synchronized void addDatum(double datum) {
        this.addDatum(datum, 1.0);
    }

    public synchronized void addDatum(double datum, double weight) {
        double oldTotalWeight = this.totalWeight;
        this.totalWeight += weight;
        this.average = oldTotalWeight <= 0.0 ? datum : this.average * oldTotalWeight / this.totalWeight + datum * weight / this.totalWeight;
    }

    @Override
    public synchronized void removeDatum(double datum) {
        this.removeDatum(datum, 1.0);
    }

    public synchronized void removeDatum(double datum, double weight) {
        double oldTotalWeight = this.totalWeight;
        this.totalWeight -= weight;
        if (this.totalWeight <= 0.0) {
            this.average = Double.NaN;
            this.totalWeight = 0.0;
        } else {
            this.average = this.average * oldTotalWeight / this.totalWeight - datum * weight / this.totalWeight;
        }
    }

    @Override
    public synchronized void changeDatum(double delta) {
        this.changeDatum(delta, 1.0);
    }

    public synchronized void changeDatum(double delta, double weight) {
        Preconditions.checkArgument(weight <= this.totalWeight, "weight must be <= totalWeight");
        this.average += delta * weight / this.totalWeight;
    }

    public synchronized double getTotalWeight() {
        return this.totalWeight;
    }

    @Override
    public synchronized int getCount() {
        return (int)this.totalWeight;
    }

    @Override
    public synchronized double getAverage() {
        return this.average;
    }

    @Override
    public RunningAverage inverse() {
        return new InvertedRunningAverage(this);
    }

    public synchronized String toString() {
        return String.valueOf(this.average);
    }
}

