/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common.jdbc;

import com.google.common.collect.AbstractIterator;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.mahout.common.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EachRowIterator
extends AbstractIterator<ResultSet>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(EachRowIterator.class);
    private final Connection connection;
    private final PreparedStatement statement;
    private final ResultSet resultSet;

    EachRowIterator(DataSource dataSource, String sqlQuery) throws SQLException {
        try {
            this.connection = dataSource.getConnection();
            this.statement = this.connection.prepareStatement(sqlQuery, 1003, 1007);
            this.statement.setFetchDirection(1000);
            log.debug("Executing SQL query: {}", (Object)sqlQuery);
            this.resultSet = this.statement.executeQuery();
        }
        catch (SQLException sqle) {
            this.close();
            throw sqle;
        }
    }

    @Override
    protected ResultSet computeNext() {
        try {
            if (this.resultSet.next()) {
                return this.resultSet;
            }
            this.close();
            return null;
        }
        catch (SQLException sqle) {
            this.close();
            throw new IllegalStateException(sqle);
        }
    }

    public void skip(int n) throws SQLException {
        try {
            this.resultSet.relative(n);
        }
        catch (SQLException sqle) {
            for (int i = 0; i < n && this.resultSet.next(); ++i) {
            }
        }
    }

    @Override
    public void close() {
        IOUtils.quietClose(this.resultSet, this.statement, this.connection);
        this.endOfData();
    }
}

