/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model.jdbc;

import com.google.common.io.Closeables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.jdbc.AbstractJDBCComponent;
import org.apache.mahout.cf.taste.impl.model.jdbc.AbstractJDBCDataModel;

public final class GenericJDBCDataModel
extends AbstractJDBCDataModel {
    public static final String DATA_SOURCE_KEY = "dataSource";
    public static final String GET_PREFERENCE_SQL_KEY = "getPreferenceSQL";
    public static final String GET_PREFERENCE_TIME_SQL_KEY = "getPreferenceTimeSQL";
    public static final String GET_USER_SQL_KEY = "getUserSQL";
    public static final String GET_ALL_USERS_SQL_KEY = "getAllUsersSQL";
    public static final String GET_NUM_USERS_SQL_KEY = "getNumUsersSQL";
    public static final String GET_NUM_ITEMS_SQL_KEY = "getNumItemsSQL";
    public static final String SET_PREFERENCE_SQL_KEY = "setPreferenceSQL";
    public static final String REMOVE_PREFERENCE_SQL_KEY = "removePreferenceSQL";
    public static final String GET_USERS_SQL_KEY = "getUsersSQL";
    public static final String GET_ITEMS_SQL_KEY = "getItemsSQL";
    public static final String GET_PREFS_FOR_ITEM_SQL_KEY = "getPrefsForItemSQL";
    public static final String GET_NUM_PREFERENCE_FOR_ITEM_KEY = "getNumPreferenceForItemSQL";
    public static final String GET_NUM_PREFERENCE_FOR_ITEMS_KEY = "getNumPreferenceForItemsSQL";
    public static final String GET_MAX_PREFERENCE_KEY = "getMaxPreferenceSQL";
    public static final String GET_MIN_PREFERENCE_KEY = "getMinPreferenceSQL";

    public GenericJDBCDataModel(Properties props) throws TasteException {
        super(AbstractJDBCComponent.lookupDataSource(props.getProperty(DATA_SOURCE_KEY)), props.getProperty(GET_PREFERENCE_SQL_KEY), props.getProperty(GET_PREFERENCE_TIME_SQL_KEY), props.getProperty(GET_USER_SQL_KEY), props.getProperty(GET_ALL_USERS_SQL_KEY), props.getProperty(GET_NUM_ITEMS_SQL_KEY), props.getProperty(GET_NUM_USERS_SQL_KEY), props.getProperty(SET_PREFERENCE_SQL_KEY), props.getProperty(REMOVE_PREFERENCE_SQL_KEY), props.getProperty(GET_USERS_SQL_KEY), props.getProperty(GET_ITEMS_SQL_KEY), props.getProperty(GET_PREFS_FOR_ITEM_SQL_KEY), props.getProperty(GET_NUM_PREFERENCE_FOR_ITEM_KEY), props.getProperty(GET_NUM_PREFERENCE_FOR_ITEMS_KEY), props.getProperty(GET_MAX_PREFERENCE_KEY), props.getProperty(GET_MIN_PREFERENCE_KEY));
    }

    public GenericJDBCDataModel(File propertiesFile) throws TasteException {
        this(GenericJDBCDataModel.getPropertiesFromFile(propertiesFile));
    }

    public GenericJDBCDataModel(String resourcePath) throws TasteException {
        this(GenericJDBCDataModel.getPropertiesFromStream(GenericJDBCDataModel.class.getResourceAsStream(resourcePath)));
    }

    private static Properties getPropertiesFromFile(File file) throws TasteException {
        try {
            return GenericJDBCDataModel.getPropertiesFromStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fnfe) {
            throw new TasteException(fnfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPropertiesFromStream(InputStream is) throws TasteException {
        Properties properties;
        try {
            Properties props = new Properties();
            props.load(is);
            properties = props;
        }
        catch (Throwable throwable) {
            try {
                Closeables.close(is, true);
                throw throwable;
            }
            catch (IOException ioe) {
                throw new TasteException(ioe);
            }
        }
        Closeables.close(is, true);
        return properties;
    }
}

