/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes;

import org.apache.mahout.classifier.naivebayes.AbstractNaiveBayesClassifier;
import org.apache.mahout.classifier.naivebayes.NaiveBayesModel;

public class ComplementaryNaiveBayesClassifier
extends AbstractNaiveBayesClassifier {
    public ComplementaryNaiveBayesClassifier(NaiveBayesModel model) {
        super(model);
    }

    @Override
    public double getScoreForLabelFeature(int label, int feature) {
        NaiveBayesModel model = this.getModel();
        return ComplementaryNaiveBayesClassifier.computeWeight(model.featureWeight(feature), model.weight(label, feature), model.totalWeightSum(), model.labelWeight(label), model.alphaI(), model.numFeatures());
    }

    public static double computeWeight(double featureWeight, double featureLabelWeight, double totalWeight, double labelWeight, double alphaI, double numFeatures) {
        double numerator = featureWeight - featureLabelWeight + alphaI;
        double denominator = totalWeight - labelWeight + alphaI * numFeatures;
        return -Math.log(numerator / denominator);
    }
}

