/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.apache.hadoop.mapred.lib.MultipleOutputs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtils {
    private static final Logger log = LoggerFactory.getLogger(IOUtils.class);

    private IOUtils() {
    }

    public static void quietClose(ResultSet closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (SQLException sqle) {
                log.warn("Unexpected exception while closing; continuing", (Throwable)sqle);
            }
        }
    }

    public static void quietClose(Statement closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (SQLException sqle) {
                log.warn("Unexpected exception while closing; continuing", (Throwable)sqle);
            }
        }
    }

    public static void quietClose(Connection closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (SQLException sqle) {
                log.warn("Unexpected exception while closing; continuing", (Throwable)sqle);
            }
        }
    }

    public static void quietClose(ResultSet resultSet, Statement statement, Connection connection) {
        IOUtils.quietClose(resultSet);
        IOUtils.quietClose(statement);
        IOUtils.quietClose(connection);
    }

    public static void close(Collection<? extends Closeable> closeables) throws IOException {
        Throwable lastThr = null;
        for (Closeable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (Throwable thr) {
                log.error(thr.getMessage(), thr);
                lastThr = thr;
            }
        }
        closeables.clear();
        if (lastThr != null) {
            if (lastThr instanceof IOException) {
                throw (IOException)lastThr;
            }
            if (lastThr instanceof RuntimeException) {
                throw (RuntimeException)lastThr;
            }
            if (lastThr instanceof Error) {
                throw (Error)lastThr;
            }
            throw (IOException)new IOException("Unexpected exception during close").initCause(lastThr);
        }
    }

    public static class MultipleOutputsCloseableAdapter
    implements Closeable {
        private final MultipleOutputs mo;

        public MultipleOutputsCloseableAdapter(MultipleOutputs mo) {
            this.mo = mo;
        }

        @Override
        public void close() throws IOException {
            if (this.mo != null) {
                this.mo.close();
            }
        }
    }

    public static class DeleteFileOnClose
    implements Closeable {
        private final File file;

        public DeleteFileOnClose(File file) {
            this.file = file;
        }

        @Override
        public void close() throws IOException {
            if (this.file.isFile()) {
                this.file.delete();
            }
        }
    }
}

