/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixView;
import org.apache.mahout.math.PermutedVectorView;
import org.apache.mahout.math.Vector;

public class PivotedMatrix
extends AbstractMatrix {
    private Matrix base;
    private int[] rowPivot;
    private int[] rowUnpivot;
    private int[] columnPivot;
    private int[] columnUnpivot;

    public PivotedMatrix(Matrix base, int[] pivot) {
        this(base, pivot, Arrays.copyOf(pivot, pivot.length));
    }

    public PivotedMatrix(Matrix base, int[] rowPivot, int[] columnPivot) {
        super(base.rowSize(), base.columnSize());
        this.base = base;
        this.rowPivot = rowPivot;
        this.rowUnpivot = PivotedMatrix.invert(rowPivot);
        this.columnPivot = columnPivot;
        this.columnUnpivot = PivotedMatrix.invert(columnPivot);
    }

    public PivotedMatrix(Matrix base) {
        this(base, PivotedMatrix.identityPivot(base.rowSize()), PivotedMatrix.identityPivot(base.columnSize()));
    }

    public void swap(int i, int j) {
        this.swapRows(i, j);
        this.swapColumns(i, j);
    }

    public void swapRows(int i, int j) {
        PivotedMatrix.swap(this.rowPivot, this.rowUnpivot, i, j);
    }

    public void swapColumns(int i, int j) {
        PivotedMatrix.swap(this.columnPivot, this.columnUnpivot, i, j);
    }

    private static void swap(int[] pivot, int[] unpivot, int i, int j) {
        Preconditions.checkPositionIndex(i, pivot.length);
        Preconditions.checkPositionIndex(j, pivot.length);
        if (i != j) {
            int tmp = pivot[i];
            pivot[i] = pivot[j];
            pivot[j] = tmp;
            unpivot[pivot[i]] = i;
            unpivot[pivot[j]] = j;
        }
    }

    @Override
    public Matrix assignColumn(int column, Vector other) {
        return this.base.assignColumn(this.columnPivot[column], new PermutedVectorView(other, this.rowUnpivot, this.rowPivot));
    }

    @Override
    public Matrix assignRow(int row, Vector other) {
        return this.base.assignRow(this.rowPivot[row], new PermutedVectorView(other, this.columnUnpivot, this.columnPivot));
    }

    @Override
    public Vector viewColumn(int column) {
        if (column < 0 || column >= this.columnSize()) {
            throw new IndexException(column, this.columnSize());
        }
        return new PermutedVectorView(this.base.viewColumn(this.columnPivot[column]), this.rowPivot, this.rowUnpivot);
    }

    @Override
    public Vector viewRow(int row) {
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexException(row, this.rowSize());
        }
        return new PermutedVectorView(this.base.viewRow(this.rowPivot[row]), this.columnPivot, this.columnUnpivot);
    }

    @Override
    public double getQuick(int row, int column) {
        return this.base.getQuick(this.rowPivot[row], this.columnPivot[column]);
    }

    @Override
    public Matrix like() {
        return new PivotedMatrix(this.base.like());
    }

    @Override
    public Matrix clone() {
        PivotedMatrix clone = (PivotedMatrix)super.clone();
        this.base = this.base.clone();
        this.rowPivot = (int[])this.rowPivot.clone();
        this.rowUnpivot = (int[])this.rowUnpivot.clone();
        this.columnPivot = (int[])this.columnPivot.clone();
        this.columnUnpivot = (int[])this.columnUnpivot.clone();
        return clone;
    }

    @Override
    public Matrix like(int rows, int columns) {
        return new PivotedMatrix(this.base.like(rows, columns));
    }

    @Override
    public void setQuick(int row, int column, double value) {
        this.base.setQuick(this.rowPivot[row], this.columnPivot[column], value);
    }

    @Override
    public int[] getNumNondefaultElements() {
        return this.base.getNumNondefaultElements();
    }

    @Override
    public Matrix viewPart(int[] offset, int[] size) {
        return new MatrixView(this, offset, size);
    }

    public int rowUnpivot(int k) {
        return this.rowUnpivot[k];
    }

    public int columnUnpivot(int k) {
        return this.columnUnpivot[k];
    }

    public int[] getRowPivot() {
        return this.rowPivot;
    }

    public int[] getInverseRowPivot() {
        return this.rowUnpivot;
    }

    public int[] getColumnPivot() {
        return this.columnPivot;
    }

    public int[] getInverseColumnPivot() {
        return this.columnUnpivot;
    }

    public Matrix getBase() {
        return this.base;
    }

    private static int[] identityPivot(int n) {
        int[] pivot = new int[n];
        for (int i = 0; i < n; ++i) {
            pivot[i] = i;
        }
        return pivot;
    }

    private static int[] invert(int[] pivot) {
        int[] x = new int[pivot.length];
        for (int i = 0; i < pivot.length; ++i) {
            x[pivot[i]] = i;
        }
        return x;
    }
}

