/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.similarity.SeedVectorUtil;

public final class VectorDistanceInvertedMapper
extends Mapper<WritableComparable<?>, VectorWritable, Text, VectorWritable> {
    private DistanceMeasure measure;
    private List<NamedVector> seedVectors;

    protected void map(WritableComparable<?> key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
        Vector valVec = value.get();
        String keyName = valVec instanceof NamedVector ? ((NamedVector)valVec).getName() : key.toString();
        DenseVector outVec = new DenseVector(new double[this.seedVectors.size()]);
        int i = 0;
        for (NamedVector seedVector : this.seedVectors) {
            outVec.setQuick(i++, this.measure.distance(seedVector, valVec));
        }
        context.write((Object)new Text(keyName), (Object)new VectorWritable(outVec));
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        this.measure = ClassUtils.instantiateAs(conf.get("vectorDistSim.measure"), DistanceMeasure.class);
        this.measure.configure(conf);
        this.seedVectors = SeedVectorUtil.loadSeedVectors(conf);
    }
}

