/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.StringTuple;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.SquaredEuclideanDistanceMeasure;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.similarity.VectorDistanceInvertedMapper;
import org.apache.mahout.math.hadoop.similarity.VectorDistanceMapper;

public class VectorDistanceSimilarityJob
extends AbstractJob {
    public static final String SEEDS = "seeds";
    public static final String SEEDS_PATH_KEY = "seedsPath";
    public static final String DISTANCE_MEASURE_KEY = "vectorDistSim.measure";
    public static final String OUT_TYPE_KEY = "outType";
    public static final String MAX_DISTANCE = "maxDistance";

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new VectorDistanceSimilarityJob(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        String maxDistanceArg;
        this.addInputOption();
        this.addOutputOption();
        this.addOption(DefaultOptionCreator.distanceMeasureOption().create());
        this.addOption(SEEDS, "s", "The set of vectors to compute distances against.  Must fit in memory on the mapper");
        this.addOption(MAX_DISTANCE, "mx", "set an upper-bound on distance (double) such that any pair of vectors with a distance greater than this value is ignored in the output. Ignored for non pairwise output!");
        this.addOption(DefaultOptionCreator.overwriteOption().create());
        this.addOption(OUT_TYPE_KEY, "ot", "[pw|v] -- Define the output style: pairwise, the default, (pw) or vector (v).  Pairwise is a tuple of <seed, other, distance>, vector is <other, <Vector of size the number of seeds>>.", "pw");
        if (this.parseArguments(args) == null) {
            return -1;
        }
        Path input = this.getInputPath();
        Path output = this.getOutputPath();
        Path seeds = new Path(this.getOption(SEEDS));
        String measureClass = this.getOption("distanceMeasure");
        if (measureClass == null) {
            measureClass = SquaredEuclideanDistanceMeasure.class.getName();
        }
        if (this.hasOption("overwrite")) {
            HadoopUtil.delete(this.getConf(), output);
        }
        DistanceMeasure measure = ClassUtils.instantiateAs(measureClass, DistanceMeasure.class);
        String outType = this.getOption(OUT_TYPE_KEY, "pw");
        Double maxDistance = null;
        if ("pw".equals(outType) && (maxDistanceArg = this.getOption(MAX_DISTANCE)) != null) {
            maxDistance = Double.parseDouble(maxDistanceArg);
            Preconditions.checkArgument(maxDistance > 0.0, "value for maxDistance must be greater than zero");
        }
        VectorDistanceSimilarityJob.run(this.getConf(), input, seeds, output, measure, outType, maxDistance);
        return 0;
    }

    public static void run(Configuration conf, Path input, Path seeds, Path output, DistanceMeasure measure, String outType) throws IOException, ClassNotFoundException, InterruptedException {
        VectorDistanceSimilarityJob.run(conf, input, seeds, output, measure, outType, null);
    }

    public static void run(Configuration conf, Path input, Path seeds, Path output, DistanceMeasure measure, String outType, Double maxDistance) throws IOException, ClassNotFoundException, InterruptedException {
        if (maxDistance != null) {
            conf.set(MAX_DISTANCE, String.valueOf(maxDistance));
        }
        conf.set(DISTANCE_MEASURE_KEY, measure.getClass().getName());
        conf.set(SEEDS_PATH_KEY, seeds.toString());
        Job job = new Job(conf, "Vector Distance Similarity: seeds: " + seeds + " input: " + input);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        if ("pw".equalsIgnoreCase(outType)) {
            job.setMapOutputKeyClass(StringTuple.class);
            job.setOutputKeyClass(StringTuple.class);
            job.setMapOutputValueClass(DoubleWritable.class);
            job.setOutputValueClass(DoubleWritable.class);
            job.setMapperClass(VectorDistanceMapper.class);
        } else if ("v".equalsIgnoreCase(outType)) {
            job.setMapOutputKeyClass(Text.class);
            job.setOutputKeyClass(Text.class);
            job.setMapOutputValueClass(VectorWritable.class);
            job.setOutputValueClass(VectorWritable.class);
            job.setMapperClass(VectorDistanceInvertedMapper.class);
        } else {
            throw new IllegalArgumentException("Invalid outType specified: " + outType);
        }
        job.setNumReduceTasks(0);
        FileInputFormat.addInputPath((Job)job, (Path)input);
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        job.setJarByClass(VectorDistanceSimilarityJob.class);
        HadoopUtil.delete(conf, output);
        if (!job.waitForCompletion(true)) {
            throw new IllegalStateException("VectorDistance Similarity failed processing " + seeds);
        }
    }
}

