/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Random;
import org.apache.mahout.math.Vector;

public class Sampler {
    private final Random random;
    private final double[] sampler;

    public Sampler(Random random) {
        this.random = random;
        this.sampler = null;
    }

    public Sampler(Random random, double[] sampler) {
        this.random = random;
        this.sampler = sampler;
    }

    public Sampler(Random random, Vector distribution) {
        this.random = random;
        this.sampler = Sampler.samplerFor(distribution);
    }

    public int sample(Vector distribution) {
        return this.sample(Sampler.samplerFor(distribution));
    }

    public int sample() {
        Preconditions.checkNotNull(this.sampler, "Sampler must have been constructed with a distribution, or else sample(Vector) should be used to sample");
        return this.sample(this.sampler);
    }

    private static double[] samplerFor(Vector vectorDistribution) {
        int size = vectorDistribution.size();
        double[] partition = new double[size];
        double norm = vectorDistribution.norm(1.0);
        double sum = 0.0;
        for (int i = 0; i < size; ++i) {
            partition[i] = sum += vectorDistribution.get(i) / norm;
        }
        return partition;
    }

    private int sample(double[] sampler) {
        int index = Arrays.binarySearch(sampler, this.random.nextDouble());
        return index < 0 ? -(index + 1) : index;
    }
}

