/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.IOContext;
import org.apache.mahout.text.LuceneSegmentInputSplit;
import org.apache.mahout.text.LuceneSeqFileHelper;
import org.apache.mahout.text.LuceneStorageConfiguration;

public class SequenceFilesFromLuceneStorageMapper
extends Mapper<Text, NullWritable, Text, Text> {
    private LuceneStorageConfiguration l2sConf;
    private SegmentReader segmentReader;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        this.l2sConf = new LuceneStorageConfiguration(configuration);
        LuceneSegmentInputSplit inputSplit = (LuceneSegmentInputSplit)context.getInputSplit();
        SegmentCommitInfo segmentInfo = inputSplit.getSegment(configuration);
        this.segmentReader = new SegmentReader(segmentInfo, 1, IOContext.READ);
    }

    protected void map(Text key, NullWritable text, Mapper.Context context) throws IOException, InterruptedException {
        int docId = Integer.valueOf(key.toString());
        DocumentStoredFieldVisitor storedFieldVisitor = this.l2sConf.getStoredFieldVisitor();
        this.segmentReader.document(docId, storedFieldVisitor);
        Document document = storedFieldVisitor.getDocument();
        List<String> fields = this.l2sConf.getFields();
        Text theKey = new Text(Strings.nullToEmpty(document.get(this.l2sConf.getIdField())));
        Text theValue = new Text();
        LuceneSeqFileHelper.populateValues(document, theValue, fields);
        if (StringUtils.isBlank((String)theKey.toString()) && StringUtils.isBlank((String)theValue.toString())) {
            context.getCounter((Enum)DataStatus.EMPTY_BOTH).increment(1L);
            return;
        }
        if (StringUtils.isBlank((String)theKey.toString())) {
            context.getCounter((Enum)DataStatus.EMPTY_KEY).increment(1L);
        } else if (StringUtils.isBlank((String)theValue.toString())) {
            context.getCounter((Enum)DataStatus.EMPTY_VALUE).increment(1L);
        }
        context.write((Object)theKey, (Object)theValue);
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        this.segmentReader.close();
    }

    public static enum DataStatus {
        EMPTY_KEY,
        EMPTY_VALUE,
        EMPTY_BOTH;

    }
}

