/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.lucene.AnalyzerUtils;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.vectorizer.encoders.FeatureVectorEncoder;
import org.apache.mahout.vectorizer.encoders.LuceneTextValueEncoder;

public class EncodingMapper
extends Mapper<Text, Text, Text, VectorWritable> {
    public static final String USE_NAMED_VECTORS = "namedVectors";
    public static final String USE_SEQUENTIAL = "sequential";
    public static final String ANALYZER_NAME = "analyzer";
    public static final String ENCODER_FIELD_NAME = "encoderFieldName";
    public static final String ENCODER_CLASS = "encoderClass";
    public static final String CARDINALITY = "cardinality";
    private boolean sequentialVectors;
    private boolean namedVectors;
    private FeatureVectorEncoder encoder;
    private int cardinality;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        Analyzer analyzer;
        Configuration conf = context.getConfiguration();
        this.sequentialVectors = conf.getBoolean(USE_SEQUENTIAL, false);
        this.namedVectors = conf.getBoolean(USE_NAMED_VECTORS, false);
        String analyzerName = conf.get(ANALYZER_NAME, StandardAnalyzer.class.getName());
        try {
            analyzer = AnalyzerUtils.createAnalyzer(analyzerName);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to create Analyzer for name: " + analyzerName, e);
        }
        String encoderName = conf.get(ENCODER_FIELD_NAME, "text");
        this.cardinality = conf.getInt(CARDINALITY, 5000);
        String encClass = conf.get(ENCODER_CLASS);
        this.encoder = ClassUtils.instantiateAs(encClass, FeatureVectorEncoder.class, new Class[]{String.class}, new Object[]{encoderName});
        if (this.encoder instanceof LuceneTextValueEncoder) {
            ((LuceneTextValueEncoder)this.encoder).setAnalyzer(analyzer);
        }
    }

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        Vector vector = this.sequentialVectors ? new SequentialAccessSparseVector(this.cardinality) : new RandomAccessSparseVector(this.cardinality);
        if (this.namedVectors) {
            vector = new NamedVector(vector, key.toString());
        }
        this.encoder.addToVector(value.toString(), vector);
        context.write((Object)new Text(key.toString()), (Object)new VectorWritable(vector));
    }
}

