/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.term;

import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.common.StringTuple;
import org.apache.mahout.math.function.ObjectLongProcedure;
import org.apache.mahout.math.map.OpenObjectLongHashMap;

public class TermCountMapper
extends Mapper<Text, StringTuple, Text, LongWritable> {
    protected void map(Text key, StringTuple value, final Mapper.Context context) throws IOException, InterruptedException {
        OpenObjectLongHashMap<String> wordCount = new OpenObjectLongHashMap<String>();
        for (String word : value.getEntries()) {
            if (wordCount.containsKey(word)) {
                wordCount.put(word, wordCount.get(word) + 1L);
                continue;
            }
            wordCount.put(word, 1L);
        }
        wordCount.forEachPair(new ObjectLongProcedure<String>(){

            @Override
            public boolean apply(String first, long second) {
                try {
                    context.write((Object)new Text(first), (Object)new LongWritable(second));
                }
                catch (IOException e) {
                    context.getCounter("Exception", "Output IO Exception").increment(1L);
                }
                catch (InterruptedException e) {
                    context.getCounter("Exception", "Interrupted Exception").increment(1L);
                }
                return true;
            }
        });
    }
}

