/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup;

import com.google.common.collect.AbstractIterator;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.mahout.cf.taste.impl.common.SkippingIterator;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.FileLineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataFileIterator
extends AbstractIterator<Pair<PreferenceArray, long[]>>
implements SkippingIterator<Pair<PreferenceArray, long[]>>,
Closeable {
    private static final Pattern COLON_PATTERN = Pattern.compile(":");
    private static final Pattern PIPE_PATTERN = Pattern.compile("\\|");
    private static final Pattern TAB_PATTERN = Pattern.compile("\t");
    private final FileLineIterator lineIterator;
    private static final Logger log = LoggerFactory.getLogger(DataFileIterator.class);

    public DataFileIterator(File dataFile) throws IOException {
        if (dataFile == null || dataFile.isDirectory() || !dataFile.exists()) {
            throw new IllegalArgumentException("Bad data file: " + dataFile);
        }
        this.lineIterator = new FileLineIterator(dataFile);
    }

    protected Pair<PreferenceArray, long[]> computeNext() {
        int ratingsLeftToRead;
        if (!this.lineIterator.hasNext()) {
            return (Pair)this.endOfData();
        }
        String line = (String)this.lineIterator.next();
        String[] tokens = PIPE_PATTERN.split(line);
        long userID = Long.parseLong(tokens[0]);
        int ratingsRead = 0;
        GenericUserPreferenceArray currentUserPrefs = new GenericUserPreferenceArray(ratingsLeftToRead);
        long[] timestamps = new long[ratingsLeftToRead];
        for (ratingsLeftToRead = Integer.parseInt(tokens[1]); ratingsLeftToRead > 0; --ratingsLeftToRead) {
            line = (String)this.lineIterator.next();
            tokens = TAB_PATTERN.split(line);
            boolean hasPref = tokens.length == 2 || tokens.length == 4;
            boolean hasDate = tokens.length > 2;
            long itemID = Long.parseLong(tokens[0]);
            currentUserPrefs.setUserID(0, userID);
            currentUserPrefs.setItemID(ratingsRead, itemID);
            if (hasPref) {
                float preference = Float.parseFloat(tokens[1]);
                currentUserPrefs.setValue(ratingsRead, preference);
            }
            if (hasDate) {
                long timestamp = hasPref ? DataFileIterator.parseFakeTimestamp(tokens[2], tokens[3]) : DataFileIterator.parseFakeTimestamp(tokens[1], tokens[2]);
                timestamps[ratingsRead] = timestamp;
            }
            ++ratingsRead;
        }
        return new Pair((Object)currentUserPrefs, (Object)timestamps);
    }

    public void skip(int n) {
        for (int i = 0; i < n && this.lineIterator.hasNext(); ++i) {
            String line = (String)this.lineIterator.next();
            String[] tokens = PIPE_PATTERN.split(line);
            int linesToSKip = Integer.parseInt(tokens[1]);
            this.lineIterator.skip(linesToSKip);
        }
    }

    @Override
    public void close() {
        this.endOfData();
        try {
            Closeables.close((Closeable)this.lineIterator, (boolean)true);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private static long parseFakeTimestamp(String dateString, CharSequence timeString) {
        int days = Integer.parseInt(dateString);
        String[] timeTokens = COLON_PATTERN.split(timeString);
        int hours = Integer.parseInt(timeTokens[0]);
        int minutes = Integer.parseInt(timeTokens[1]);
        int seconds = Integer.parseInt(timeTokens[2]);
        return 86400L * (long)days + 3600L + (long)hours + 60L * (long)minutes + (long)seconds;
    }
}

