/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.email;

import java.io.IOException;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.math.VectorWritable;

public class PrepEmailMapper
extends Mapper<WritableComparable<?>, VectorWritable, Text, VectorWritable> {
    private static final Pattern DASH_DOT = Pattern.compile("-|\\.");
    private static final Pattern SLASH = Pattern.compile("\\/");
    private boolean useListName = false;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.useListName = Boolean.parseBoolean(context.getConfiguration().get("USE_LIST_NAME"));
    }

    protected void map(WritableComparable<?> key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
        String input = key.toString();
        String[] splits = SLASH.split(input);
        if (splits.length >= 3) {
            StringBuilder bldr = new StringBuilder();
            bldr.append(PrepEmailMapper.escape(splits[1]));
            if (this.useListName) {
                bldr.append('_').append(PrepEmailMapper.escape(splits[2]));
            }
            context.write((Object)new Text(bldr.toString()), (Object)value);
        }
    }

    private static String escape(CharSequence value) {
        return DASH_DOT.matcher(value).replaceAll("_").toLowerCase(Locale.ENGLISH);
    }
}

