/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestSerializable
extends TestCase {
    public TestSerializable(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TestSerializable.class);
    }

    public static Object cloneViaSerialization(Serializable obj) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(boas);
        oos.writeObject(obj);
        ByteArrayInputStream bias = new ByteArrayInputStream(boas.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bias);
        return ois.readObject();
    }

    public void testTestSerializable() throws IOException, ClassNotFoundException {
        WriteMe w = new WriteMe();
        w.foo = "hi there";
        w.bar = 1;
        WriteMe w2 = (WriteMe)TestSerializable.cloneViaSerialization(w);
        TestSerializable.assertTrue((w != w2 ? 1 : 0) != 0);
        TestSerializable.assertTrue((boolean)w.equals(w2));
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestSerializable(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestSerializable.suite();
        }
        TestRunner.run((Test)theSuite);
    }

    private static class WriteMe
    implements Serializable {
        String foo;
        int bar;

        private WriteMe() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WriteMe)) {
                return false;
            }
            WriteMe writeMe = (WriteMe)o;
            if (this.bar != writeMe.bar) {
                return false;
            }
            return !(this.foo != null ? !this.foo.equals(writeMe.foo) : writeMe.foo != null);
        }

        public int hashCode() {
            int result = this.foo != null ? this.foo.hashCode() : 0;
            result = 29 * result + this.bar;
            return result;
        }
    }
}

