/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.types.Matrixn;

abstract class AbstractAssignmentIterator
implements AssignmentIterator {
    protected VarSet vertsList;
    protected int max = 1;
    private int[] sizes;
    private Assignment assn = null;

    protected AbstractAssignmentIterator(VarSet verts) {
        this.vertsList = verts;
        this.initSizes();
    }

    private void initSizes() {
        this.sizes = new int[this.vertsList.size()];
        for (int i = 0; i < this.sizes.length; ++i) {
            Variable var = this.vertsList.get(i);
            if (var.isContinuous()) {
                throw new UnsupportedOperationException("Attempt to create AssignmentIterator over " + this.vertsList + ", but " + var + " is continuous.");
            }
            this.sizes[i] = var.getNumOutcomes();
        }
        this.max = this.vertsList.weight();
    }

    protected Assignment constructAssignment() {
        int current = this.indexOfCurrentAssn();
        if (this.sizes == null) {
            this.initSizes();
        }
        int[] outcomes = new int[this.sizes.length];
        Matrixn.singleToIndices(current, outcomes, this.sizes);
        Variable[] vars = this.vertsList.toArray(new Variable[0]);
        return new Assignment(vars, outcomes);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Attempt to remave assignment from Clique.");
    }

    @Override
    public Assignment assignment() {
        if (this.assn == null) {
            this.assn = this.constructAssignment();
            return this.assn;
        }
        int current = this.indexOfCurrentAssn();
        int[] outcomes = new int[this.sizes.length];
        Matrixn.singleToIndices(current, outcomes, this.sizes);
        this.assn.setRow(0, outcomes);
        return this.assn;
    }

    public Object next() {
        Assignment assn = this.assignment();
        this.advance();
        return assn;
    }
}

