/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CharSequenceReplace
extends Pipe
implements Serializable {
    public static final Pattern SKIP_SGML = Pattern.compile("<[^>]*>");
    Pattern regex;
    String replacement;
    public static final Pattern SKIP_HEADER = Pattern.compile("\\n\\n(.*)\\z", 32);
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public CharSequenceReplace(Pattern regex, String replacement) {
        this.regex = regex;
        this.replacement = replacement;
    }

    @Override
    public Instance pipe(Instance carrier) {
        String string = ((CharSequence)carrier.getData()).toString();
        Matcher m = this.regex.matcher(string);
        carrier.setData(m.replaceAll(this.replacement));
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.regex);
        out.writeObject(this.replacement);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.regex = (Pattern)in.readObject();
        this.replacement = (String)in.readObject();
    }
}

