/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.Serializable;
import java.util.BitSet;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.util.Resolvable;

public final class VerbFrame
implements Serializable {
    static final long serialVersionUID = 1450633678809744269L;
    private static VerbFrame[] _verbFrames;
    private static boolean _initalized;
    private Resolvable _frame;
    private int _index;
    private String _cachedToString = null;

    public static void initialize() {
        if (!_initalized) {
            int framesSize = Integer.parseInt(JWNL.resolveMessage("NUMBER_OF_VERB_FRAMES"));
            _verbFrames = new VerbFrame[framesSize];
            for (int i = 1; i <= framesSize; ++i) {
                VerbFrame._verbFrames[i - 1] = new VerbFrame(VerbFrame.getKeyString(i), i);
            }
            _initalized = true;
        }
    }

    public static final String getKeyString(int i) {
        StringBuffer buf = new StringBuffer();
        buf.append("VERB_FRAME_");
        int numZerosToAppend = 3 - String.valueOf(i).length();
        for (int j = 0; j < numZerosToAppend; ++j) {
            buf.append(0);
        }
        buf.append(i);
        return buf.toString();
    }

    public static int getVerbFramesSize() {
        return _verbFrames.length;
    }

    public static String getFrame(int index) {
        return _verbFrames[index - 1].getFrame();
    }

    public static String[] getFrames(BitSet bits) {
        int[] indicies = VerbFrame.getVerbFrameIndicies(bits);
        String[] frames = new String[indicies.length];
        for (int i = 0; i < indicies.length; ++i) {
            frames[i] = _verbFrames[i].getFrame();
        }
        return frames;
    }

    public static int[] getVerbFrameIndicies(BitSet bits) {
        int[] indicies = new int[bits.cardinality()];
        for (int i = 0; i < indicies.length; ++i) {
            indicies[i] = bits.nextSetBit(i == 0 ? 0 : indicies[i - 1]);
        }
        return indicies;
    }

    private VerbFrame(String frame, int index) {
        this._frame = new Resolvable(frame);
        this._index = index;
    }

    public String getFrame() {
        return this._frame.toString();
    }

    public int getIndex() {
        return this._index;
    }

    public String toString() {
        if (this._cachedToString == null) {
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_007", this.getFrame());
        }
        return this._cachedToString;
    }

    public int hashCode() {
        return this.getIndex();
    }

    static {
        _initalized = false;
    }
}

