/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.AlphabetCarrying;
import cc.mallet.types.AugmentableFeatureVector;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Matrix2;
import cc.mallet.types.Sequence;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import cc.mallet.types.Vector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class FeatureVectorSequence
implements Sequence<FeatureVector>,
Serializable,
AlphabetCarrying {
    FeatureVector[] sequence;
    Alphabet alphabet;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public FeatureVectorSequence(FeatureVector[] featureVectors) {
        this.sequence = featureVectors;
        this.alphabet = featureVectors[0].getAlphabet();
    }

    public FeatureVectorSequence(Alphabet dict, TokenSequence tokens, boolean binary, boolean augmentable, boolean growAlphabet) {
        this.alphabet = dict;
        this.sequence = new FeatureVector[tokens.size()];
        if (augmentable) {
            for (int i = 0; i < tokens.size(); ++i) {
                this.sequence[i] = new AugmentableFeatureVector(dict, ((Token)tokens.get(i)).getFeatures(), binary, growAlphabet);
            }
        } else {
            for (int i = 0; i < tokens.size(); ++i) {
                this.sequence[i] = new FeatureVector(dict, ((Token)tokens.get(i)).getFeatures(), binary, growAlphabet);
            }
        }
    }

    public FeatureVectorSequence(Alphabet dict, TokenSequence tokens, boolean binary, boolean augmentable) {
        this(dict, tokens, binary, augmentable, true);
    }

    public FeatureVectorSequence(Alphabet dict, TokenSequence tokens) {
        this(dict, tokens, false, false);
    }

    @Override
    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    @Override
    public Alphabet[] getAlphabets() {
        return new Alphabet[]{this.getAlphabet()};
    }

    @Override
    public int size() {
        return this.sequence.length;
    }

    @Override
    public FeatureVector get(int i) {
        return this.sequence[i];
    }

    public FeatureVector getFeatureVector(int i) {
        return this.sequence[i];
    }

    public double dotProduct(int sequencePosition, Matrix2 weights, int weightRowIndex) {
        return weights.rowDotProduct(weightRowIndex, this.sequence[sequencePosition]);
    }

    public double dotProduct(int sequencePosition, Vector weights) {
        return weights.dotProduct(this.sequence[sequencePosition]);
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append('\n');
        for (int i = 0; i < this.sequence.length; ++i) {
            sb.append(Integer.toString(i) + ": ");
            sb.append(this.sequence[i].toString(true));
            sb.append('\n');
        }
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.alphabet);
        out.writeObject(this.sequence);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.alphabet = (Alphabet)in.readObject();
        this.sequence = (FeatureVector[])in.readObject();
    }

    public class Iterator
    implements java.util.Iterator<FeatureVector> {
        int pos = 0;

        @Override
        public FeatureVector next() {
            return FeatureVectorSequence.this.sequence[this.pos++];
        }

        public int getIndex() {
            return this.pos;
        }

        @Override
        public boolean hasNext() {
            return this.pos < FeatureVectorSequence.this.sequence.length;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

