/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.princeton.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.file.DictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFileType;
import net.didion.jwnl.princeton.file.AbstractPrincetonRandomAccessDictionaryFile;

public class PrincetonChannelDictionaryFile
extends AbstractPrincetonRandomAccessDictionaryFile {
    private CharBuffer _buffer = null;
    private FileChannel _channel = null;

    public PrincetonChannelDictionaryFile() {
    }

    public DictionaryFile newInstance(String path, POS pos, DictionaryFileType fileType) {
        return new PrincetonChannelDictionaryFile(path, pos, fileType);
    }

    public PrincetonChannelDictionaryFile(String path, POS pos, DictionaryFileType fileType) {
        super(path, pos, fileType);
    }

    public String readLine() throws IOException {
        if (this.isOpen()) {
            StringBuffer input = new StringBuffer();
            char c = '\uffff';
            boolean eol = false;
            block4: while (!eol) {
                c = this._buffer.get((int)this.getFilePointer());
                this._buffer.position((int)this.getFilePointer() + 1);
                switch (c) {
                    case '\n': 
                    case '\uffff': {
                        eol = true;
                        continue block4;
                    }
                    case '\r': {
                        eol = true;
                        if (this._buffer.get((int)this.getFilePointer() + 1) != '\n') continue block4;
                        this._buffer.position((int)this.getFilePointer() + 1);
                        continue block4;
                    }
                }
                input.append(c);
            }
            return c == '\uffffffff' && input.length() == 0 ? null : input.toString();
        }
        throw new JWNLRuntimeException("PRINCETON_EXCEPTION_001");
    }

    public void seek(long pos) throws IOException {
        this._buffer.position((int)pos);
    }

    public long getFilePointer() throws IOException {
        return this._buffer.position();
    }

    public boolean isOpen() {
        return this._channel != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this._buffer = null;
            this._channel.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this._channel = null;
        }
    }

    protected void openFile(File file) throws IOException {
        this._channel = new FileInputStream(file).getChannel();
        this._buffer = Charset.forName("ISO-8859-15").newDecoder().decode(this._channel.map(FileChannel.MapMode.READ_ONLY, 0L, this._channel.size()));
    }

    public long length() throws IOException {
        return this._channel.size();
    }

    public int read() throws IOException {
        return this._buffer.get();
    }
}

