/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types.tests;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Token;
import java.io.File;
import java.net.URI;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestToken
extends TestCase {
    public TestToken(String name) {
        super(name);
    }

    public void testOne() {
        Token t = new Token("foo");
        t.setProperty("color", "red");
        t.setProperty("font", "TimesRoman");
        t.setFeatureValue("length", 3.0);
        t.setFeatureValue("containsVowel", 1.0);
        t.setFeatureValue("in /usr/dict/words", 0.0);
        Alphabet dict = new Alphabet();
        FeatureVector fv = t.toFeatureVector(dict, false);
        TestToken.assertTrue((fv.numLocations() == 2 ? 1 : 0) != 0);
        TestToken.assertTrue((fv.value(dict.lookupIndex("length")) == 3.0 ? 1 : 0) != 0);
    }

    public void testTwo() {
        try {
            URI uri = new URI("file:/home/andrew/what-professors-do.html");
            System.out.println("Scheme = " + uri.getScheme());
            File file = new File(uri);
            System.out.println(file.getCanonicalPath());
            file = new File("what-professors-do.html");
            System.out.println("Name: " + file.getName());
            System.out.println("Parent: " + file.getParent());
            System.out.println("Path: " + file.getPath());
            System.out.println("Canonical: " + file.getCanonicalPath());
            System.out.println("Absolute: " + file.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Test suite() {
        return new TestSuite(TestToken.class);
    }

    protected void setUp() {
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestToken.suite());
    }
}

