/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.ClassifierTrainer;
import cc.mallet.classify.RandomClassifier;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.AlphabetCarrying;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Label;

public class RandomAssignmentTrainer
extends ClassifierTrainer<RandomClassifier>
implements AlphabetCarrying {
    RandomClassifier classifier = null;
    Pipe instancePipe;
    Alphabet dataAlphabet;
    Alphabet targetAlphabet;

    @Override
    public RandomClassifier getClassifier() {
        return this.classifier;
    }

    @Override
    public RandomClassifier train(InstanceList trainingList) {
        if (trainingList != null) {
            if (this.instancePipe == null) {
                this.instancePipe = trainingList.getPipe();
            } else if (this.instancePipe != trainingList.getPipe()) {
                throw new IllegalArgumentException("Training set pipe does not match that of NaiveBayesTrainer.");
            }
            this.dataAlphabet = this.instancePipe.getDataAlphabet();
            this.targetAlphabet = this.instancePipe.getTargetAlphabet();
        }
        this.classifier = new RandomClassifier(this.instancePipe);
        for (Instance instance : trainingList) {
            if (this.dataAlphabet == null) {
                this.dataAlphabet = instance.getDataAlphabet();
                this.targetAlphabet = instance.getTargetAlphabet();
            } else if (!Alphabet.alphabetsMatch(instance, this)) {
                throw new IllegalArgumentException("Training set alphabets do not match those of NaiveBayesTrainer.");
            }
            Label label = (Label)instance.getTarget();
            this.classifier.addTargetLabel(label);
        }
        return this.classifier;
    }

    public boolean alphabetsMatch(AlphabetCarrying object) {
        return Alphabet.alphabetsMatch(this, object);
    }

    @Override
    public Alphabet getAlphabet() {
        return this.dataAlphabet;
    }

    @Override
    public Alphabet[] getAlphabets() {
        return new Alphabet[]{this.dataAlphabet, this.targetAlphabet};
    }
}

