/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract;

import cc.mallet.extract.CRFExtractor;
import cc.mallet.extract.DocumentExtraction;
import cc.mallet.extract.Extraction;
import cc.mallet.fst.CRF;
import cc.mallet.fst.MaxLattice;
import cc.mallet.fst.MaxLatticeDefault;
import cc.mallet.fst.SumLatticeDefault;
import cc.mallet.fst.Transducer;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.FeatureVectorSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelSequence;
import cc.mallet.types.Sequence;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.List;

public class LatticeViewer {
    private static final int FEATURE_CUTOFF_PCT = 25;
    private static final int LENGTH = 10;
    public static int numMaxViterbi = 5;
    private static int numFeaturesToDisplay = 5;
    private static final int EXTRACTIONS_PER_FILE = 25;

    static void lattice2html(PrintStream out, ExtorInfo info) {
        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(out), true);
        LatticeViewer.lattice2html(writer, info);
    }

    static void lattice2html(PrintWriter out, ExtorInfo info) {
        assert (info.target.size() == info.predicted.size());
        assert (info.input.size() == info.predicted.size());
        int N = info.target.size();
        for (int start = 0; start < N; start += 9) {
            int end = Math.min(N, start + 10);
            if (LatticeViewer.allSeqMatches(info.predicted, info.target, start, end)) continue;
            LatticeViewer.error2html(out, info, start, end);
        }
    }

    private static void writeHeader(PrintWriter out) {
        out.println("<html><head><title>ERROR OUTPUT</title>\n<link rel=\"stylesheet\" href=\"errors.css\" type=\"text/css\" />\n</head><body>");
    }

    private static void writeFooter(PrintWriter out) {
        out.println("</body></html>");
    }

    private static void error2html(PrintWriter out, ExtorInfo info, int start, int end) {
        String anchor = info.idx + ":" + start + ":" + end;
        out.println("<p><A NAME=\"" + anchor + "\">");
        out.println("<p>Instance " + info.desc + " Position " + start + "..." + end);
        if (info.link != null) {
            out.println("<a href=\"" + info.link + "#" + anchor + "\">[Lattice]</a>");
        }
        out.println("</p>");
        out.println("<table>");
        LatticeViewer.outputIndices(out, start, end);
        LatticeViewer.outputInputRow(out, info.input, start, end);
        LatticeViewer.outputTableRow(out, "target", info.target, info.predicted, start, end);
        LatticeViewer.outputTableRow(out, "predicted", info.predicted, info.target, start, end);
        if (info.lattice != null) {
            LatticeViewer.outputLatticeRows(out, info.lattice, start, end);
            LatticeViewer.outputTransitionCosts(out, info, start, end);
            LatticeViewer.outputFeatures(out, info.fvs, info.predicted, info.target, start, end);
        }
        out.println("</table>");
    }

    private static void outputLatticeRows(PrintWriter out, MaxLattice lattice, int start, int end) {
        DecimalFormat f = new DecimalFormat("0.##");
        Transducer ducer = lattice.getTransducer();
        int max = Math.min(numMaxViterbi, ducer.numStates());
        List<Sequence<Transducer.State>> stateSequences = lattice.bestStateSequences(max);
        for (int k = 0; k < max; ++k) {
            out.println("  <tr class=\"delta\">");
            out.println("    <td class=\"label\">&delta; rank " + k + "</td>");
            for (int ip = start; ip < end; ++ip) {
                Transducer.State state = stateSequences.get(k).get(ip + 1);
                if (state.getName().equals(lattice.bestOutputSequence().get(ip))) {
                    out.print("<td class=\"viterbi\">");
                } else {
                    out.print("<td>");
                }
                out.print(state.getName() + "<br />" + f.format(-lattice.getDelta(ip + 1, state.getIndex())) + "</td>");
            }
            out.println("</tr>");
        }
    }

    public static int getNumFeaturesToDisplay() {
        return numFeaturesToDisplay;
    }

    public static void setNumFeaturesToDisplay(int numFeaturesToDisplay) {
        LatticeViewer.numFeaturesToDisplay = numFeaturesToDisplay;
    }

    private static void outputTransitionCosts(PrintWriter out, ExtorInfo info, int start, int end) {
        String str;
        double cost;
        Transducer.TransitionIterator iter;
        CRF.State from;
        int ip;
        Transducer ducer = info.lattice.getTransducer();
        out.println("<tr class=\"predtrans\">");
        out.println("<td class=\"label\">Cost(pred. trans)</td>");
        for (ip = start; ip < end; ++ip) {
            if (ip == 0) {
                out.println("<td></td>");
                continue;
            }
            from = ((CRF)ducer).getState(info.bestStates.get(ip - 1).toString());
            iter = ((Transducer.State)from).transitionIterator(info.fvs, ip, info.predicted, ip);
            if (iter.hasNext()) {
                iter.next();
                cost = iter.getWeight();
                str = iter.describeTransition((int)(Math.abs(cost) / 25.0));
                out.print("<td>" + str + "</td>");
                continue;
            }
            out.print("<td>No matching transition</td>");
        }
        out.println("</tr>");
        out.println("<tr class=\"targettrans\">");
        out.println("<td class=\"label\">Cost(target trans)</td>");
        for (ip = start; ip < end; ++ip) {
            if (ip == 0) {
                out.println("<td></td>");
                continue;
            }
            if (!LatticeViewer.seqMatches(info.predicted, info.target, ip) || !LatticeViewer.seqMatches(info.predicted, info.target, ip - 1)) {
                from = ((CRF)ducer).getState(info.target.get(ip - 1).toString());
                if (from == null) {
                    out.println("<td colspan='" + (end - start) + "'>Could not find state for " + info.target.get(ip - 1) + "</td>");
                    continue;
                }
                iter = ((Transducer.State)from).transitionIterator(info.fvs, ip, info.target, ip);
                if (iter.hasNext()) {
                    iter.next();
                    cost = iter.getWeight();
                    str = iter.describeTransition((int)(Math.abs(cost) / 25.0));
                    out.print("<td>" + str + "</td>");
                    continue;
                }
                out.print("<td>No matching transition</td>");
                continue;
            }
            out.print("<td></td>");
        }
        out.println("</tr>");
        out.println("<tr class=\"predtargettrans\">");
        out.println("<td class=\"label\">Cost (pred->target trans)</td>");
        for (ip = start; ip < end; ++ip) {
            if (ip == 0) {
                out.println("<td></td>");
                continue;
            }
            if (!LatticeViewer.seqMatches(info.predicted, info.target, ip) || !LatticeViewer.seqMatches(info.predicted, info.target, ip - 1)) {
                from = ((CRF)ducer).getState(info.bestStates.get(ip - 1).toString());
                iter = ((Transducer.State)from).transitionIterator(info.fvs, ip, info.target, ip);
                if (iter.hasNext()) {
                    iter.next();
                    cost = iter.getWeight();
                    str = iter.describeTransition((int)(Math.abs(cost) / 25.0));
                    out.print("<td>" + str + "</td>");
                    continue;
                }
                out.print("<td>No matching transition</td>");
                continue;
            }
            out.print("<td></td>");
        }
        out.println("</tr>");
    }

    private static void outputLatticeRows(PrintWriter out, SumLatticeDefault lattice, int start, int end) {
        int ip;
        Transducer.State state;
        int k;
        DecimalFormat f = new DecimalFormat("0.##");
        Transducer ducer = lattice.getTransducer();
        for (k = 0; k < ducer.numStates(); ++k) {
            state = ducer.getState(k);
            out.println("  <tr class=\"alpha\">");
            out.println("    <td class=\"label\">&alpha;(" + state.getName() + ")</td>");
            for (ip = start; ip < end; ++ip) {
                out.print("<td>" + f.format(lattice.getAlpha(ip + 1, state)) + "</td>");
            }
            out.println("</tr>");
        }
        for (k = 0; k < ducer.numStates(); ++k) {
            state = ducer.getState(k);
            out.println("  <tr class=\"beta\">");
            out.println("    <td class=\"label\">&beta;(" + state.getName() + ")</td>");
            for (ip = start; ip < end; ++ip) {
                out.print("<td>" + f.format(lattice.getBeta(ip + 1, state)) + "</td>");
            }
            out.println("</tr>");
        }
        for (k = 0; k < ducer.numStates(); ++k) {
            state = ducer.getState(k);
            out.println("  <tr class=\"gamma\">");
            out.println("    <td class=\"label\">&gamma;(" + state.getName() + ")</td>");
            for (ip = start; ip < end; ++ip) {
                out.print("<td>" + f.format(lattice.getGammaWeight(ip + 1, state)) + "</td>");
            }
            out.println("</tr>");
        }
    }

    private static void outputInputRow(PrintWriter out, TokenSequence input, int start, int end) {
        out.println("  <tr class=\"input\">");
        out.println("    <td class=\"label\"></td>");
        for (int ip = start; ip < end; ++ip) {
            out.print("<td>" + ((Token)input.get(ip)).getText() + "</td>");
        }
        out.println("  </tr>");
    }

    private static void outputIndices(PrintWriter out, int start, int end) {
        out.println("  <tr class=\"indices\">");
        out.println("    <td class=\"label\"></td>");
        for (int ip = start; ip < end; ++ip) {
            out.print("<td>" + ip + "</td>");
        }
        out.println("  </tr>");
    }

    private static void outputTableRow(PrintWriter out, String cssClass, Sequence seq1, Sequence seq2, int start, int end) {
        out.println("  <tr class=\"" + cssClass + "\">");
        out.println("    <td class=\"label\">" + cssClass + "</td>");
        for (int i = start; i < end; ++i) {
            if (LatticeViewer.seqMatches(seq1, seq2, i)) {
                out.print("<td>");
            } else {
                out.print("<td class=\"error\">");
            }
            out.print(seq1.get(i));
            out.print("</td>");
        }
        out.println("  </tr>");
    }

    private static void outputFeatures(PrintWriter out, FeatureVectorSequence fvs, Sequence in, Sequence output, int start, int end) {
        out.println("  <tr class=\"features\">\n<td class=\"label\">Features</td>");
        for (int i = start; i < end; ++i) {
            if (!LatticeViewer.seqMatches(in, output, i)) {
                out.print("<td>");
                FeatureVector fv = fvs.getFeatureVector(i);
                for (int k = 0; k < fv.numLocations(); ++k) {
                    out.print(fv.getAlphabet().lookupObject(fv.indexAtLocation(k)));
                    if (fv.valueAtLocation(k) != 1.0) {
                        out.print(" " + fv.valueAtLocation(k));
                    }
                    out.println("<br />");
                }
                out.println("</td>");
                continue;
            }
            out.println("<td></td>");
        }
        out.println("  </tr>");
    }

    private static boolean seqMatches(Sequence seq1, Sequence seq2, int i) {
        return seq1.get(i).toString().equals(seq2.get(i).toString());
    }

    private static boolean allSeqMatches(Sequence seq1, Sequence seq2, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (LatticeViewer.seqMatches(seq1, seq2, i)) continue;
            return false;
        }
        return true;
    }

    public static void extraction2html(Extraction extraction, CRFExtractor extor, PrintStream out) {
        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(out), true);
        LatticeViewer.extraction2html(extraction, extor, out, false);
    }

    public static void extraction2html(Extraction extraction, CRFExtractor extor, PrintWriter out) {
        LatticeViewer.extraction2html(extraction, extor, out, false);
    }

    public static void extraction2html(Extraction extraction, CRFExtractor extor, PrintStream out, boolean showLattice) {
        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(out), true);
        LatticeViewer.extraction2html(extraction, extor, writer, showLattice);
    }

    public static void extraction2html(Extraction extraction, CRFExtractor extor, PrintWriter out, boolean showLattice) {
        LatticeViewer.writeHeader(out);
        for (int i = 0; i < extraction.getNumDocuments(); ++i) {
            DocumentExtraction docextr = extraction.getDocumentExtraction(i);
            String desc = docextr.getName();
            String doc = ((CharSequence)docextr.getDocument()).toString();
            ExtorInfo info = LatticeViewer.infoForDoc(doc, desc, "N" + i, docextr, extor, showLattice);
            if (!showLattice) {
                info.link = "lattice.html";
            }
            LatticeViewer.lattice2html(out, info);
        }
        LatticeViewer.writeFooter(out);
    }

    private static ExtorInfo infoForDoc(String doc, String desc, String idx, DocumentExtraction docextr, CRFExtractor extor, boolean showLattice) {
        TokenSequence input = (TokenSequence)((Object)docextr.getInput());
        LabelSequence target = docextr.getTarget();
        Sequence predicted = docextr.getPredictedLabels();
        ExtorInfo info = new ExtorInfo(input, predicted, target, desc, idx);
        if (showLattice) {
            CRF crf = extor.getCrf();
            Instance carrier = extor.getFeaturePipe().pipe(new Instance(input, null, null, null));
            info.fvs = (FeatureVectorSequence)carrier.getData();
            info.lattice = new MaxLatticeDefault(crf, (Sequence)carrier.getData(), null);
            info.bestStates = info.lattice.bestOutputSequence();
        }
        return info;
    }

    public static void viewDualResults(File dir, Extraction e1, CRFExtractor extor1, Extraction e2, CRFExtractor extor2) throws IOException {
        if (e1.getNumDocuments() != e2.getNumDocuments()) {
            throw new IllegalArgumentException("Extractions don't match: different number of docs.");
        }
        PrintWriter errorStr = new PrintWriter(new FileWriter(new File(dir, "errors.html")));
        LatticeViewer.writeDualExtractions(errorStr, e1, extor1, e2, extor2, 0, e1.getNumDocuments(), false);
        errorStr.close();
        int max = e1.getNumDocuments();
        for (int start = 0; start < max; start += 25) {
            int end = Math.min(start + 25, max);
            PrintWriter latticeStr = new PrintWriter(new FileWriter(new File(dir, "lattice-" + start + ".html")));
            LatticeViewer.writeDualExtractions(latticeStr, e1, extor1, e2, extor2, start, end, true);
            latticeStr.close();
        }
    }

    private static String computeLatticeFname(int docIdx) {
        int htmlDocNo = docIdx / 25;
        int start = 25 * htmlDocNo;
        return "lattice-" + start + ".html";
    }

    private static void writeDualExtractions(PrintWriter out, Extraction e1, CRFExtractor extor1, Extraction e2, CRFExtractor extor2, int start, int end, boolean showLattice) {
        LatticeViewer.writeHeader(out);
        for (int i = start; i < end; ++i) {
            Sequence targ2;
            String doc2Str;
            DocumentExtraction doc1 = e1.getDocumentExtraction(i);
            DocumentExtraction doc2 = e2.getDocumentExtraction(i);
            String desc = doc1.getName();
            String doc1Str = ((CharSequence)doc1.getDocument()).toString();
            if (!doc1Str.equals(doc2Str = ((CharSequence)doc2.getDocument()).toString())) {
                System.err.println("Skipping document " + i + ": Extractions don't match");
                continue;
            }
            Sequence targ1 = doc1.getPredictedLabels();
            if (LatticeViewer.predictionsMatch(targ1, targ2 = doc2.getPredictedLabels())) continue;
            ExtorInfo info1 = LatticeViewer.infoForDoc(doc1Str, "CRF1::" + desc, "C1I" + i, doc1, extor1, showLattice);
            ExtorInfo info2 = LatticeViewer.infoForDoc(doc1Str, "CRF2::" + desc, "C2I" + i, doc2, extor2, showLattice);
            if (!showLattice) {
                info1.link = info2.link = LatticeViewer.computeLatticeFname(i);
            }
            LatticeViewer.dualLattice2html(out, desc, info1, info2);
        }
        LatticeViewer.writeFooter(out);
    }

    public static void dualLattice2html(PrintWriter out, String desc, ExtorInfo info1, ExtorInfo info2) {
        assert (info1.predicted.size() == info1.target.size());
        assert (info1.input.size() == info1.predicted.size());
        assert (info2.input.size() == info2.predicted.size());
        assert (info2.predicted.size() == info2.target.size());
        int N = info1.target.size();
        for (int start = 0; start < N; start += 9) {
            int end = Math.min(info1.predicted.size(), start + 10);
            if (LatticeViewer.allSeqMatches(info1.predicted, info2.predicted, start, end)) continue;
            LatticeViewer.error2html(out, info1, start, end);
            LatticeViewer.error2html(out, info2, start, end);
        }
    }

    private static boolean predictionsMatch(Sequence targ1, Sequence targ2) {
        if (targ1.size() != targ2.size()) {
            return false;
        }
        for (int i = 0; i < targ1.size(); ++i) {
            if (targ1.get(i).toString().equals(targ2.get(i).toString())) continue;
            return false;
        }
        return true;
    }

    private static class ExtorInfo {
        TokenSequence input;
        Sequence predicted;
        LabelSequence target;
        FeatureVectorSequence fvs;
        MaxLattice lattice;
        Sequence bestStates;
        String link;
        String desc;
        String idx;

        public ExtorInfo(TokenSequence input, Sequence predicted, LabelSequence target, String desc, String idx) {
            this.input = input;
            this.predicted = predicted;
            this.target = target;
            this.desc = desc;
            this.idx = idx;
        }
    }
}

