/*
 * Decompiled with CFR 0.152.
 */
package hidden.edu.emory.mathcs.backport.java.util.concurrent;

import hidden.edu.emory.mathcs.backport.java.util.concurrent.AbstractExecutorService;
import hidden.edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import hidden.edu.emory.mathcs.backport.java.util.concurrent.Callable;
import hidden.edu.emory.mathcs.backport.java.util.concurrent.CompletionService;
import hidden.edu.emory.mathcs.backport.java.util.concurrent.Executor;
import hidden.edu.emory.mathcs.backport.java.util.concurrent.Future;
import hidden.edu.emory.mathcs.backport.java.util.concurrent.FutureTask;
import hidden.edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import hidden.edu.emory.mathcs.backport.java.util.concurrent.RunnableFuture;
import hidden.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;

public class ExecutorCompletionService
implements CompletionService {
    private final Executor executor;
    private final AbstractExecutorService aes;
    private final BlockingQueue completionQueue;

    private RunnableFuture newTaskFor(Callable task) {
        if (this.aes == null) {
            return new FutureTask(task);
        }
        return this.aes.newTaskFor(task);
    }

    private RunnableFuture newTaskFor(Runnable task, Object result) {
        if (this.aes == null) {
            return new FutureTask(task, result);
        }
        return this.aes.newTaskFor(task, result);
    }

    public ExecutorCompletionService(Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = new LinkedBlockingQueue();
    }

    public ExecutorCompletionService(Executor executor, BlockingQueue completionQueue) {
        if (executor == null || completionQueue == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = completionQueue;
    }

    public Future submit(Callable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture f = this.newTaskFor(task);
        this.executor.execute(new QueueingFuture(f));
        return f;
    }

    public Future submit(Runnable task, Object result) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture f = this.newTaskFor(task, result);
        this.executor.execute(new QueueingFuture(f));
        return f;
    }

    public Future take() throws InterruptedException {
        return (Future)this.completionQueue.take();
    }

    public Future poll() {
        return (Future)this.completionQueue.poll();
    }

    public Future poll(long timeout, TimeUnit unit) throws InterruptedException {
        return (Future)this.completionQueue.poll(timeout, unit);
    }

    private class QueueingFuture
    extends FutureTask {
        private final Future task;

        QueueingFuture(RunnableFuture task) {
            super(task, null);
            this.task = task;
        }

        protected void done() {
            ExecutorCompletionService.this.completionQueue.add(this.task);
        }
    }
}

