/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.metadata.AbstractMetadata;
import org.eclipse.aether.metadata.MergeableMetadata;
import org.eclipse.aether.metadata.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MavenMetadata
extends AbstractMetadata
implements MergeableMetadata {
    static final String MAVEN_METADATA_XML = "maven-metadata.xml";
    private final File file;
    protected org.apache.maven.artifact.repository.metadata.Metadata metadata;
    private boolean merged;

    protected MavenMetadata(org.apache.maven.artifact.repository.metadata.Metadata metadata, File file) {
        this.metadata = metadata;
        this.file = file;
    }

    public String getType() {
        return MAVEN_METADATA_XML;
    }

    public File getFile() {
        return this.file;
    }

    public void merge(File existing, File result) throws RepositoryException {
        org.apache.maven.artifact.repository.metadata.Metadata recessive = MavenMetadata.read(existing);
        this.merge(recessive);
        this.write(result, this.metadata);
        this.merged = true;
    }

    public boolean isMerged() {
        return this.merged;
    }

    protected abstract void merge(org.apache.maven.artifact.repository.metadata.Metadata var1);

    static org.apache.maven.artifact.repository.metadata.Metadata read(File metadataFile) throws RepositoryException {
        if (metadataFile.length() <= 0L) {
            return new org.apache.maven.artifact.repository.metadata.Metadata();
        }
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)metadataFile);
            org.apache.maven.artifact.repository.metadata.Metadata metadata = new MetadataXpp3Reader().read((Reader)reader, false);
            return metadata;
        }
        catch (IOException e) {
            throw new RepositoryException("Could not read metadata " + metadataFile + ": " + e.getMessage(), (Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new RepositoryException("Could not parse metadata " + metadataFile + ": " + e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    private void write(File metadataFile, org.apache.maven.artifact.repository.metadata.Metadata metadata) throws RepositoryException {
        XmlStreamWriter writer = null;
        try {
            metadataFile.getParentFile().mkdirs();
            writer = WriterFactory.newXmlWriter((File)metadataFile);
            new MetadataXpp3Writer().write((Writer)writer, metadata);
        }
        catch (IOException e) {
            try {
                throw new RepositoryException("Could not write metadata " + metadataFile + ": " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    public Metadata setProperties(Map<String, String> properties) {
        return this;
    }
}

