/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.v4;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.ActivationFile;
import org.apache.maven.api.model.ActivationOS;
import org.apache.maven.api.model.ActivationProperty;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.BuildBase;
import org.apache.maven.api.model.CiManagement;
import org.apache.maven.api.model.ConfigurationContainer;
import org.apache.maven.api.model.Contributor;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.DeploymentRepository;
import org.apache.maven.api.model.Developer;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.Exclusion;
import org.apache.maven.api.model.Extension;
import org.apache.maven.api.model.FileSet;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputSource;
import org.apache.maven.api.model.IssueManagement;
import org.apache.maven.api.model.License;
import org.apache.maven.api.model.MailingList;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.ModelBase;
import org.apache.maven.api.model.Notifier;
import org.apache.maven.api.model.Organization;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.model.PatternSet;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginConfiguration;
import org.apache.maven.api.model.PluginContainer;
import org.apache.maven.api.model.PluginExecution;
import org.apache.maven.api.model.PluginManagement;
import org.apache.maven.api.model.Prerequisites;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.Relocation;
import org.apache.maven.api.model.ReportPlugin;
import org.apache.maven.api.model.ReportSet;
import org.apache.maven.api.model.Reporting;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.RepositoryBase;
import org.apache.maven.api.model.RepositoryPolicy;
import org.apache.maven.api.model.Resource;
import org.apache.maven.api.model.Scm;
import org.apache.maven.api.model.Site;
import org.apache.maven.api.model.Source;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.api.xml.XmlService;

@Generated
public class MavenStaxReader {
    private boolean addDefaultEntities = true;
    private boolean addLocationInformation = true;
    private final ContentTransformer contentTransformer;

    public MavenStaxReader() {
        this((s, f) -> s);
    }

    public MavenStaxReader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    public XMLInputFactory getXMLInputFactory() {
        return InputFactoryHolder.XML_INPUT_FACTORY;
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public boolean getAddLocationInformation() {
        return this.addLocationInformation;
    }

    public void setAddLocationInformation(boolean addLocationInformation) {
        this.addLocationInformation = addLocationInformation;
    }

    public Model read(Reader reader) throws XMLStreamException {
        return this.read(reader, true, null);
    }

    public Model read(Reader reader, boolean strict, InputSource inputSrc) throws XMLStreamException {
        StreamSource streamSource = new StreamSource(reader, inputSrc != null ? inputSrc.getLocation() : null);
        XMLInputFactory factory = this.getXMLInputFactory();
        XMLStreamReader parser = factory.createXMLStreamReader(streamSource);
        return this.read(parser, strict, inputSrc);
    }

    public Model read(InputStream in) throws XMLStreamException {
        return this.read(in, true, null);
    }

    public Model read(InputStream in, boolean strict, InputSource inputSrc) throws XMLStreamException {
        StreamSource streamSource = new StreamSource(in, inputSrc != null ? inputSrc.getLocation() : null);
        XMLInputFactory factory = this.getXMLInputFactory();
        XMLStreamReader parser = factory.createXMLStreamReader(streamSource);
        return this.read(parser, strict, inputSrc);
    }

    public Model read(XMLStreamReader parser, boolean strict, InputSource inputSrc) throws XMLStreamException {
        Model model = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 8) {
            if (eventType == 1) {
                if (strict && !"project".equals(parser.getLocalName())) {
                    throw new XMLStreamException("Expected root element 'project' but found '" + String.valueOf(parser.getName()) + "'", parser.getLocation(), null);
                }
                if (parsed) {
                    throw new XMLStreamException("Duplicated tag: 'project'", parser.getLocation(), null);
                }
                model = this.parseModel(parser, strict, parser.getNamespaceURI(), inputSrc);
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return model;
        }
        throw new XMLStreamException("Expected root element 'project' but found no element at all: invalid XML document", parser.getLocation(), null);
    }

    private Model parseModel(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Model.Builder model = Model.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            model.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        model.namespaceUri(namespace);
        model.modelEncoding(parser.getEncoding());
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns) || "xmlns".equals(name)) continue;
            if ("child.project.url.inherit.append.path".equals(name)) {
                if (this.addLocationInformation) {
                    model.location((Object)name, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                }
                model.childProjectUrlInheritAppendPath(this.interpolatedTrimmed(value, "child.project.url.inherit.append.path"));
                continue;
            }
            if ("root".equals(name)) {
                if (this.addLocationInformation) {
                    model.location((Object)name, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                }
                model.root(this.getBooleanValue(this.interpolatedTrimmed(value, "root"), "root", parser, false));
                continue;
            }
            if ("preserve.model.version".equals(name)) {
                if (this.addLocationInformation) {
                    model.location((Object)name, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                }
                model.preserveModelVersion(this.getBooleanValue(this.interpolatedTrimmed(value, "preserve.model.version"), "preserve.model.version", parser, false));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Object, InputLocation> locations = null;
            switch (childName) {
                case "modelVersion": {
                    model.modelVersion(this.interpolatedTrimmed(this.nextText(parser, strict), "modelVersion"));
                    break;
                }
                case "parent": {
                    model.parent(this.parseParent(parser, strict, namespace, inputSrc));
                    break;
                }
                case "groupId": {
                    model.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    break;
                }
                case "artifactId": {
                    model.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    break;
                }
                case "version": {
                    model.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    break;
                }
                case "packaging": {
                    model.packaging(this.interpolatedTrimmed(this.nextText(parser, strict), "packaging"));
                    break;
                }
                case "name": {
                    model.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "description": {
                    model.description(this.interpolatedTrimmed(this.nextText(parser, strict), "description"));
                    break;
                }
                case "url": {
                    model.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "inceptionYear": {
                    model.inceptionYear(this.interpolatedTrimmed(this.nextText(parser, strict), "inceptionYear"));
                    break;
                }
                case "organization": {
                    model.organization(this.parseOrganization(parser, strict, namespace, inputSrc));
                    break;
                }
                case "licenses": {
                    ArrayList<License> licenses = new ArrayList<License>();
                    while (parser.nextTag() == 1) {
                        if ("license".equals(parser.getLocalName())) {
                            licenses.add(this.parseLicense(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.licenses(licenses);
                    break;
                }
                case "developers": {
                    ArrayList<Developer> developers = new ArrayList<Developer>();
                    while (parser.nextTag() == 1) {
                        if ("developer".equals(parser.getLocalName())) {
                            developers.add(this.parseDeveloper(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.developers(developers);
                    break;
                }
                case "contributors": {
                    ArrayList<Contributor> contributors = new ArrayList<Contributor>();
                    while (parser.nextTag() == 1) {
                        if ("contributor".equals(parser.getLocalName())) {
                            contributors.add(this.parseContributor(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.contributors(contributors);
                    break;
                }
                case "mailingLists": {
                    ArrayList<MailingList> mailingLists = new ArrayList<MailingList>();
                    while (parser.nextTag() == 1) {
                        if ("mailingList".equals(parser.getLocalName())) {
                            mailingLists.add(this.parseMailingList(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.mailingLists(mailingLists);
                    break;
                }
                case "prerequisites": {
                    model.prerequisites(this.parsePrerequisites(parser, strict, namespace, inputSrc));
                    break;
                }
                case "modules": {
                    ArrayList<String> modules = new ArrayList<String>();
                    locations = new HashMap<Object, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("module".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            modules.add(this.interpolatedTrimmed(this.nextText(parser, strict), "modules"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.modules(modules);
                    break;
                }
                case "subprojects": {
                    ArrayList<String> subprojects = new ArrayList<String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        if ("subproject".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            subprojects.add(this.interpolatedTrimmed(this.nextText(parser, strict), "subprojects"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.subprojects(subprojects);
                    break;
                }
                case "scm": {
                    model.scm(this.parseScm(parser, strict, namespace, inputSrc));
                    break;
                }
                case "issueManagement": {
                    model.issueManagement(this.parseIssueManagement(parser, strict, namespace, inputSrc));
                    break;
                }
                case "ciManagement": {
                    model.ciManagement(this.parseCiManagement(parser, strict, namespace, inputSrc));
                    break;
                }
                case "distributionManagement": {
                    model.distributionManagement(this.parseDistributionManagement(parser, strict, namespace, inputSrc));
                    break;
                }
                case "properties": {
                    LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        String key = parser.getLocalName();
                        String value = this.nextText(parser, strict).trim();
                        if (this.addLocationInformation) {
                            locations.put(key, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                        }
                        properties.put(key, value);
                    }
                    model.properties(properties);
                    break;
                }
                case "dependencyManagement": {
                    model.dependencyManagement(this.parseDependencyManagement(parser, strict, namespace, inputSrc));
                    break;
                }
                case "dependencies": {
                    ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                    while (parser.nextTag() == 1) {
                        if ("dependency".equals(parser.getLocalName())) {
                            dependencies.add(this.parseDependency(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.dependencies(dependencies);
                    break;
                }
                case "repositories": {
                    ArrayList<Repository> repositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 1) {
                        if ("repository".equals(parser.getLocalName())) {
                            repositories.add(this.parseRepository(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.repositories(repositories);
                    break;
                }
                case "pluginRepositories": {
                    ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 1) {
                        if ("pluginRepository".equals(parser.getLocalName())) {
                            pluginRepositories.add(this.parseRepository(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.pluginRepositories(pluginRepositories);
                    break;
                }
                case "build": {
                    model.build(this.parseBuild(parser, strict, namespace, inputSrc));
                    break;
                }
                case "reporting": {
                    model.reporting(this.parseReporting(parser, strict, namespace, inputSrc));
                    break;
                }
                case "profiles": {
                    ArrayList<Profile> profiles = new ArrayList<Profile>();
                    while (parser.nextTag() == 1) {
                        if ("profile".equals(parser.getLocalName())) {
                            profiles.add(this.parseProfile(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.profiles(profiles);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            model.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return model.build();
    }

    private ModelBase parseModelBase(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        ModelBase.Builder modelBase = ModelBase.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            modelBase.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Object, InputLocation> locations = null;
            switch (childName) {
                case "modules": {
                    ArrayList<String> modules = new ArrayList<String>();
                    locations = new HashMap<Object, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("module".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            modules.add(this.interpolatedTrimmed(this.nextText(parser, strict), "modules"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    modelBase.modules(modules);
                    break;
                }
                case "subprojects": {
                    ArrayList<String> subprojects = new ArrayList<String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        if ("subproject".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            subprojects.add(this.interpolatedTrimmed(this.nextText(parser, strict), "subprojects"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    modelBase.subprojects(subprojects);
                    break;
                }
                case "distributionManagement": {
                    modelBase.distributionManagement(this.parseDistributionManagement(parser, strict, namespace, inputSrc));
                    break;
                }
                case "properties": {
                    LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        String key = parser.getLocalName();
                        String value = this.nextText(parser, strict).trim();
                        if (this.addLocationInformation) {
                            locations.put(key, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                        }
                        properties.put(key, value);
                    }
                    modelBase.properties(properties);
                    break;
                }
                case "dependencyManagement": {
                    modelBase.dependencyManagement(this.parseDependencyManagement(parser, strict, namespace, inputSrc));
                    break;
                }
                case "dependencies": {
                    ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                    while (parser.nextTag() == 1) {
                        if ("dependency".equals(parser.getLocalName())) {
                            dependencies.add(this.parseDependency(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    modelBase.dependencies(dependencies);
                    break;
                }
                case "repositories": {
                    ArrayList<Repository> repositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 1) {
                        if ("repository".equals(parser.getLocalName())) {
                            repositories.add(this.parseRepository(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    modelBase.repositories(repositories);
                    break;
                }
                case "pluginRepositories": {
                    ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 1) {
                        if ("pluginRepository".equals(parser.getLocalName())) {
                            pluginRepositories.add(this.parseRepository(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    modelBase.pluginRepositories(pluginRepositories);
                    break;
                }
                case "reporting": {
                    modelBase.reporting(this.parseReporting(parser, strict, namespace, inputSrc));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            modelBase.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return modelBase.build();
    }

    private PluginContainer parsePluginContainer(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        PluginContainer.Builder pluginContainer = PluginContainer.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            pluginContainer.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "plugins": {
                    ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                    while (parser.nextTag() == 1) {
                        if ("plugin".equals(parser.getLocalName())) {
                            plugins.add(this.parsePlugin(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    pluginContainer.plugins(plugins);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            pluginContainer.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return pluginContainer.build();
    }

    private PluginConfiguration parsePluginConfiguration(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        PluginConfiguration.Builder pluginConfiguration = PluginConfiguration.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            pluginConfiguration.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "pluginManagement": {
                    pluginConfiguration.pluginManagement(this.parsePluginManagement(parser, strict, namespace, inputSrc));
                    break;
                }
                case "plugins": {
                    ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                    while (parser.nextTag() == 1) {
                        if ("plugin".equals(parser.getLocalName())) {
                            plugins.add(this.parsePlugin(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    pluginConfiguration.plugins(plugins);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            pluginConfiguration.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return pluginConfiguration.build();
    }

    private BuildBase parseBuildBase(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        BuildBase.Builder buildBase = BuildBase.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            buildBase.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "defaultGoal": {
                    buildBase.defaultGoal(this.interpolatedTrimmed(this.nextText(parser, strict), "defaultGoal"));
                    break;
                }
                case "resources": {
                    ArrayList<Resource> resources = new ArrayList<Resource>();
                    while (parser.nextTag() == 1) {
                        if ("resource".equals(parser.getLocalName())) {
                            resources.add(this.parseResource(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    buildBase.resources(resources);
                    break;
                }
                case "testResources": {
                    ArrayList<Resource> testResources = new ArrayList<Resource>();
                    while (parser.nextTag() == 1) {
                        if ("testResource".equals(parser.getLocalName())) {
                            testResources.add(this.parseResource(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    buildBase.testResources(testResources);
                    break;
                }
                case "directory": {
                    buildBase.directory(this.interpolatedTrimmed(this.nextText(parser, strict), "directory"));
                    break;
                }
                case "finalName": {
                    buildBase.finalName(this.interpolatedTrimmed(this.nextText(parser, strict), "finalName"));
                    break;
                }
                case "filters": {
                    ArrayList<String> filters = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("filter".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            filters.add(this.interpolatedTrimmed(this.nextText(parser, strict), "filters"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    buildBase.filters(filters);
                    break;
                }
                case "pluginManagement": {
                    buildBase.pluginManagement(this.parsePluginManagement(parser, strict, namespace, inputSrc));
                    break;
                }
                case "plugins": {
                    ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                    while (parser.nextTag() == 1) {
                        if ("plugin".equals(parser.getLocalName())) {
                            plugins.add(this.parsePlugin(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    buildBase.plugins(plugins);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            buildBase.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return buildBase.build();
    }

    private Build parseBuild(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Build.Builder build = Build.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            build.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "sources": {
                    ArrayList<Source> sources = new ArrayList<Source>();
                    while (parser.nextTag() == 1) {
                        if ("source".equals(parser.getLocalName())) {
                            sources.add(this.parseSource(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    build.sources(sources);
                    break;
                }
                case "sourceDirectory": {
                    build.sourceDirectory(this.interpolatedTrimmed(this.nextText(parser, strict), "sourceDirectory"));
                    break;
                }
                case "scriptSourceDirectory": {
                    build.scriptSourceDirectory(this.interpolatedTrimmed(this.nextText(parser, strict), "scriptSourceDirectory"));
                    break;
                }
                case "testSourceDirectory": {
                    build.testSourceDirectory(this.interpolatedTrimmed(this.nextText(parser, strict), "testSourceDirectory"));
                    break;
                }
                case "outputDirectory": {
                    build.outputDirectory(this.interpolatedTrimmed(this.nextText(parser, strict), "outputDirectory"));
                    break;
                }
                case "testOutputDirectory": {
                    build.testOutputDirectory(this.interpolatedTrimmed(this.nextText(parser, strict), "testOutputDirectory"));
                    break;
                }
                case "extensions": {
                    ArrayList<Extension> extensions = new ArrayList<Extension>();
                    while (parser.nextTag() == 1) {
                        if ("extension".equals(parser.getLocalName())) {
                            extensions.add(this.parseExtension(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    build.extensions(extensions);
                    break;
                }
                case "defaultGoal": {
                    build.defaultGoal(this.interpolatedTrimmed(this.nextText(parser, strict), "defaultGoal"));
                    break;
                }
                case "resources": {
                    ArrayList<Resource> resources = new ArrayList<Resource>();
                    while (parser.nextTag() == 1) {
                        if ("resource".equals(parser.getLocalName())) {
                            resources.add(this.parseResource(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    build.resources(resources);
                    break;
                }
                case "testResources": {
                    ArrayList<Resource> testResources = new ArrayList<Resource>();
                    while (parser.nextTag() == 1) {
                        if ("testResource".equals(parser.getLocalName())) {
                            testResources.add(this.parseResource(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    build.testResources(testResources);
                    break;
                }
                case "directory": {
                    build.directory(this.interpolatedTrimmed(this.nextText(parser, strict), "directory"));
                    break;
                }
                case "finalName": {
                    build.finalName(this.interpolatedTrimmed(this.nextText(parser, strict), "finalName"));
                    break;
                }
                case "filters": {
                    ArrayList<String> filters = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("filter".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            filters.add(this.interpolatedTrimmed(this.nextText(parser, strict), "filters"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    build.filters(filters);
                    break;
                }
                case "pluginManagement": {
                    build.pluginManagement(this.parsePluginManagement(parser, strict, namespace, inputSrc));
                    break;
                }
                case "plugins": {
                    ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                    while (parser.nextTag() == 1) {
                        if ("plugin".equals(parser.getLocalName())) {
                            plugins.add(this.parsePlugin(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    build.plugins(plugins);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            build.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return build.build();
    }

    private CiManagement parseCiManagement(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        CiManagement.Builder ciManagement = CiManagement.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            ciManagement.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "system": {
                    ciManagement.system(this.interpolatedTrimmed(this.nextText(parser, strict), "system"));
                    break;
                }
                case "url": {
                    ciManagement.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "notifiers": {
                    ArrayList<Notifier> notifiers = new ArrayList<Notifier>();
                    while (parser.nextTag() == 1) {
                        if ("notifier".equals(parser.getLocalName())) {
                            notifiers.add(this.parseNotifier(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    ciManagement.notifiers(notifiers);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            ciManagement.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return ciManagement.build();
    }

    private Notifier parseNotifier(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Notifier.Builder notifier = Notifier.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            notifier.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<String, InputLocation> locations = null;
            switch (childName) {
                case "type": {
                    notifier.type(this.interpolatedTrimmed(this.nextText(parser, strict), "type"));
                    break;
                }
                case "sendOnError": {
                    notifier.sendOnError(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "sendOnError"), "sendOnError", parser, true));
                    break;
                }
                case "sendOnFailure": {
                    notifier.sendOnFailure(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "sendOnFailure"), "sendOnFailure", parser, true));
                    break;
                }
                case "sendOnSuccess": {
                    notifier.sendOnSuccess(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "sendOnSuccess"), "sendOnSuccess", parser, true));
                    break;
                }
                case "sendOnWarning": {
                    notifier.sendOnWarning(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "sendOnWarning"), "sendOnWarning", parser, true));
                    break;
                }
                case "address": {
                    notifier.address(this.interpolatedTrimmed(this.nextText(parser, strict), "address"));
                    break;
                }
                case "configuration": {
                    LinkedHashMap<String, String> configuration = new LinkedHashMap<String, String>();
                    locations = new HashMap<String, InputLocation>();
                    while (parser.nextTag() == 1) {
                        String key = parser.getLocalName();
                        String value = this.nextText(parser, strict).trim();
                        if (this.addLocationInformation) {
                            locations.put(key, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                        }
                        configuration.put(key, value);
                    }
                    notifier.configuration(configuration);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            notifier.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return notifier.build();
    }

    private Contributor parseContributor(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Contributor.Builder contributor = Contributor.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            contributor.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Object, InputLocation> locations = null;
            switch (childName) {
                case "name": {
                    contributor.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "email": {
                    contributor.email(this.interpolatedTrimmed(this.nextText(parser, strict), "email"));
                    break;
                }
                case "url": {
                    contributor.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "organization": {
                    contributor.organization(this.interpolatedTrimmed(this.nextText(parser, strict), "organization"));
                    break;
                }
                case "organizationUrl": {
                    contributor.organizationUrl(this.interpolatedTrimmed(this.nextText(parser, strict), "organizationUrl"));
                    break;
                }
                case "roles": {
                    ArrayList<String> roles = new ArrayList<String>();
                    locations = new HashMap<Object, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("role".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            roles.add(this.interpolatedTrimmed(this.nextText(parser, strict), "roles"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    contributor.roles(roles);
                    break;
                }
                case "timezone": {
                    contributor.timezone(this.interpolatedTrimmed(this.nextText(parser, strict), "timezone"));
                    break;
                }
                case "properties": {
                    LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        String key = parser.getLocalName();
                        String value = this.nextText(parser, strict).trim();
                        if (this.addLocationInformation) {
                            locations.put(key, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                        }
                        properties.put(key, value);
                    }
                    contributor.properties(properties);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            contributor.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return contributor.build();
    }

    private Dependency parseDependency(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Dependency.Builder dependency = Dependency.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            dependency.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "groupId": {
                    dependency.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    break;
                }
                case "artifactId": {
                    dependency.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    break;
                }
                case "version": {
                    dependency.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    break;
                }
                case "type": {
                    dependency.type(this.interpolatedTrimmed(this.nextText(parser, strict), "type"));
                    break;
                }
                case "classifier": {
                    dependency.classifier(this.interpolatedTrimmed(this.nextText(parser, strict), "classifier"));
                    break;
                }
                case "scope": {
                    dependency.scope(this.interpolatedTrimmed(this.nextText(parser, strict), "scope"));
                    break;
                }
                case "systemPath": {
                    dependency.systemPath(this.interpolatedTrimmed(this.nextText(parser, strict), "systemPath"));
                    break;
                }
                case "exclusions": {
                    ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
                    while (parser.nextTag() == 1) {
                        if ("exclusion".equals(parser.getLocalName())) {
                            exclusions.add(this.parseExclusion(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    dependency.exclusions(exclusions);
                    break;
                }
                case "optional": {
                    dependency.optional(this.interpolatedTrimmed(this.nextText(parser, strict), "optional"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            dependency.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return dependency.build();
    }

    private Developer parseDeveloper(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Developer.Builder developer = Developer.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            developer.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Object, InputLocation> locations = null;
            switch (childName) {
                case "id": {
                    developer.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                case "name": {
                    developer.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "email": {
                    developer.email(this.interpolatedTrimmed(this.nextText(parser, strict), "email"));
                    break;
                }
                case "url": {
                    developer.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "organization": {
                    developer.organization(this.interpolatedTrimmed(this.nextText(parser, strict), "organization"));
                    break;
                }
                case "organizationUrl": {
                    developer.organizationUrl(this.interpolatedTrimmed(this.nextText(parser, strict), "organizationUrl"));
                    break;
                }
                case "roles": {
                    ArrayList<String> roles = new ArrayList<String>();
                    locations = new HashMap<Object, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("role".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            roles.add(this.interpolatedTrimmed(this.nextText(parser, strict), "roles"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    developer.roles(roles);
                    break;
                }
                case "timezone": {
                    developer.timezone(this.interpolatedTrimmed(this.nextText(parser, strict), "timezone"));
                    break;
                }
                case "properties": {
                    LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        String key = parser.getLocalName();
                        String value = this.nextText(parser, strict).trim();
                        if (this.addLocationInformation) {
                            locations.put(key, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                        }
                        properties.put(key, value);
                    }
                    developer.properties(properties);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            developer.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return developer.build();
    }

    private Exclusion parseExclusion(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Exclusion.Builder exclusion = Exclusion.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            exclusion.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "groupId": {
                    exclusion.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    break;
                }
                case "artifactId": {
                    exclusion.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            exclusion.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return exclusion.build();
    }

    private IssueManagement parseIssueManagement(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        IssueManagement.Builder issueManagement = IssueManagement.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            issueManagement.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "system": {
                    issueManagement.system(this.interpolatedTrimmed(this.nextText(parser, strict), "system"));
                    break;
                }
                case "url": {
                    issueManagement.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            issueManagement.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return issueManagement.build();
    }

    private DistributionManagement parseDistributionManagement(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        DistributionManagement.Builder distributionManagement = DistributionManagement.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            distributionManagement.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "repository": {
                    distributionManagement.repository(this.parseDeploymentRepository(parser, strict, namespace, inputSrc));
                    break;
                }
                case "snapshotRepository": {
                    distributionManagement.snapshotRepository(this.parseDeploymentRepository(parser, strict, namespace, inputSrc));
                    break;
                }
                case "site": {
                    distributionManagement.site(this.parseSite(parser, strict, namespace, inputSrc));
                    break;
                }
                case "downloadUrl": {
                    distributionManagement.downloadUrl(this.interpolatedTrimmed(this.nextText(parser, strict), "downloadUrl"));
                    break;
                }
                case "relocation": {
                    distributionManagement.relocation(this.parseRelocation(parser, strict, namespace, inputSrc));
                    break;
                }
                case "status": {
                    distributionManagement.status(this.interpolatedTrimmed(this.nextText(parser, strict), "status"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            distributionManagement.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return distributionManagement.build();
    }

    private License parseLicense(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        License.Builder license = License.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            license.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "name": {
                    license.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "url": {
                    license.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "distribution": {
                    license.distribution(this.interpolatedTrimmed(this.nextText(parser, strict), "distribution"));
                    break;
                }
                case "comments": {
                    license.comments(this.interpolatedTrimmed(this.nextText(parser, strict), "comments"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            license.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return license.build();
    }

    private MailingList parseMailingList(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        MailingList.Builder mailingList = MailingList.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            mailingList.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "name": {
                    mailingList.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "subscribe": {
                    mailingList.subscribe(this.interpolatedTrimmed(this.nextText(parser, strict), "subscribe"));
                    break;
                }
                case "unsubscribe": {
                    mailingList.unsubscribe(this.interpolatedTrimmed(this.nextText(parser, strict), "unsubscribe"));
                    break;
                }
                case "post": {
                    mailingList.post(this.interpolatedTrimmed(this.nextText(parser, strict), "post"));
                    break;
                }
                case "archive": {
                    mailingList.archive(this.interpolatedTrimmed(this.nextText(parser, strict), "archive"));
                    break;
                }
                case "otherArchives": {
                    ArrayList<String> otherArchives = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("otherArchive".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            otherArchives.add(this.interpolatedTrimmed(this.nextText(parser, strict), "otherArchives"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    mailingList.otherArchives(otherArchives);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            mailingList.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return mailingList.build();
    }

    private Organization parseOrganization(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Organization.Builder organization = Organization.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            organization.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "name": {
                    organization.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "url": {
                    organization.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            organization.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return organization.build();
    }

    private PatternSet parsePatternSet(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        PatternSet.Builder patternSet = PatternSet.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            patternSet.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "includes": {
                    ArrayList<String> includes = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("include".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            includes.add(this.interpolatedTrimmed(this.nextText(parser, strict), "includes"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    patternSet.includes(includes);
                    break;
                }
                case "excludes": {
                    ArrayList<String> excludes = new ArrayList<String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        if ("exclude".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            excludes.add(this.interpolatedTrimmed(this.nextText(parser, strict), "excludes"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    patternSet.excludes(excludes);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            patternSet.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return patternSet.build();
    }

    private Parent parseParent(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Parent.Builder parent = Parent.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            parent.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "groupId": {
                    parent.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    break;
                }
                case "artifactId": {
                    parent.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    break;
                }
                case "version": {
                    parent.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    break;
                }
                case "relativePath": {
                    parent.relativePath(this.interpolatedTrimmed(this.nextText(parser, strict), "relativePath"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            parent.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return parent.build();
    }

    private Scm parseScm(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Scm.Builder scm = Scm.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            scm.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            if ("child.scm.connection.inherit.append.path".equals(name)) {
                if (this.addLocationInformation) {
                    scm.location((Object)name, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                }
                scm.childScmConnectionInheritAppendPath(this.interpolatedTrimmed(value, "child.scm.connection.inherit.append.path"));
                continue;
            }
            if ("child.scm.developerConnection.inherit.append.path".equals(name)) {
                if (this.addLocationInformation) {
                    scm.location((Object)name, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                }
                scm.childScmDeveloperConnectionInheritAppendPath(this.interpolatedTrimmed(value, "child.scm.developerConnection.inherit.append.path"));
                continue;
            }
            if ("child.scm.url.inherit.append.path".equals(name)) {
                if (this.addLocationInformation) {
                    scm.location((Object)name, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                }
                scm.childScmUrlInheritAppendPath(this.interpolatedTrimmed(value, "child.scm.url.inherit.append.path"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "connection": {
                    scm.connection(this.interpolatedTrimmed(this.nextText(parser, strict), "connection"));
                    break;
                }
                case "developerConnection": {
                    scm.developerConnection(this.interpolatedTrimmed(this.nextText(parser, strict), "developerConnection"));
                    break;
                }
                case "tag": {
                    scm.tag(this.interpolatedTrimmed(this.nextText(parser, strict), "tag"));
                    break;
                }
                case "url": {
                    scm.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            scm.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return scm.build();
    }

    private FileSet parseFileSet(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        FileSet.Builder fileSet = FileSet.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            fileSet.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "directory": {
                    fileSet.directory(this.interpolatedTrimmed(this.nextText(parser, strict), "directory"));
                    break;
                }
                case "includes": {
                    ArrayList<String> includes = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("include".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            includes.add(this.interpolatedTrimmed(this.nextText(parser, strict), "includes"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    fileSet.includes(includes);
                    break;
                }
                case "excludes": {
                    ArrayList<String> excludes = new ArrayList<String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        if ("exclude".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            excludes.add(this.interpolatedTrimmed(this.nextText(parser, strict), "excludes"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    fileSet.excludes(excludes);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            fileSet.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return fileSet.build();
    }

    private Source parseSource(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Source.Builder source = Source.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            source.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "scope": {
                    source.scope(this.interpolatedTrimmed(this.nextText(parser, strict), "scope"));
                    break;
                }
                case "lang": {
                    source.lang(this.interpolatedTrimmed(this.nextText(parser, strict), "lang"));
                    break;
                }
                case "module": {
                    source.module(this.interpolatedTrimmed(this.nextText(parser, strict), "module"));
                    break;
                }
                case "targetVersion": {
                    source.targetVersion(this.interpolatedTrimmed(this.nextText(parser, strict), "targetVersion"));
                    break;
                }
                case "targetPath": {
                    source.targetPath(this.interpolatedTrimmed(this.nextText(parser, strict), "targetPath"));
                    break;
                }
                case "stringFiltering": {
                    source.stringFiltering(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "stringFiltering"), "stringFiltering", parser, false));
                    break;
                }
                case "enabled": {
                    source.enabled(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "enabled"), "enabled", parser, true));
                    break;
                }
                case "directory": {
                    source.directory(this.interpolatedTrimmed(this.nextText(parser, strict), "directory"));
                    break;
                }
                case "includes": {
                    ArrayList<String> includes = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("include".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            includes.add(this.interpolatedTrimmed(this.nextText(parser, strict), "includes"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    source.includes(includes);
                    break;
                }
                case "excludes": {
                    ArrayList<String> excludes = new ArrayList<String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        if ("exclude".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            excludes.add(this.interpolatedTrimmed(this.nextText(parser, strict), "excludes"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    source.excludes(excludes);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            source.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return source.build();
    }

    private Resource parseResource(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Resource.Builder resource = Resource.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            resource.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "targetPath": {
                    resource.targetPath(this.interpolatedTrimmed(this.nextText(parser, strict), "targetPath"));
                    break;
                }
                case "filtering": {
                    resource.filtering(this.interpolatedTrimmed(this.nextText(parser, strict), "filtering"));
                    break;
                }
                case "directory": {
                    resource.directory(this.interpolatedTrimmed(this.nextText(parser, strict), "directory"));
                    break;
                }
                case "includes": {
                    ArrayList<String> includes = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("include".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            includes.add(this.interpolatedTrimmed(this.nextText(parser, strict), "includes"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    resource.includes(includes);
                    break;
                }
                case "excludes": {
                    ArrayList<String> excludes = new ArrayList<String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        if ("exclude".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            excludes.add(this.interpolatedTrimmed(this.nextText(parser, strict), "excludes"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    resource.excludes(excludes);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            resource.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return resource.build();
    }

    private RepositoryBase parseRepositoryBase(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        RepositoryBase.Builder repositoryBase = RepositoryBase.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            repositoryBase.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "id": {
                    repositoryBase.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                case "name": {
                    repositoryBase.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "url": {
                    repositoryBase.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "layout": {
                    repositoryBase.layout(this.interpolatedTrimmed(this.nextText(parser, strict), "layout"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            repositoryBase.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return repositoryBase.build();
    }

    private Repository parseRepository(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Repository.Builder repository = Repository.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            repository.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "releases": {
                    repository.releases(this.parseRepositoryPolicy(parser, strict, namespace, inputSrc));
                    break;
                }
                case "snapshots": {
                    repository.snapshots(this.parseRepositoryPolicy(parser, strict, namespace, inputSrc));
                    break;
                }
                case "id": {
                    repository.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                case "name": {
                    repository.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "url": {
                    repository.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "layout": {
                    repository.layout(this.interpolatedTrimmed(this.nextText(parser, strict), "layout"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            repository.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return repository.build();
    }

    private DeploymentRepository parseDeploymentRepository(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        DeploymentRepository.Builder deploymentRepository = DeploymentRepository.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            deploymentRepository.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "uniqueVersion": {
                    deploymentRepository.uniqueVersion(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "uniqueVersion"), "uniqueVersion", parser, true));
                    break;
                }
                case "releases": {
                    deploymentRepository.releases(this.parseRepositoryPolicy(parser, strict, namespace, inputSrc));
                    break;
                }
                case "snapshots": {
                    deploymentRepository.snapshots(this.parseRepositoryPolicy(parser, strict, namespace, inputSrc));
                    break;
                }
                case "id": {
                    deploymentRepository.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                case "name": {
                    deploymentRepository.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "url": {
                    deploymentRepository.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "layout": {
                    deploymentRepository.layout(this.interpolatedTrimmed(this.nextText(parser, strict), "layout"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            deploymentRepository.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return deploymentRepository.build();
    }

    private RepositoryPolicy parseRepositoryPolicy(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        RepositoryPolicy.Builder repositoryPolicy = RepositoryPolicy.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            repositoryPolicy.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "enabled": {
                    repositoryPolicy.enabled(this.interpolatedTrimmed(this.nextText(parser, strict), "enabled"));
                    break;
                }
                case "updatePolicy": {
                    repositoryPolicy.updatePolicy(this.interpolatedTrimmed(this.nextText(parser, strict), "updatePolicy"));
                    break;
                }
                case "checksumPolicy": {
                    repositoryPolicy.checksumPolicy(this.interpolatedTrimmed(this.nextText(parser, strict), "checksumPolicy"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            repositoryPolicy.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return repositoryPolicy.build();
    }

    private Site parseSite(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Site.Builder site = Site.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            site.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            if ("child.site.url.inherit.append.path".equals(name)) {
                if (this.addLocationInformation) {
                    site.location((Object)name, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                }
                site.childSiteUrlInheritAppendPath(this.interpolatedTrimmed(value, "child.site.url.inherit.append.path"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "id": {
                    site.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                case "name": {
                    site.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "url": {
                    site.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            site.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return site.build();
    }

    private ConfigurationContainer parseConfigurationContainer(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        ConfigurationContainer.Builder configurationContainer = ConfigurationContainer.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            configurationContainer.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "inherited": {
                    configurationContainer.inherited(this.interpolatedTrimmed(this.nextText(parser, strict), "inherited"));
                    break;
                }
                case "configuration": {
                    configurationContainer.configuration(this.buildXmlNode(parser, inputSrc));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            configurationContainer.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return configurationContainer.build();
    }

    private Plugin parsePlugin(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Plugin.Builder plugin = Plugin.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            plugin.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "groupId": {
                    plugin.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    break;
                }
                case "artifactId": {
                    plugin.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    break;
                }
                case "version": {
                    plugin.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    break;
                }
                case "extensions": {
                    plugin.extensions(this.interpolatedTrimmed(this.nextText(parser, strict), "extensions"));
                    break;
                }
                case "executions": {
                    ArrayList<PluginExecution> executions = new ArrayList<PluginExecution>();
                    while (parser.nextTag() == 1) {
                        if ("execution".equals(parser.getLocalName())) {
                            executions.add(this.parsePluginExecution(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    plugin.executions(executions);
                    break;
                }
                case "dependencies": {
                    ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                    while (parser.nextTag() == 1) {
                        if ("dependency".equals(parser.getLocalName())) {
                            dependencies.add(this.parseDependency(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    plugin.dependencies(dependencies);
                    break;
                }
                case "inherited": {
                    plugin.inherited(this.interpolatedTrimmed(this.nextText(parser, strict), "inherited"));
                    break;
                }
                case "configuration": {
                    plugin.configuration(this.buildXmlNode(parser, inputSrc));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            plugin.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return plugin.build();
    }

    private PluginExecution parsePluginExecution(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        PluginExecution.Builder pluginExecution = PluginExecution.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            pluginExecution.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "id": {
                    pluginExecution.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                case "phase": {
                    pluginExecution.phase(this.interpolatedTrimmed(this.nextText(parser, strict), "phase"));
                    break;
                }
                case "goals": {
                    ArrayList<String> goals = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("goal".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            goals.add(this.interpolatedTrimmed(this.nextText(parser, strict), "goals"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    pluginExecution.goals(goals);
                    break;
                }
                case "inherited": {
                    pluginExecution.inherited(this.interpolatedTrimmed(this.nextText(parser, strict), "inherited"));
                    break;
                }
                case "configuration": {
                    pluginExecution.configuration(this.buildXmlNode(parser, inputSrc));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            pluginExecution.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return pluginExecution.build();
    }

    private DependencyManagement parseDependencyManagement(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        DependencyManagement.Builder dependencyManagement = DependencyManagement.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            dependencyManagement.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "dependencies": {
                    ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                    while (parser.nextTag() == 1) {
                        if ("dependency".equals(parser.getLocalName())) {
                            dependencies.add(this.parseDependency(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    dependencyManagement.dependencies(dependencies);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            dependencyManagement.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return dependencyManagement.build();
    }

    private PluginManagement parsePluginManagement(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        PluginManagement.Builder pluginManagement = PluginManagement.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            pluginManagement.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "plugins": {
                    ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                    while (parser.nextTag() == 1) {
                        if ("plugin".equals(parser.getLocalName())) {
                            plugins.add(this.parsePlugin(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    pluginManagement.plugins(plugins);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            pluginManagement.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return pluginManagement.build();
    }

    private Reporting parseReporting(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Reporting.Builder reporting = Reporting.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            reporting.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "excludeDefaults": {
                    reporting.excludeDefaults(this.interpolatedTrimmed(this.nextText(parser, strict), "excludeDefaults"));
                    break;
                }
                case "outputDirectory": {
                    reporting.outputDirectory(this.interpolatedTrimmed(this.nextText(parser, strict), "outputDirectory"));
                    break;
                }
                case "plugins": {
                    ArrayList<ReportPlugin> plugins = new ArrayList<ReportPlugin>();
                    while (parser.nextTag() == 1) {
                        if ("plugin".equals(parser.getLocalName())) {
                            plugins.add(this.parseReportPlugin(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    reporting.plugins(plugins);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            reporting.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return reporting.build();
    }

    private Profile parseProfile(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Profile.Builder profile = Profile.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            profile.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Object, InputLocation> locations = null;
            switch (childName) {
                case "id": {
                    profile.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                case "activation": {
                    profile.activation(this.parseActivation(parser, strict, namespace, inputSrc));
                    break;
                }
                case "build": {
                    profile.build(this.parseBuildBase(parser, strict, namespace, inputSrc));
                    break;
                }
                case "modules": {
                    ArrayList<String> modules = new ArrayList<String>();
                    locations = new HashMap<Object, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("module".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            modules.add(this.interpolatedTrimmed(this.nextText(parser, strict), "modules"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    profile.modules(modules);
                    break;
                }
                case "subprojects": {
                    ArrayList<String> subprojects = new ArrayList<String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        if ("subproject".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            subprojects.add(this.interpolatedTrimmed(this.nextText(parser, strict), "subprojects"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    profile.subprojects(subprojects);
                    break;
                }
                case "distributionManagement": {
                    profile.distributionManagement(this.parseDistributionManagement(parser, strict, namespace, inputSrc));
                    break;
                }
                case "properties": {
                    LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        String key = parser.getLocalName();
                        String value = this.nextText(parser, strict).trim();
                        if (this.addLocationInformation) {
                            locations.put(key, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                        }
                        properties.put(key, value);
                    }
                    profile.properties(properties);
                    break;
                }
                case "dependencyManagement": {
                    profile.dependencyManagement(this.parseDependencyManagement(parser, strict, namespace, inputSrc));
                    break;
                }
                case "dependencies": {
                    ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                    while (parser.nextTag() == 1) {
                        if ("dependency".equals(parser.getLocalName())) {
                            dependencies.add(this.parseDependency(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    profile.dependencies(dependencies);
                    break;
                }
                case "repositories": {
                    ArrayList<Repository> repositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 1) {
                        if ("repository".equals(parser.getLocalName())) {
                            repositories.add(this.parseRepository(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    profile.repositories(repositories);
                    break;
                }
                case "pluginRepositories": {
                    ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 1) {
                        if ("pluginRepository".equals(parser.getLocalName())) {
                            pluginRepositories.add(this.parseRepository(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    profile.pluginRepositories(pluginRepositories);
                    break;
                }
                case "reporting": {
                    profile.reporting(this.parseReporting(parser, strict, namespace, inputSrc));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            profile.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return profile.build();
    }

    private Activation parseActivation(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Activation.Builder activation = Activation.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            activation.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "activeByDefault": {
                    activation.activeByDefault(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "activeByDefault"), "activeByDefault", parser, false));
                    break;
                }
                case "jdk": {
                    activation.jdk(this.interpolatedTrimmed(this.nextText(parser, strict), "jdk"));
                    break;
                }
                case "os": {
                    activation.os(this.parseActivationOS(parser, strict, namespace, inputSrc));
                    break;
                }
                case "property": {
                    activation.property(this.parseActivationProperty(parser, strict, namespace, inputSrc));
                    break;
                }
                case "file": {
                    activation.file(this.parseActivationFile(parser, strict, namespace, inputSrc));
                    break;
                }
                case "packaging": {
                    activation.packaging(this.interpolatedTrimmed(this.nextText(parser, strict), "packaging"));
                    break;
                }
                case "condition": {
                    activation.condition(this.interpolatedTrimmed(this.nextText(parser, strict), "condition"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            activation.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return activation.build();
    }

    private ActivationProperty parseActivationProperty(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        ActivationProperty.Builder activationProperty = ActivationProperty.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            activationProperty.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "name": {
                    activationProperty.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "value": {
                    activationProperty.value(this.interpolatedTrimmed(this.nextText(parser, strict), "value"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            activationProperty.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return activationProperty.build();
    }

    private ActivationOS parseActivationOS(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        ActivationOS.Builder activationOS = ActivationOS.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            activationOS.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "name": {
                    activationOS.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "family": {
                    activationOS.family(this.interpolatedTrimmed(this.nextText(parser, strict), "family"));
                    break;
                }
                case "arch": {
                    activationOS.arch(this.interpolatedTrimmed(this.nextText(parser, strict), "arch"));
                    break;
                }
                case "version": {
                    activationOS.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            activationOS.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return activationOS.build();
    }

    private ActivationFile parseActivationFile(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        ActivationFile.Builder activationFile = ActivationFile.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            activationFile.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "missing": {
                    activationFile.missing(this.interpolatedTrimmed(this.nextText(parser, strict), "missing"));
                    break;
                }
                case "exists": {
                    activationFile.exists(this.interpolatedTrimmed(this.nextText(parser, strict), "exists"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            activationFile.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return activationFile.build();
    }

    private ReportPlugin parseReportPlugin(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        ReportPlugin.Builder reportPlugin = ReportPlugin.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            reportPlugin.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "groupId": {
                    reportPlugin.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    break;
                }
                case "artifactId": {
                    reportPlugin.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    break;
                }
                case "version": {
                    reportPlugin.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    break;
                }
                case "reportSets": {
                    ArrayList<ReportSet> reportSets = new ArrayList<ReportSet>();
                    while (parser.nextTag() == 1) {
                        if ("reportSet".equals(parser.getLocalName())) {
                            reportSets.add(this.parseReportSet(parser, strict, namespace, inputSrc));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    reportPlugin.reportSets(reportSets);
                    break;
                }
                case "inherited": {
                    reportPlugin.inherited(this.interpolatedTrimmed(this.nextText(parser, strict), "inherited"));
                    break;
                }
                case "configuration": {
                    reportPlugin.configuration(this.buildXmlNode(parser, inputSrc));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            reportPlugin.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return reportPlugin.build();
    }

    private ReportSet parseReportSet(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        ReportSet.Builder reportSet = ReportSet.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            reportSet.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "id": {
                    reportSet.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                case "reports": {
                    ArrayList<String> reports = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("report".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
                            }
                            reports.add(this.interpolatedTrimmed(this.nextText(parser, strict), "reports"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    reportSet.reports(reports);
                    break;
                }
                case "inherited": {
                    reportSet.inherited(this.interpolatedTrimmed(this.nextText(parser, strict), "inherited"));
                    break;
                }
                case "configuration": {
                    reportSet.configuration(this.buildXmlNode(parser, inputSrc));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            reportSet.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return reportSet.build();
    }

    private Prerequisites parsePrerequisites(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Prerequisites.Builder prerequisites = Prerequisites.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            prerequisites.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "maven": {
                    prerequisites.maven(this.interpolatedTrimmed(this.nextText(parser, strict), "maven"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            prerequisites.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return prerequisites.build();
    }

    private Relocation parseRelocation(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Relocation.Builder relocation = Relocation.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            relocation.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "groupId": {
                    relocation.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    break;
                }
                case "artifactId": {
                    relocation.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    break;
                }
                case "version": {
                    relocation.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    break;
                }
                case "message": {
                    relocation.message(this.interpolatedTrimmed(this.nextText(parser, strict), "message"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            relocation.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return relocation.build();
    }

    private Extension parseExtension(XMLStreamReader parser, boolean strict, String namespace, InputSource inputSrc) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Extension.Builder extension = Extension.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            extension.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            this.checkNamespace(parser, strict, namespace);
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "groupId": {
                    extension.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    break;
                }
                case "artifactId": {
                    extension.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    break;
                }
                case "version": {
                    extension.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    break;
                }
                case "configuration": {
                    extension.configuration(this.buildXmlNode(parser, inputSrc));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            extension.location((Object)childName, new InputLocation(line, column, inputSrc, locations));
        }
        return extension.build();
    }

    private void checkNamespace(XMLStreamReader parser, boolean strict, String namespace) throws XMLStreamException {
        String ns;
        if (strict && !Objects.equals(namespace, ns = parser.getNamespaceURI())) {
            throw new XMLStreamException(String.format("Unexpected namespace for element '%s': found '%s' but expected '%s'", parser.getLocalName(), ns != null ? ns : "no namespace", namespace), parser.getLocation(), null);
        }
    }

    private String checkDuplicate(String tagName, XMLStreamReader parser, Set<String> parsed) throws XMLStreamException {
        switch (tagName) {
            case "organisation": {
                tagName = "organization";
                break;
            }
            case "organisationUrl": {
                tagName = "organizationUrl";
            }
        }
        if (!parsed.add(tagName)) {
            throw new XMLStreamException("Duplicated tag: '" + tagName + "'", parser.getLocation(), null);
        }
        return tagName;
    }

    private void checkUnknownAttribute(XMLStreamReader parser, String attribute, String tagName, boolean strict) throws XMLStreamException {
        if (strict) {
            throw new XMLStreamException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser.getLocation(), null);
        }
    }

    private void checkUnknownElement(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        if (strict) {
            throw new XMLStreamException("Unrecognised tag: '" + String.valueOf(parser.getName()) + "'", parser.getLocation(), null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = this.nextTag(parser);
            if (eventType == 1) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 2) continue;
            --unrecognizedTagCount;
        }
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XMLStreamReader parser) throws XMLStreamException {
        block4: while (true) {
            int next = parser.next();
            switch (next) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 12: {
                    continue block4;
                }
                case 1: 
                case 2: {
                    return next;
                }
            }
        }
    }

    private String nextText(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        int eventType = parser.getEventType();
        if (eventType != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", parser.getLocation(), null);
        }
        eventType = parser.next();
        StringBuilder result = new StringBuilder();
        while (true) {
            if (eventType == 4 || eventType == 12) {
                result.append(parser.getText());
            } else if (eventType == 9) {
                String val = null;
                if (strict) {
                    throw new XMLStreamException("Entities are not supported in strict mode", parser.getLocation(), null);
                }
                if (this.addDefaultEntities) {
                    val = DefaultEntitiesHolder.DEFAULT_ENTITIES.get(parser.getLocalName());
                }
                if (val != null) {
                    result.append(val);
                } else {
                    result.append("&").append(parser.getLocalName()).append(";");
                }
            } else if (eventType != 5) break;
            eventType = parser.next();
        }
        if (eventType != 2) {
            throw new XMLStreamException("TEXT must be immediately followed by END_ELEMENT and not " + eventType, parser.getLocation(), null);
        }
        return result.toString();
    }

    private XmlNode buildXmlNode(XMLStreamReader parser, InputSource inputSrc) throws XMLStreamException {
        return XmlService.read((XMLStreamReader)parser, this.addLocationInformation ? p -> new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), inputSrc) : null);
    }

    private boolean getBooleanValue(String s, String attribute, XMLStreamReader parser, boolean defaultValue) throws XMLStreamException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        return defaultValue;
    }

    private int getIntegerValue(String s, String attribute, XMLStreamReader parser, boolean strict, int defaultValue) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be an integer", parser.getLocation(), nfe);
                }
            }
        }
        return defaultValue;
    }

    private static Map<String, String> doGetDefaultEntities() {
        return Map.ofEntries(Map.entry("nbsp", "\u00a0"), Map.entry("iexcl", "\u00a1"), Map.entry("cent", "\u00a2"), Map.entry("pound", "\u00a3"), Map.entry("curren", "\u00a4"), Map.entry("yen", "\u00a5"), Map.entry("brvbar", "\u00a6"), Map.entry("sect", "\u00a7"), Map.entry("uml", "\u00a8"), Map.entry("copy", "\u00a9"), Map.entry("ordf", "\u00aa"), Map.entry("laquo", "\u00ab"), Map.entry("not", "\u00ac"), Map.entry("shy", "\u00ad"), Map.entry("reg", "\u00ae"), Map.entry("macr", "\u00af"), Map.entry("deg", "\u00b0"), Map.entry("plusmn", "\u00b1"), Map.entry("sup2", "\u00b2"), Map.entry("sup3", "\u00b3"), Map.entry("acute", "\u00b4"), Map.entry("micro", "\u00b5"), Map.entry("para", "\u00b6"), Map.entry("middot", "\u00b7"), Map.entry("cedil", "\u00b8"), Map.entry("sup1", "\u00b9"), Map.entry("ordm", "\u00ba"), Map.entry("raquo", "\u00bb"), Map.entry("frac14", "\u00bc"), Map.entry("frac12", "\u00bd"), Map.entry("frac34", "\u00be"), Map.entry("iquest", "\u00bf"), Map.entry("Agrave", "\u00c0"), Map.entry("Aacute", "\u00c1"), Map.entry("Acirc", "\u00c2"), Map.entry("Atilde", "\u00c3"), Map.entry("Auml", "\u00c4"), Map.entry("Aring", "\u00c5"), Map.entry("AElig", "\u00c6"), Map.entry("Ccedil", "\u00c7"), Map.entry("Egrave", "\u00c8"), Map.entry("Eacute", "\u00c9"), Map.entry("Ecirc", "\u00ca"), Map.entry("Euml", "\u00cb"), Map.entry("Igrave", "\u00cc"), Map.entry("Iacute", "\u00cd"), Map.entry("Icirc", "\u00ce"), Map.entry("Iuml", "\u00cf"), Map.entry("ETH", "\u00d0"), Map.entry("Ntilde", "\u00d1"), Map.entry("Ograve", "\u00d2"), Map.entry("Oacute", "\u00d3"), Map.entry("Ocirc", "\u00d4"), Map.entry("Otilde", "\u00d5"), Map.entry("Ouml", "\u00d6"), Map.entry("times", "\u00d7"), Map.entry("Oslash", "\u00d8"), Map.entry("Ugrave", "\u00d9"), Map.entry("Uacute", "\u00da"), Map.entry("Ucirc", "\u00db"), Map.entry("Uuml", "\u00dc"), Map.entry("Yacute", "\u00dd"), Map.entry("THORN", "\u00de"), Map.entry("szlig", "\u00df"), Map.entry("agrave", "\u00e0"), Map.entry("aacute", "\u00e1"), Map.entry("acirc", "\u00e2"), Map.entry("atilde", "\u00e3"), Map.entry("auml", "\u00e4"), Map.entry("aring", "\u00e5"), Map.entry("aelig", "\u00e6"), Map.entry("ccedil", "\u00e7"), Map.entry("egrave", "\u00e8"), Map.entry("eacute", "\u00e9"), Map.entry("ecirc", "\u00ea"), Map.entry("euml", "\u00eb"), Map.entry("igrave", "\u00ec"), Map.entry("iacute", "\u00ed"), Map.entry("icirc", "\u00ee"), Map.entry("iuml", "\u00ef"), Map.entry("eth", "\u00f0"), Map.entry("ntilde", "\u00f1"), Map.entry("ograve", "\u00f2"), Map.entry("oacute", "\u00f3"), Map.entry("ocirc", "\u00f4"), Map.entry("otilde", "\u00f5"), Map.entry("ouml", "\u00f6"), Map.entry("divide", "\u00f7"), Map.entry("oslash", "\u00f8"), Map.entry("ugrave", "\u00f9"), Map.entry("uacute", "\u00fa"), Map.entry("ucirc", "\u00fb"), Map.entry("uuml", "\u00fc"), Map.entry("yacute", "\u00fd"), Map.entry("thorn", "\u00fe"), Map.entry("yuml", "\u00ff"), Map.entry("OElig", "\u0152"), Map.entry("oelig", "\u0153"), Map.entry("Scaron", "\u0160"), Map.entry("scaron", "\u0161"), Map.entry("Yuml", "\u0178"), Map.entry("circ", "\u02c6"), Map.entry("tilde", "\u02dc"), Map.entry("ensp", "\u2002"), Map.entry("emsp", "\u2003"), Map.entry("thinsp", "\u2009"), Map.entry("zwnj", "\u200c"), Map.entry("zwj", "\u200d"), Map.entry("lrm", "\u200e"), Map.entry("rlm", "\u200f"), Map.entry("ndash", "\u2013"), Map.entry("mdash", "\u2014"), Map.entry("lsquo", "\u2018"), Map.entry("rsquo", "\u2019"), Map.entry("sbquo", "\u201a"), Map.entry("ldquo", "\u201c"), Map.entry("rdquo", "\u201d"), Map.entry("bdquo", "\u201e"), Map.entry("dagger", "\u2020"), Map.entry("Dagger", "\u2021"), Map.entry("permil", "\u2030"), Map.entry("lsaquo", "\u2039"), Map.entry("rsaquo", "\u203a"), Map.entry("euro", "\u20ac"), Map.entry("fnof", "\u0192"), Map.entry("Alpha", "\u0391"), Map.entry("Beta", "\u0392"), Map.entry("Gamma", "\u0393"), Map.entry("Delta", "\u0394"), Map.entry("Epsilon", "\u0395"), Map.entry("Zeta", "\u0396"), Map.entry("Eta", "\u0397"), Map.entry("Theta", "\u0398"), Map.entry("Iota", "\u0399"), Map.entry("Kappa", "\u039a"), Map.entry("Lambda", "\u039b"), Map.entry("Mu", "\u039c"), Map.entry("Nu", "\u039d"), Map.entry("Xi", "\u039e"), Map.entry("Omicron", "\u039f"), Map.entry("Pi", "\u03a0"), Map.entry("Rho", "\u03a1"), Map.entry("Sigma", "\u03a3"), Map.entry("Tau", "\u03a4"), Map.entry("Upsilon", "\u03a5"), Map.entry("Phi", "\u03a6"), Map.entry("Chi", "\u03a7"), Map.entry("Psi", "\u03a8"), Map.entry("Omega", "\u03a9"), Map.entry("alpha", "\u03b1"), Map.entry("beta", "\u03b2"), Map.entry("gamma", "\u03b3"), Map.entry("delta", "\u03b4"), Map.entry("epsilon", "\u03b5"), Map.entry("zeta", "\u03b6"), Map.entry("eta", "\u03b7"), Map.entry("theta", "\u03b8"), Map.entry("iota", "\u03b9"), Map.entry("kappa", "\u03ba"), Map.entry("lambda", "\u03bb"), Map.entry("mu", "\u03bc"), Map.entry("nu", "\u03bd"), Map.entry("xi", "\u03be"), Map.entry("omicron", "\u03bf"), Map.entry("pi", "\u03c0"), Map.entry("rho", "\u03c1"), Map.entry("sigmaf", "\u03c2"), Map.entry("sigma", "\u03c3"), Map.entry("tau", "\u03c4"), Map.entry("upsilon", "\u03c5"), Map.entry("phi", "\u03c6"), Map.entry("chi", "\u03c7"), Map.entry("psi", "\u03c8"), Map.entry("omega", "\u03c9"), Map.entry("thetasym", "\u03d1"), Map.entry("upsih", "\u03d2"), Map.entry("piv", "\u03d6"), Map.entry("bull", "\u2022"), Map.entry("hellip", "\u2026"), Map.entry("prime", "\u2032"), Map.entry("Prime", "\u2033"), Map.entry("oline", "\u203e"), Map.entry("frasl", "\u2044"), Map.entry("weierp", "\u2118"), Map.entry("image", "\u2111"), Map.entry("real", "\u211c"), Map.entry("trade", "\u2122"), Map.entry("alefsym", "\u2135"), Map.entry("larr", "\u2190"), Map.entry("uarr", "\u2191"), Map.entry("rarr", "\u2192"), Map.entry("darr", "\u2193"), Map.entry("harr", "\u2194"), Map.entry("crarr", "\u21b5"), Map.entry("lArr", "\u21d0"), Map.entry("uArr", "\u21d1"), Map.entry("rArr", "\u21d2"), Map.entry("dArr", "\u21d3"), Map.entry("hArr", "\u21d4"), Map.entry("forall", "\u2200"), Map.entry("part", "\u2202"), Map.entry("exist", "\u2203"), Map.entry("empty", "\u2205"), Map.entry("nabla", "\u2207"), Map.entry("isin", "\u2208"), Map.entry("notin", "\u2209"), Map.entry("ni", "\u220b"), Map.entry("prod", "\u220f"), Map.entry("sum", "\u2211"), Map.entry("minus", "\u2212"), Map.entry("lowast", "\u2217"), Map.entry("radic", "\u221a"), Map.entry("prop", "\u221d"), Map.entry("infin", "\u221e"), Map.entry("ang", "\u2220"), Map.entry("and", "\u2227"), Map.entry("or", "\u2228"), Map.entry("cap", "\u2229"), Map.entry("cup", "\u222a"), Map.entry("int", "\u222b"), Map.entry("there4", "\u2234"), Map.entry("sim", "\u223c"), Map.entry("cong", "\u2245"), Map.entry("asymp", "\u2248"), Map.entry("ne", "\u2260"), Map.entry("equiv", "\u2261"), Map.entry("le", "\u2264"), Map.entry("ge", "\u2265"), Map.entry("sub", "\u2282"), Map.entry("sup", "\u2283"), Map.entry("nsub", "\u2284"), Map.entry("sube", "\u2286"), Map.entry("supe", "\u2287"), Map.entry("oplus", "\u2295"), Map.entry("otimes", "\u2297"), Map.entry("perp", "\u22a5"), Map.entry("sdot", "\u22c5"), Map.entry("lceil", "\u2308"), Map.entry("rceil", "\u2309"), Map.entry("lfloor", "\u230a"), Map.entry("rfloor", "\u230b"), Map.entry("lang", "\u2329"), Map.entry("rang", "\u232a"), Map.entry("loz", "\u25ca"), Map.entry("spades", "\u2660"), Map.entry("clubs", "\u2663"), Map.entry("hearts", "\u2665"), Map.entry("diams", "\u2666"));
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }

    static class InputFactoryHolder {
        static final XMLInputFactory XML_INPUT_FACTORY;

        InputFactoryHolder() {
        }

        static {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            XML_INPUT_FACTORY = factory;
        }
    }

    static class DefaultEntitiesHolder {
        static final Map<String, String> DEFAULT_ENTITIES = MavenStaxReader.doGetDefaultEntities();

        DefaultEntitiesHolder() {
        }
    }
}

