# -*- shell-script -*-
# Script to set up a C shell environment to use a
# Miriad installation created with the autotools build
# system. A separate script is necessary because the 
# directory structure of an autotoolized Miriad install
# is fairly different from that of a binary tree
# built with the classic build system.
#
# Most of the definitions here have just been copied from the 
# MIRRC.linux file. I wouldn't be surprised if many of
# them were no longer necessary or useful. (PKGW 07/02/07)

# Get the pgplot definitions.

source "/opt/local/lib/pgplot-miriad-remix/pgplot-config.csh"

# Constants

setenv AIPSTV "XASIN"
setenv MIRPAGER "doc"
setenv MIRDEF .

# Things that come directly from the source tree

setenv MIR "/opt/local/var/macports/build/_opt_bblocal_var_buildworker_ports_build_ports_science_miriad/miriad/work/miriad-4.3.8"
setenv MIRNEWS "$MIR/news"
setenv MIRPROG "$MIR/src/prog"
setenv MIRSRC "$MIR/src"
setenv MIRSUBS "$MIR/src/subs"

# Things that are built by the build system. MIRINC must
# go here because of the maxdim headers.

setenv MIRBIN "/opt/local/libexec/miriad"
setenv MIRLIB "/opt/local/lib"
setenv MIRCAT "/opt/local/share/miriad/cat"
setenv MIRINC "/opt/local/include/miriad-f"
setenv MIRDOC "/opt/local/share/miriad/doc"
setenv MIRPDOC "$MIRDOC/prog"
setenv MIRSDOC "$MIRDOC/subs"

# FIXME? Haven't copied the code to try to add bindir to the path
# after '.' if the latter is in it.

set path = ("$MIRBIN" $path)

alias mirfind mir.find
alias mirhelp mir.help
alias mirindex mir.index
alias mirbug 'mir.bug.csh bug'
alias mirfeedback 'mir.bug.csh feedback'

# FIXME: we may want to export WIPHELP

# Import site-specific customizations. Hopefully our
# environment variables will be enough to make us 
# compatible with existing scripts, even though our
# directory structure is different than that of a 
# classic install.

if ( -e "$MIR/MIRRC.local" ) then
    source "$MIR/MIRRC.local"
endif

# Import user customizations. Same rationale as above.

if ($?HOME) then
  if ( -e "$HOME/.automirsrc" ) then
    source "$HOME/.automirsrc"
  endif
endif

