# -*- shell-script -*-
# Script to set up a Bourne shell environment to use a
# Miriad installation created with the autotools build
# system. A separate script is necessary because the 
# directory structure of an autotoolized Miriad install
# is fairly different from that of a binary tree
# built with the classic build system.
#
# For comments on the definitions in this file, see 
# automiriad.csh.

# Get the pgplot definitions.

. "/opt/local/lib/pgplot-miriad-remix/pgplot-config.sh"

# Constants

export AIPSTV="XASIN"
export MIRPAGER="doc"
export MIRDEF=.

# Things that come directly from the source tree

export MIR="/opt/local/var/macports/build/_opt_bblocal_var_buildworker_ports_build_ports_science_miriad/miriad/work/miriad-4.3.8"
export MIRNEWS="$MIR/news"
export MIRPROG="$MIR/src/prog"
export MIRSRC="$MIR/src"
export MIRSUBS="$MIR/src/subs"

# Things that are built by the build system. MIRINC must
# go here because of the maxdim headers.

export MIRBIN="/opt/local/libexec/miriad"
export MIRLIB="/opt/local/lib"
export MIRCAT="/opt/local/share/miriad/cat"
export MIRINC="/opt/local/include/miriad-f"
export MIRDOC="/opt/local/share/miriad/doc"
export MIRPDOC="$MIRDOC/prog"
export MIRSDOC="$MIRDOC/subs"

# Misc.

export PATH="$MIRBIN:$PATH"

alias mirfind=mir.find
alias mirhelp=mir.help
alias mirindex=mir.index
alias mirbug='mir.bug.csh bug'
alias mirfeedback='mir.bug.csh feedback'

# Customizations.

if [ -f "$MIR/MIRSRC.local" ]; then
    . "$MIR/MIRSRC.local"
fi

if ! test -z $HOME ; then
  if [ -f "$HOME/.mirsrc" ] ; then
    . "$HOME/.mirsrc"
  fi
fi
