/* Autogenerated by mlir-tblgen; don't manually edit */
#ifdef GEN_PASS_CLASSES

//===----------------------------------------------------------------------===//
// OptReduction
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class OptReductionBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = OptReductionBase;

  OptReductionBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  OptReductionBase(const OptReductionBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("opt-reduction-pass");
  }
  ::llvm::StringRef getArgument() const override { return "opt-reduction-pass"; }

  ::llvm::StringRef getDescription() const override { return "A wrapper pass that reduces the file with optimization passes"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("OptReduction");
  }
  ::llvm::StringRef getName() const override { return "OptReduction"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(OptReductionBase<DerivedT>)

protected:
  ::mlir::Pass::Option<std::string> optPass{*this, "opt-pass", ::llvm::cl::desc("The optimization passes used for reduction, e.g., symbol-dce")};
  ::mlir::Pass::Option<std::string> testerName{*this, "test", ::llvm::cl::desc("The location of the tester which tests the file interestingness")};
  ::mlir::Pass::ListOption<std::string> testerArgs{*this, "test-arg", ::llvm::cl::desc("arguments of the tester")};
};

//===----------------------------------------------------------------------===//
// ReductionTree
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ReductionTreeBase : public ::mlir::OperationPass<> {
public:
  using Base = ReductionTreeBase;

  ReductionTreeBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ReductionTreeBase(const ReductionTreeBase &other) : ::mlir::OperationPass<>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("reduction-tree");
  }
  ::llvm::StringRef getArgument() const override { return "reduction-tree"; }

  ::llvm::StringRef getDescription() const override { return "Reduce the input with reduction-tree algorithm"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ReductionTree");
  }
  ::llvm::StringRef getName() const override { return "ReductionTree"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ReductionTreeBase<DerivedT>)

protected:
  ::mlir::Pass::Option<unsigned> traversalModeId{*this, "traversal-mode", ::llvm::cl::desc("The graph traversal mode, the default is single-path mode"), ::llvm::cl::init(0)};
  ::mlir::Pass::Option<std::string> testerName{*this, "test", ::llvm::cl::desc("The location of the tester which tests the file interestingness")};
  ::mlir::Pass::ListOption<std::string> testerArgs{*this, "test-arg", ::llvm::cl::desc("arguments of the tester")};
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// OptReduction Registration
//===----------------------------------------------------------------------===//

inline void registerOptReductionPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createOptReductionPass();
  });
}

//===----------------------------------------------------------------------===//
// ReductionTree Registration
//===----------------------------------------------------------------------===//

inline void registerReductionTreePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createReductionTreePass();
  });
}

//===----------------------------------------------------------------------===//
// Reducer Registration
//===----------------------------------------------------------------------===//

inline void registerReducerPasses() {
  registerOptReductionPass();
  registerReductionTreePass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
