/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: LoopExtensionOps.td                                                  *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace transform {
/// Hoist loop invariant subset ops
/// This transform hoists loop-invariant subset ops out of the targeted
///     loop-like op. It looks for matching subset extraction/insertion op pairs and
///     hoists them. The loop body operates on a newly introduced region iter_arg.
/// 
///     Subset ops are hoisted only from the targeted op. If subset ops should be
///     hoisted from an entire loop nest, this transformation must be applied to
///     each loop-like op of the loop nest, starting with the innermost loop and
///     ending with the outermost loop.
/// 
///     Example:
///     ```
///     %r = scf.for ... iter_args(%t = %a) -> (tensor<?xf32>) {
///       %0 = tensor.extract_slice %t[0][5][1] : tensor<?xf32> to tensor<5xf32>
///       %1 = "test.foo"(%0) : (tensor<5xf32>) -> (tensor<5xf32>)
///       %2 = tensor.insert_slice %1 into %t[0][5][1]
///           : tensor<5xf32> into tensor<?xf32>
///       scf.yield %2 : tensor<?xf32>
///     }
///     ```
///     Is transformed to:
///     ```
///     %0 = tensor.extract_slice %a[0][5][1] : tensor<?xf32> to tensor<5xf32>
///     %new_loop:2 = scf.for ... iter_args(%t = %a, %h = %0) -> (tensor<?xf32>) {
///       %1 = "test.foo"(%h) : (tensor<5xf32>) -> (tensor<5xf32>)
///       scf.yield %t, %2 : tensor<?xf32>, tensor<5xf32>
///     }
///     %r = tensor.insert_slice %new_loop#1 into %new_loop#0
///         : tensor<5xf32> into tensor<?xf32>
///     ```
/// 
///     Subset ops are hoisted only if there are no conflicting subset ops. E.g.,
///     if there were a second overlapping extraction in the above example, no ops
///     could be hoisted safely.
/// 
///     This transform reads the target handle and modifies the payload. This
///     transform does not invalidate any handles, but loop-like ops are replaced
///     with new loop-like ops when a subset op is hoisted. The transform rewriter
///     updates all handles accordingly.
class HoistLoopInvariantSubsetsOp;
} // namespace transform
} // namespace mlir
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace mlir {
namespace transform {

//===----------------------------------------------------------------------===//
// ::mlir::transform::HoistLoopInvariantSubsetsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class HoistLoopInvariantSubsetsOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  HoistLoopInvariantSubsetsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("transform.loop.hoist_loop_invariant_subsets", odsAttrs.getContext());
  }

  HoistLoopInvariantSubsetsOpGenericAdaptorBase(HoistLoopInvariantSubsetsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class HoistLoopInvariantSubsetsOpGenericAdaptor : public detail::HoistLoopInvariantSubsetsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::HoistLoopInvariantSubsetsOpGenericAdaptorBase;
  static constexpr int odsIndex_target = 0;
public:
  HoistLoopInvariantSubsetsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  HoistLoopInvariantSubsetsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : HoistLoopInvariantSubsetsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  HoistLoopInvariantSubsetsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : HoistLoopInvariantSubsetsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  HoistLoopInvariantSubsetsOpGenericAdaptor(RangeT values, const HoistLoopInvariantSubsetsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = HoistLoopInvariantSubsetsOp, typename = std::enable_if_t<std::is_same_v<LateInst, HoistLoopInvariantSubsetsOp>>>
  HoistLoopInvariantSubsetsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getTarget() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class HoistLoopInvariantSubsetsOpAdaptor : public HoistLoopInvariantSubsetsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using HoistLoopInvariantSubsetsOpGenericAdaptor::HoistLoopInvariantSubsetsOpGenericAdaptor;
  HoistLoopInvariantSubsetsOpAdaptor(HoistLoopInvariantSubsetsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class HoistLoopInvariantSubsetsOp : public ::mlir::Op<HoistLoopInvariantSubsetsOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::transform::TransformOpInterface::Trait, ::mlir::transform::TransformEachOpTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::transform::ReportTrackingListenerFailuresOpTrait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = HoistLoopInvariantSubsetsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = HoistLoopInvariantSubsetsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_target = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("transform.loop.hoist_loop_invariant_subsets");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface> getTarget() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getTargetMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value target);
  static HoistLoopInvariantSubsetsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value target);
  static HoistLoopInvariantSubsetsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value target);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target);
  static HoistLoopInvariantSubsetsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target);
  static HoistLoopInvariantSubsetsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static HoistLoopInvariantSubsetsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static HoistLoopInvariantSubsetsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static HoistLoopInvariantSubsetsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static HoistLoopInvariantSubsetsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
  ::mlir::DiagnosedSilenceableFailure applyToOne(
    ::mlir::transform::TransformRewriter &rewriter,
    ::mlir::LoopLikeOpInterface loopLikeOp,
    ::mlir::transform::ApplyToEachResultList &results,
    ::mlir::transform::TransformState &state);
};
} // namespace transform
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::transform::HoistLoopInvariantSubsetsOp)


#endif  // GET_OP_CLASSES

