# v4.0

This release sees significant improvements for use with non-latin characters in both the interactive prompt and shell scripting. It introduces new syntax to make working with structured data even easier than before. As well as new data types and smoother user experience.

## Breaking Changes

* `$PWD` is no longer a `str`. If you need to parse `$PWD` as a string then you should `out: $PWD` or use `${pwd}`

* `.` is now a valid bareword character for variables. This will break any instances in code that contain something like `out $hello.` however you can now use `out $(hello).` syntax for safer string infixing

## Features

* dot notation added for variables which allow accessing and writing to object properties. eg `$json.array.index`

* added support variable encapsulation via `$()` to avoid variable barewords from leaking into other values when infixed. eg `$(foobar)` is the same as `$foobar` ([read more](../parser/string.md))

* variable names can now be Unicode, eg `$(比如) = "举手之劳就可以使办公室更加环保，比如，使用再生纸。"` ([read more](../parser/string.md))

* Unicode wide characters are properly handled in readline

* new data type `path` that is an object

* new data type `paths`

* support for lambdas added to variables: eg `@array[{ function }]`

* readline `[ctrl]`+`[f]` now supports word matching as well as regexp ([read more](../user-guide/terminal-keys.md))

* readline `[ctrl]`+`[f]` now supports glob filters (eg `*.txt`) too ([read more](../user-guide/terminal-keys.md))

* `$ENV` and `$GLOBAL` objects (deprecates the need for `global` and `export`)

* improved error messages in expressions

* scalars can be used as assignees in expressions, eg `$foo = "bar"`

* added `-i` flag to ssh autocompletion

* readline prompts are now buffered to reduce cursor flickering

## Non-User Facing / Maintenance Changes

* backend support added for data types to be dynamic objects

* updated autocompletion code for `docker` and `git`

## Bug Fixes

* better wide character support in auto completion suggestions

* function parameters default and comment fields are no longer order dependent 

* better string parsing for barewords inside arrays and objects

* ahead of time hint caching now done on demand per hint page rather than against every executable upon Murex start up

* new lines should be ignored in `%{}`

* bareword `true` and `false` should be converted to boolean in `%{}`

* autocomplete suggestions are now dedup'ed when delayed results return similar suggestions to fast results

* various preview pane bug fixes

* support for ANSI escape sequences in experimental (disabled by default) TTY buffer

* correction to `count` docs

* error not handled in regexp expression matches, `=~`

<hr>

Published: 26.03.2023 at 17:50

## See Also

* [Count: `count`](../commands/count.md):
  Count items in a map, list or array
* [Interactive Shell](../user-guide/interactive-shell.md):
  What's different about Murex's interactive shell?
* [Public Function: `function`](../commands/function.md):
  Define a function block
* [Terminal Hotkeys](../user-guide/terminal-keys.md):
  A list of all the terminal hotkeys and their uses
* [`%[]` Array Builder](../parser/create-array.md):
  Quickly generate arrays
* [`%{}` Object Builder](../parser/create-object.md):
  Quickly generate objects (dictionaries / maps)
* [`path`](../types/path.md):
  Structured object for working with file and directory paths
* [`paths`](../types/paths.md):
  Structured array for working with `$PATH` style data
* [`string` (stringing)](../types/str.md):
  string (primitive)

<hr/>

This document was generated from [gen/changelog/v4.0_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/changelog/v4.0_doc.yaml).