(*
 * config - Configuration module for OCaml Batteries Included
 * Copyright (C) 2008 David Teller, LIFO, Universite d'Orleans
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version,
 * with the special exception on linking described in file LICENSE.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *)

let version = "3.8.0";;
let documentation_root = "@DOCROOT@";;
let (browser: (_, _, _) format) = "@BROWSER_COMMAND@ %s";;

(**The default function to open a www browser.*)
let default_browse s =
  let command = Printf.sprintf browser s in
  Sys.command command
let current_browse = ref default_browse

let browse s = !current_browse s
let set_browser f    = current_browse := f

let max_array_length = Sys.max_array_length
let word_size        = Sys.word_size
let max_string_length= Sys.max_string_length
