# 10 "src/lTerm_inputrc.mll"
 
  open LTerm_key

  let return, (>>=) = Lwt.return, Lwt.(>>=)

  exception Parse_error of string * int * string

  let parse_error src line fmt = Printf.ksprintf (fun msg -> raise (Parse_error (src, line, msg))) fmt

  let handle_edit_action src line seq actions =
    if actions = [] then
      LTerm_edit.unbind seq
    else
      let actions =
        List.map
          (fun str ->
             try
               LTerm_edit.action_of_name str
             with Not_found ->
               parse_error src line "invalid edit action %S" str)
          actions
      in
      LTerm_edit.bind seq actions

  let handle_read_line_action src line seq actions =
    if actions = [] then
      LTerm_read_line.unbind seq
    else
      let actions =
        List.map
          (fun str ->
             try
               LTerm_read_line.action_of_name str
             with Not_found ->
               parse_error src line "invalid read-line action %S" str)
          actions
      in
      LTerm_read_line.bind seq actions

  type line =
    | Comment
    | Section of string
    | Binding of LTerm_key.t list * string list
    | Error of string

  let dummy_key = { control = false; meta = false; shift = false; code = Escape }

# 50 "src/lTerm_inputrc.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base =
   "\000\000\001\000\002\000\255\255\254\255\004\000\005\000\008\000\
    \253\255\006\000\066\000\009\000\010\000\029\000\014\000\017\000\
    \181\000\184\000\194\000\195\000\196\000\197\000\201\000\205\000\
    \206\000\011\000\012\000\013\000\226\255\015\000\255\255\254\255\
    \253\255\001\000\095\000\016\000\004\000\048\000\018\000\252\255\
    \019\000\230\255\020\000\000\000\082\000\095\000\022\000\251\255\
    \046\000\099\000\208\000\250\255\050\000\209\000\249\255\051\000\
    \090\000\080\000\090\000\000\001\248\255\053\000\100\000\086\000\
    \106\000\003\001\228\255\054\000\106\000\093\000\004\001\247\255\
    \056\000\109\000\115\000\104\000\005\001\246\255\057\000\006\001\
    \008\001\011\001\013\001\015\001\016\001\017\001\018\001\045\001\
    \021\001\024\001\046\001\245\255\064\000\236\255\019\001\235\255\
    \058\001\234\255\059\001\244\255\074\001\243\255\075\001\242\255\
    \076\001\241\255\077\001\240\255\078\001\239\255\079\001\238\255\
    \080\001\237\255\083\001\101\000\106\000\087\001\233\255\088\001\
    \122\000\106\000\089\001\232\255\090\001\116\000\129\000\091\001\
    \231\255\092\001\116\000\131\000\120\000\119\000\093\001\229\255\
    \096\001\137\000\165\000\159\000\163\000\180\000\180\000\186\000\
    \104\001\227\255\105\001\104\001\159\001\225\255\107\001\209\001\
    \036\002\255\255\080\000\150\002\178\001\254\255\131\001\254\255\
    \049\001\255\255\132\001";
  Lexing.lex_backtrk =
   "\003\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\031\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\029\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \003\000\255\255\025\000\255\255\255\255\255\255\255\255\255\255\
    \004\000\255\255\255\255\255\255\005\000\255\255\255\255\006\000\
    \255\255\255\255\255\255\255\255\255\255\007\000\255\255\255\255\
    \255\255\255\255\255\255\027\000\255\255\255\255\255\255\255\255\
    \008\000\255\255\255\255\255\255\255\255\255\255\009\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\010\000\255\255\019\000\255\255\
    \020\000\255\255\021\000\255\255\011\000\255\255\012\000\255\255\
    \013\000\255\255\014\000\255\255\015\000\255\255\016\000\255\255\
    \017\000\255\255\018\000\255\255\255\255\255\255\255\255\022\000\
    \255\255\255\255\255\255\255\255\023\000\255\255\255\255\255\255\
    \255\255\024\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \026\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\028\000\255\255\255\255\255\255\030\000\002\000\
    \001\000\255\255\255\255\255\255\255\255\255\255\002\000\255\255\
    \255\255\255\255\255\255";
  Lexing.lex_default =
   "\255\255\006\000\002\000\000\000\000\000\255\255\006\000\255\255\
    \000\000\009\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\000\000\255\255\000\000\000\000\
    \000\000\255\255\255\255\255\255\255\255\255\255\255\255\000\000\
    \255\255\000\000\255\255\255\255\255\255\255\255\255\255\000\000\
    \255\255\255\255\255\255\000\000\255\255\255\255\000\000\255\255\
    \255\255\255\255\255\255\255\255\000\000\255\255\255\255\255\255\
    \255\255\255\255\000\000\255\255\255\255\255\255\255\255\000\000\
    \255\255\255\255\255\255\255\255\255\255\000\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\000\000\255\255\000\000\255\255\000\000\
    \255\255\000\000\255\255\000\000\255\255\000\000\255\255\000\000\
    \255\255\000\000\255\255\000\000\255\255\000\000\255\255\000\000\
    \255\255\000\000\255\255\255\255\255\255\255\255\000\000\255\255\
    \255\255\255\255\255\255\000\000\255\255\255\255\255\255\255\255\
    \000\000\255\255\255\255\255\255\255\255\255\255\255\255\000\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\255\255\255\255\255\255\000\000\255\255\255\255\
    \255\255\000\000\154\000\255\255\156\000\000\000\255\255\000\000\
    \160\000\000\000\255\255";
  Lexing.lex_trans =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\001\000\255\255\255\255\005\000\007\000\255\255\
    \255\255\007\000\029\000\029\000\029\000\029\000\029\000\029\000\
    \029\000\042\000\029\000\040\000\040\000\042\000\000\000\048\000\
    \000\000\001\000\000\000\002\000\005\000\007\000\029\000\009\000\
    \007\000\029\000\029\000\029\000\029\000\029\000\029\000\029\000\
    \042\000\029\000\040\000\040\000\042\000\147\000\048\000\048\000\
    \032\000\031\000\030\000\052\000\055\000\029\000\061\000\067\000\
    \000\000\072\000\078\000\028\000\028\000\028\000\028\000\028\000\
    \028\000\092\000\041\000\028\000\039\000\000\000\048\000\000\000\
    \047\000\000\000\052\000\055\000\000\000\061\000\067\000\028\000\
    \072\000\078\000\255\255\001\000\000\000\000\000\005\000\000\000\
    \092\000\044\000\005\000\011\000\043\000\005\000\011\000\011\000\
    \011\000\037\000\011\000\011\000\011\000\011\000\011\000\011\000\
    \011\000\011\000\011\000\011\000\011\000\011\000\011\000\011\000\
    \011\000\011\000\011\000\011\000\130\000\011\000\137\000\011\000\
    \125\000\011\000\011\000\011\000\011\000\027\000\011\000\011\000\
    \011\000\011\000\011\000\011\000\011\000\011\000\011\000\026\000\
    \011\000\011\000\011\000\011\000\011\000\025\000\011\000\012\000\
    \011\000\011\000\011\000\011\000\011\000\011\000\011\000\011\000\
    \011\000\011\000\038\000\011\000\013\000\011\000\021\000\024\000\
    \018\000\011\000\015\000\014\000\011\000\011\000\020\000\011\000\
    \017\000\011\000\016\000\011\000\019\000\011\000\023\000\022\000\
    \011\000\011\000\011\000\011\000\011\000\011\000\029\000\011\000\
    \011\000\029\000\045\000\035\000\046\000\050\000\062\000\058\000\
    \059\000\063\000\064\000\029\000\029\000\029\000\029\000\065\000\
    \069\000\070\000\029\000\036\000\074\000\029\000\029\000\029\000\
    \029\000\052\000\055\000\075\000\076\000\116\000\117\000\121\000\
    \122\000\126\000\029\000\029\000\029\000\029\000\127\000\131\000\
    \132\000\029\000\133\000\134\000\138\000\029\000\029\000\028\000\
    \052\000\055\000\028\000\087\000\086\000\085\000\084\000\083\000\
    \082\000\081\000\080\000\079\000\028\000\028\000\028\000\028\000\
    \003\000\255\255\004\000\028\000\008\000\255\255\008\000\028\000\
    \028\000\061\000\051\000\054\000\067\000\072\000\078\000\114\000\
    \139\000\112\000\140\000\141\000\110\000\142\000\108\000\143\000\
    \106\000\104\000\102\000\100\000\094\000\115\000\098\000\144\000\
    \061\000\096\000\000\000\067\000\072\000\078\000\114\000\120\000\
    \112\000\068\000\056\000\110\000\073\000\108\000\049\000\106\000\
    \104\000\102\000\100\000\094\000\057\000\098\000\092\000\094\000\
    \096\000\053\000\060\000\255\255\034\000\066\000\071\000\077\000\
    \113\000\033\000\111\000\096\000\098\000\109\000\000\000\107\000\
    \000\000\105\000\103\000\101\000\099\000\092\000\094\000\097\000\
    \153\000\000\000\095\000\100\000\102\000\104\000\106\000\108\000\
    \110\000\112\000\096\000\098\000\114\000\090\000\089\000\088\000\
    \119\000\119\000\124\000\124\000\129\000\129\000\136\000\091\000\
    \093\000\136\000\100\000\102\000\104\000\106\000\108\000\110\000\
    \112\000\146\000\146\000\114\000\150\000\000\000\000\000\119\000\
    \119\000\124\000\124\000\129\000\129\000\136\000\000\000\000\000\
    \136\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \146\000\146\000\000\000\150\000\162\000\162\000\000\000\000\000\
    \000\000\118\000\000\000\123\000\000\000\128\000\000\000\135\000\
    \148\000\148\000\148\000\148\000\148\000\148\000\148\000\148\000\
    \148\000\148\000\145\000\162\000\162\000\000\000\160\000\160\000\
    \150\000\148\000\148\000\148\000\148\000\148\000\148\000\161\000\
    \161\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\255\255\000\000\000\000\150\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\148\000\148\000\148\000\148\000\148\000\148\000\148\000\
    \148\000\148\000\148\000\148\000\148\000\148\000\148\000\148\000\
    \148\000\149\000\155\000\157\000\000\000\000\000\000\000\000\000\
    \148\000\148\000\148\000\148\000\148\000\148\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\155\000\000\000\000\000\154\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\152\000\000\000\
    \148\000\148\000\148\000\148\000\148\000\148\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\000\000\000\000\000\000\000\000\
    \000\000\159\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\156\000\000\000\000\000\000\000\
    \000\000\152\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\000\000\
    \000\000\000\000\000\000\159\000\159\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\155\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\255\255\000\000\000\000\000\000\155\000\000\000\
    \000\000\154\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\152\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\153\000\000\000\000\000\000\000\000\000\000\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\000\000\000\000\000\000\000\000\000\000\000\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\153\000";
  Lexing.lex_check =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\001\000\001\000\002\000\005\000\006\000\006\000\
    \009\000\007\000\011\000\012\000\025\000\026\000\027\000\014\000\
    \029\000\035\000\015\000\038\000\040\000\042\000\255\255\046\000\
    \000\000\001\000\255\255\000\000\005\000\006\000\013\000\005\000\
    \007\000\011\000\012\000\025\000\026\000\027\000\014\000\029\000\
    \035\000\015\000\038\000\040\000\042\000\012\000\046\000\048\000\
    \025\000\026\000\027\000\052\000\055\000\013\000\061\000\067\000\
    \255\255\072\000\078\000\011\000\012\000\025\000\026\000\027\000\
    \014\000\092\000\035\000\015\000\038\000\255\255\048\000\255\255\
    \046\000\255\255\052\000\055\000\255\255\061\000\067\000\013\000\
    \072\000\078\000\154\000\000\000\255\255\255\255\001\000\255\255\
    \092\000\043\000\006\000\010\000\033\000\007\000\010\000\010\000\
    \010\000\036\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\014\000\010\000\013\000\010\000\
    \015\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\037\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\016\000\010\000\
    \010\000\017\000\044\000\034\000\045\000\049\000\056\000\057\000\
    \058\000\062\000\063\000\018\000\019\000\020\000\021\000\064\000\
    \068\000\069\000\022\000\034\000\073\000\016\000\023\000\024\000\
    \017\000\050\000\053\000\074\000\075\000\115\000\116\000\120\000\
    \121\000\125\000\018\000\019\000\020\000\021\000\126\000\130\000\
    \131\000\022\000\132\000\133\000\137\000\023\000\024\000\016\000\
    \050\000\053\000\017\000\018\000\018\000\018\000\018\000\018\000\
    \018\000\018\000\018\000\018\000\018\000\019\000\020\000\021\000\
    \000\000\001\000\002\000\022\000\005\000\006\000\009\000\023\000\
    \024\000\059\000\050\000\053\000\065\000\070\000\076\000\079\000\
    \138\000\080\000\139\000\140\000\081\000\141\000\082\000\142\000\
    \083\000\084\000\085\000\086\000\094\000\017\000\088\000\143\000\
    \059\000\089\000\255\255\065\000\070\000\076\000\079\000\016\000\
    \080\000\020\000\021\000\081\000\019\000\082\000\023\000\083\000\
    \084\000\085\000\086\000\094\000\021\000\088\000\087\000\090\000\
    \089\000\022\000\059\000\160\000\024\000\065\000\070\000\076\000\
    \079\000\024\000\080\000\096\000\098\000\081\000\255\255\082\000\
    \255\255\083\000\084\000\085\000\086\000\087\000\090\000\088\000\
    \154\000\255\255\089\000\100\000\102\000\104\000\106\000\108\000\
    \110\000\112\000\096\000\098\000\114\000\087\000\087\000\087\000\
    \117\000\119\000\122\000\124\000\127\000\129\000\134\000\087\000\
    \090\000\136\000\100\000\102\000\104\000\106\000\108\000\110\000\
    \112\000\144\000\146\000\114\000\150\000\255\255\255\255\117\000\
    \119\000\122\000\124\000\127\000\129\000\134\000\255\255\255\255\
    \136\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \144\000\146\000\255\255\150\000\158\000\162\000\255\255\255\255\
    \255\255\117\000\255\255\122\000\255\255\127\000\255\255\134\000\
    \147\000\147\000\147\000\147\000\147\000\147\000\147\000\147\000\
    \147\000\147\000\144\000\158\000\162\000\255\255\158\000\162\000\
    \148\000\147\000\147\000\147\000\147\000\147\000\147\000\158\000\
    \162\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\156\000\255\255\255\255\148\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\147\000\147\000\147\000\147\000\147\000\147\000\148\000\
    \148\000\148\000\148\000\148\000\148\000\148\000\148\000\148\000\
    \148\000\148\000\151\000\156\000\255\255\255\255\255\255\255\255\
    \148\000\148\000\148\000\148\000\148\000\148\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\151\000\255\255\255\255\151\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\151\000\255\255\
    \148\000\148\000\148\000\148\000\148\000\148\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\151\000\151\000\151\000\151\000\151\000\151\000\
    \151\000\151\000\151\000\151\000\151\000\151\000\151\000\151\000\
    \151\000\151\000\151\000\151\000\151\000\151\000\151\000\151\000\
    \151\000\151\000\151\000\151\000\255\255\255\255\255\255\255\255\
    \255\255\160\000\151\000\151\000\151\000\151\000\151\000\151\000\
    \151\000\151\000\151\000\151\000\151\000\151\000\151\000\151\000\
    \151\000\151\000\151\000\151\000\151\000\151\000\151\000\151\000\
    \151\000\151\000\151\000\151\000\152\000\255\255\255\255\255\255\
    \255\255\152\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\255\255\
    \255\255\255\255\255\255\158\000\162\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
    \152\000\152\000\152\000\152\000\152\000\152\000\152\000\155\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\156\000\255\255\255\255\255\255\155\000\255\255\
    \255\255\155\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\155\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\151\000\255\255\255\255\255\255\255\255\255\255\155\000\
    \155\000\155\000\155\000\155\000\155\000\155\000\155\000\155\000\
    \155\000\155\000\155\000\155\000\155\000\155\000\155\000\155\000\
    \155\000\155\000\155\000\155\000\155\000\155\000\155\000\155\000\
    \155\000\255\255\255\255\255\255\255\255\255\255\255\255\155\000\
    \155\000\155\000\155\000\155\000\155\000\155\000\155\000\155\000\
    \155\000\155\000\155\000\155\000\155\000\155\000\155\000\155\000\
    \155\000\155\000\155\000\155\000\155\000\155\000\155\000\155\000\
    \155\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\155\000";
  Lexing.lex_base_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\
    \014\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\055\000\022\000\000\000\004\000\
    \000\000\000\000\000\000\005\000\000\000\022\000\000\000\000\000\
    \000\000\000\000\000\000";
  Lexing.lex_backtrk_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\022\000\000\000\
    \022\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000";
  Lexing.lex_default_code =
   "\000\000\006\000\000\000\000\000\000\000\000\000\006\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000";
  Lexing.lex_trans_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\009\000\000\000\000\000\000\000\019\000\019\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \009\000\000\000\000\000\000\000\019\000\019\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \019\000\019\000\019\000\019\000\019\000\019\000\019\000\019\000\
    \019\000\019\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\019\000\019\000\019\000\019\000\019\000\019\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\
    \000\000\019\000\019\000\019\000\019\000\019\000\019\000\019\000\
    \019\000\019\000\019\000\019\000\019\000\019\000\019\000\019\000\
    \019\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \019\000\019\000\019\000\019\000\019\000\019\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \019\000\019\000\019\000\019\000\019\000\019\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    ";
  Lexing.lex_check_code =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\001\000\001\000\006\000\006\000\151\000\155\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \001\000\255\255\006\000\255\255\151\000\155\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \147\000\147\000\147\000\147\000\147\000\147\000\147\000\147\000\
    \147\000\147\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\147\000\147\000\147\000\147\000\147\000\147\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\000\000\255\255\001\000\255\255\006\000\
    \255\255\147\000\147\000\147\000\147\000\147\000\147\000\148\000\
    \148\000\148\000\148\000\148\000\148\000\148\000\148\000\148\000\
    \148\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \148\000\148\000\148\000\148\000\148\000\148\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \148\000\148\000\148\000\148\000\148\000\148\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \001\000\255\255\006\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    ";
  Lexing.lex_code =
   "\255\003\255\002\255\255\003\255\255\002\255\003\255\255\000\002\
    \001\003\255\001\255\255\000\001\255";
}

let rec line lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 4 (-1); __ocaml_lex_line_rec lexbuf 0
and __ocaml_lex_line_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 62 "src/lTerm_inputrc.mll"
      ( Comment )
# 510 "src/lTerm_inputrc.ml"

  | 1 ->
# 64 "src/lTerm_inputrc.mll"
      ( Comment )
# 515 "src/lTerm_inputrc.ml"

  | 2 ->
let
# 65 "src/lTerm_inputrc.mll"
                                                section
# 521 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1) in
# 66 "src/lTerm_inputrc.mll"
      ( Section section )
# 525 "src/lTerm_inputrc.ml"

  | 3 ->
# 68 "src/lTerm_inputrc.mll"
      ( sequence dummy_key [] lexbuf )
# 530 "src/lTerm_inputrc.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_line_rec lexbuf __ocaml_lex_state

and sequence key seq lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 2 (-1); __ocaml_lex_sequence_rec key seq lexbuf 10
and __ocaml_lex_sequence_rec key seq lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 72 "src/lTerm_inputrc.mll"
      ( sequence { key with control = true } seq lexbuf )
# 542 "src/lTerm_inputrc.ml"

  | 1 ->
# 74 "src/lTerm_inputrc.mll"
      ( sequence { key with meta = true } seq lexbuf )
# 547 "src/lTerm_inputrc.ml"

  | 2 ->
# 76 "src/lTerm_inputrc.mll"
      ( sequence { key with shift = true } seq lexbuf )
# 552 "src/lTerm_inputrc.ml"

  | 3 ->
let
# 77 "src/lTerm_inputrc.mll"
                             sep
# 558 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 5) lexbuf.Lexing.lex_curr_pos in
# 78 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = Enter } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 568 "src/lTerm_inputrc.ml"

  | 4 ->
let
# 85 "src/lTerm_inputrc.mll"
                              sep
# 574 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 6) lexbuf.Lexing.lex_curr_pos in
# 86 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = Escape } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 584 "src/lTerm_inputrc.ml"

  | 5 ->
let
# 93 "src/lTerm_inputrc.mll"
                           sep
# 590 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 3) lexbuf.Lexing.lex_curr_pos in
# 94 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = Tab } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 600 "src/lTerm_inputrc.ml"

  | 6 ->
let
# 101 "src/lTerm_inputrc.mll"
                          sep
# 606 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) lexbuf.Lexing.lex_curr_pos in
# 102 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = Up } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 616 "src/lTerm_inputrc.ml"

  | 7 ->
let
# 109 "src/lTerm_inputrc.mll"
                            sep
# 622 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 4) lexbuf.Lexing.lex_curr_pos in
# 110 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = Down } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 632 "src/lTerm_inputrc.ml"

  | 8 ->
let
# 117 "src/lTerm_inputrc.mll"
                            sep
# 638 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 4) lexbuf.Lexing.lex_curr_pos in
# 118 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = Left } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 648 "src/lTerm_inputrc.ml"

  | 9 ->
let
# 125 "src/lTerm_inputrc.mll"
                             sep
# 654 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 5) lexbuf.Lexing.lex_curr_pos in
# 126 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = Right } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 664 "src/lTerm_inputrc.ml"

  | 10 ->
let
# 133 "src/lTerm_inputrc.mll"
                          sep
# 670 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) lexbuf.Lexing.lex_curr_pos in
# 134 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = F1 } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 680 "src/lTerm_inputrc.ml"

  | 11 ->
let
# 141 "src/lTerm_inputrc.mll"
                          sep
# 686 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) lexbuf.Lexing.lex_curr_pos in
# 142 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = F2 } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 696 "src/lTerm_inputrc.ml"

  | 12 ->
let
# 149 "src/lTerm_inputrc.mll"
                          sep
# 702 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) lexbuf.Lexing.lex_curr_pos in
# 150 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = F3 } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 712 "src/lTerm_inputrc.ml"

  | 13 ->
let
# 157 "src/lTerm_inputrc.mll"
                          sep
# 718 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) lexbuf.Lexing.lex_curr_pos in
# 158 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = F4 } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 728 "src/lTerm_inputrc.ml"

  | 14 ->
let
# 165 "src/lTerm_inputrc.mll"
                          sep
# 734 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) lexbuf.Lexing.lex_curr_pos in
# 166 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = F5 } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 744 "src/lTerm_inputrc.ml"

  | 15 ->
let
# 173 "src/lTerm_inputrc.mll"
                          sep
# 750 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) lexbuf.Lexing.lex_curr_pos in
# 174 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = F6 } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 760 "src/lTerm_inputrc.ml"

  | 16 ->
let
# 181 "src/lTerm_inputrc.mll"
                          sep
# 766 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) lexbuf.Lexing.lex_curr_pos in
# 182 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = F7 } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 776 "src/lTerm_inputrc.ml"

  | 17 ->
let
# 189 "src/lTerm_inputrc.mll"
                          sep
# 782 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) lexbuf.Lexing.lex_curr_pos in
# 190 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = F8 } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 792 "src/lTerm_inputrc.ml"

  | 18 ->
let
# 197 "src/lTerm_inputrc.mll"
                          sep
# 798 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) lexbuf.Lexing.lex_curr_pos in
# 198 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = F9 } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 808 "src/lTerm_inputrc.ml"

  | 19 ->
let
# 205 "src/lTerm_inputrc.mll"
                           sep
# 814 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 3) lexbuf.Lexing.lex_curr_pos in
# 206 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = F10 } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 824 "src/lTerm_inputrc.ml"

  | 20 ->
let
# 213 "src/lTerm_inputrc.mll"
                           sep
# 830 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 3) lexbuf.Lexing.lex_curr_pos in
# 214 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = F11 } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 840 "src/lTerm_inputrc.ml"

  | 21 ->
let
# 221 "src/lTerm_inputrc.mll"
                           sep
# 846 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 3) lexbuf.Lexing.lex_curr_pos in
# 222 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = F12 } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 856 "src/lTerm_inputrc.ml"

  | 22 ->
let
# 229 "src/lTerm_inputrc.mll"
                            sep
# 862 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 4) lexbuf.Lexing.lex_curr_pos in
# 230 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = Next_page } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 872 "src/lTerm_inputrc.ml"

  | 23 ->
let
# 237 "src/lTerm_inputrc.mll"
                            sep
# 878 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 4) lexbuf.Lexing.lex_curr_pos in
# 238 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = Prev_page } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 888 "src/lTerm_inputrc.ml"

  | 24 ->
let
# 245 "src/lTerm_inputrc.mll"
                            sep
# 894 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 4) lexbuf.Lexing.lex_curr_pos in
# 246 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = Home } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 904 "src/lTerm_inputrc.ml"

  | 25 ->
let
# 253 "src/lTerm_inputrc.mll"
                           sep
# 910 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 3) lexbuf.Lexing.lex_curr_pos in
# 254 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = End } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 920 "src/lTerm_inputrc.ml"

  | 26 ->
let
# 261 "src/lTerm_inputrc.mll"
                              sep
# 926 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 6) lexbuf.Lexing.lex_curr_pos in
# 262 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = Insert } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 936 "src/lTerm_inputrc.ml"

  | 27 ->
let
# 269 "src/lTerm_inputrc.mll"
                              sep
# 942 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 6) lexbuf.Lexing.lex_curr_pos in
# 270 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = Delete } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 952 "src/lTerm_inputrc.ml"

  | 28 ->
let
# 277 "src/lTerm_inputrc.mll"
                                 sep
# 958 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 9) lexbuf.Lexing.lex_curr_pos in
# 278 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = Backspace } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 968 "src/lTerm_inputrc.ml"

  | 29 ->
let
# 285 "src/lTerm_inputrc.mll"
                                                                                                                                    ch
# 974 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos
and
# 285 "src/lTerm_inputrc.mll"
                                                                                                                                                        sep
# 979 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 1) lexbuf.Lexing.lex_curr_pos in
# 286 "src/lTerm_inputrc.mll"
      (
        let seq = { key with code = Char(Uchar.of_char ch) } :: seq in
        if sep = ":" then
          actions (List.rev seq) [] lexbuf
        else
          sequence dummy_key seq lexbuf
      )
# 989 "src/lTerm_inputrc.ml"

  | 30 ->
let
# 293 "src/lTerm_inputrc.mll"
                                        hexa
# 995 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) lexbuf.Lexing.lex_mem.(0)
and
# 293 "src/lTerm_inputrc.mll"
                                                               sep
# 1000 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 294 "src/lTerm_inputrc.mll"
      (
        let code = ref 0 in
        for i = 0 to String.length hexa - 1 do
          let ch = hexa.[i] in
          code := !code * 16 +
            (match ch with
               | '0' .. '9' -> Char.code ch - Char.code '0'
               | 'A' .. 'F' -> Char.code ch - Char.code 'A' + 10
               | 'a' .. 'f' -> Char.code ch - Char.code 'a' + 10
               | _ -> assert false)
        done;
        match try Some (Uchar.of_int !code) with _ -> None with
          | Some ch ->
              let seq = { key with code = Char ch } :: seq in
              if sep = ":" then
                actions (List.rev seq) [] lexbuf
              else
                sequence dummy_key seq lexbuf
          | None ->
              Error (Printf.sprintf "invalid unicode character U+%s" hexa)
      )
# 1024 "src/lTerm_inputrc.ml"

  | 31 ->
# 316 "src/lTerm_inputrc.mll"
      ( Error "parsing error in key sequence" )
# 1029 "src/lTerm_inputrc.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_sequence_rec key seq lexbuf __ocaml_lex_state

and actions seq l lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 2 (-1);(* L=1 [1] <- p ;  *)
  lexbuf.Lexing.lex_mem.(1) <- lexbuf.Lexing.lex_curr_pos ;
 __ocaml_lex_actions_rec seq l lexbuf 151
and __ocaml_lex_actions_rec seq l lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 320 "src/lTerm_inputrc.mll"
      ( Binding (seq, List.rev l) )
# 1043 "src/lTerm_inputrc.ml"

  | 1 ->
let
# 321 "src/lTerm_inputrc.mll"
                                                              action
# 1049 "src/lTerm_inputrc.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 322 "src/lTerm_inputrc.mll"
      ( comma_actions seq (action :: l) lexbuf )
# 1053 "src/lTerm_inputrc.ml"

  | 2 ->
# 324 "src/lTerm_inputrc.mll"
      ( Error "parsing error in actions" )
# 1058 "src/lTerm_inputrc.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_actions_rec seq l lexbuf __ocaml_lex_state

and comma_actions seq l lexbuf =
   __ocaml_lex_comma_actions_rec seq l lexbuf 158
and __ocaml_lex_comma_actions_rec seq l lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 328 "src/lTerm_inputrc.mll"
      ( actions seq l lexbuf )
# 1070 "src/lTerm_inputrc.ml"

  | 1 ->
# 330 "src/lTerm_inputrc.mll"
      ( Binding (seq, List.rev l) )
# 1075 "src/lTerm_inputrc.ml"

  | 2 ->
# 332 "src/lTerm_inputrc.mll"
      ( Error "parsing error in actions" )
# 1080 "src/lTerm_inputrc.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_comma_actions_rec seq l lexbuf __ocaml_lex_state

;;

# 334 "src/lTerm_inputrc.mll"
 
  let default =
    let new_file =
      LTerm_resources.xdgbd_file
        ~loc:LTerm_resources.Config
        ~legacy_name:".lambda-term-inputrc"
        "lambda-term-inputrc"
    in
    if Sys.file_exists new_file then
      new_file
    else
      (* compatiblity with 3.x *)
      LTerm_resources.xdgbd_file ~loc:LTerm_resources.Config ".lambda-term-inputrc"

  let load ?(file = default) () =
    Lwt.catch (fun () ->
      Lwt_io.open_file ~mode:Lwt_io.input file >>= fun ic ->
      let rec loop num handler =
        Lwt_io.read_line_opt ic >>= fun input_line ->
        match input_line with
          | None ->
              return ()
          | Some str ->
              match line (Lexing.from_string str) with
                | Comment ->
                    loop (num + 1) handler
                | Section "edit" ->
                    loop (num + 1) handle_edit_action
                | Section "read-line" ->
                    loop (num + 1) handle_read_line_action
                | Section section ->
                    parse_error file num "invalid section %S" section
                | Binding (seq, actions) ->
                    handler file num seq actions;
                    loop (num + 1) handler
                | Error msg ->
                    raise (Parse_error (file, num, msg))
      in
      Lwt.finalize
        (fun () -> loop 1 handle_edit_action)
        (fun () -> Lwt_io.close ic))
      (function
      | Unix.Unix_error(Unix.ENOENT, _, _) ->
          return ()
      | exn -> Lwt.fail exn)

# 1134 "src/lTerm_inputrc.ml"
