function GetOciTopLevelCommand_network() {
    return 'network'
}

function GetOciSubcommands_network() {
    $ociSubcommands = @{
        'network' = 'byoip-allocated-range-summary byoip-range cpe cpe-device-shape cpe-device-shape-detail cross-connect cross-connect-group cross-connect-location cross-connect-mapping-details-collection cross-connect-port-speed-shape cross-connect-status dhcp-options drg drg-attachment drg-redundancy-status drg-route-distribution drg-route-distribution-statement drg-route-rule drg-route-table fast-connect-provider-service fast-connect-provider-service-key internet-gateway ip-sec-connection ip-sec-psk ip-sec-tunnel ipv6 local-peering-gateway nat-gateway networking-topology nsg private-ip public-ip public-ip-pool remote-peering-connection route-table security-list service service-gateway subnet tunnel-cpe-device-config vcn vcn-dns-resolver-association vcn-topology virtual-circuit virtual-circuit-public-prefix vlan vnic'
        'network byoip-allocated-range-summary' = 'list-byoip-allocated-ranges'
        'network byoip-range' = 'advertise change-compartment create delete get list update validate withdraw'
        'network cpe' = 'change-compartment create delete get get-cpe-device-config-content list update'
        'network cpe-device-shape' = 'list'
        'network cpe-device-shape-detail' = 'get-cpe-device-shape'
        'network cross-connect' = 'change-compartment create delete get list update'
        'network cross-connect-group' = 'change-compartment create delete get list update'
        'network cross-connect-location' = 'list'
        'network cross-connect-mapping-details-collection' = 'list-cross-connect-mappings'
        'network cross-connect-port-speed-shape' = 'list'
        'network cross-connect-status' = 'get'
        'network dhcp-options' = 'change-compartment create delete get list update'
        'network drg' = 'change-compartment create delete get get-all-drg-attachments get-upgrade-status list update upgrade'
        'network drg-attachment' = 'create delete get list remove-export-route-distribution update'
        'network drg-redundancy-status' = 'get'
        'network drg-route-distribution' = 'create delete get list update'
        'network drg-route-distribution-statement' = 'add list remove update'
        'network drg-route-rule' = 'add list remove update'
        'network drg-route-table' = 'create delete get list remove-import-route-distribution update'
        'network fast-connect-provider-service' = 'get list virtual-circuit-bandwidth-shape'
        'network fast-connect-provider-service virtual-circuit-bandwidth-shape' = 'list'
        'network fast-connect-provider-service-key' = 'get'
        'network internet-gateway' = 'change-compartment create delete get list update'
        'network ip-sec-connection' = 'change-compartment create delete get get-config get-ipsec-cpe-device-config-content get-status list update'
        'network ip-sec-psk' = 'get update'
        'network ip-sec-tunnel' = 'get list update'
        'network ipv6' = 'create delete get list update'
        'network local-peering-gateway' = 'change-compartment connect create delete get list update'
        'network nat-gateway' = 'change-compartment create delete get list update'
        'network networking-topology' = 'get'
        'network nsg' = 'change-compartment create delete get list rules update vnics'
        'network nsg rules' = 'add list remove update'
        'network nsg vnics' = 'list'
        'network private-ip' = 'delete get list update'
        'network public-ip' = 'change-compartment create delete get list update'
        'network public-ip-pool' = 'add change-compartment create delete get list remove update'
        'network remote-peering-connection' = 'change-compartment connect create delete get list update'
        'network route-table' = 'change-compartment create delete get list update'
        'network security-list' = 'change-compartment create delete get list update'
        'network service' = 'get list'
        'network service-gateway' = 'attach change-compartment create delete detach get list update'
        'network subnet' = 'change-compartment create delete get list update'
        'network tunnel-cpe-device-config' = 'get get-tunnel-cpe-device-config-content update'
        'network vcn' = 'add-ipv6-vcn-cidr add-vcn-cidr change-compartment create delete get list modify-vcn-cidr remove-vcn-cidr update'
        'network vcn-dns-resolver-association' = 'get'
        'network vcn-topology' = 'get'
        'network virtual-circuit' = 'change-compartment create delete get list update'
        'network virtual-circuit-public-prefix' = 'bulk-add bulk-delete list'
        'network vlan' = 'change-compartment create delete get list update'
        'network vnic' = 'assign-ipv6 assign-private-ip get unassign-ipv6 unassign-private-ip update'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_network() {
    $ociCommandsToLongParams = @{
        'network byoip-allocated-range-summary list-byoip-allocated-ranges' = 'all byoip-range-id from-json help limit page page-size'
        'network byoip-range advertise' = 'byoip-range-id from-json help'
        'network byoip-range change-compartment' = 'byoip-range-id compartment-id from-json help'
        'network byoip-range create' = 'cidr-block compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'network byoip-range delete' = 'byoip-range-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'network byoip-range get' = 'byoip-range-id from-json help'
        'network byoip-range list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'network byoip-range update' = 'byoip-range-id defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'network byoip-range validate' = 'byoip-range-id from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'network byoip-range withdraw' = 'byoip-range-id from-json help'
        'network cpe change-compartment' = 'compartment-id cpe-id from-json help'
        'network cpe create' = 'compartment-id cpe-device-shape-id defined-tags display-name freeform-tags from-json help ip-address'
        'network cpe delete' = 'cpe-id force from-json help if-match'
        'network cpe get' = 'cpe-id from-json help'
        'network cpe get-cpe-device-config-content' = 'cpe-id file from-json help'
        'network cpe list' = 'all compartment-id from-json help limit page page-size'
        'network cpe update' = 'cpe-device-shape-id cpe-id defined-tags display-name force freeform-tags from-json help if-match'
        'network cpe-device-shape list' = 'all from-json help limit page page-size'
        'network cpe-device-shape-detail get-cpe-device-shape' = 'cpe-device-shape-id from-json help'
        'network cross-connect change-compartment' = 'compartment-id cross-connect-id from-json help'
        'network cross-connect create' = 'compartment-id cross-connect-group-id customer-reference-name defined-tags display-name far-cross-connect-or-cross-connect-group-id freeform-tags from-json help location-name max-wait-seconds near-cross-connect-or-cross-connect-group-id port-speed-shape-name wait-for-state wait-interval-seconds'
        'network cross-connect delete' = 'cross-connect-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'network cross-connect get' = 'cross-connect-id from-json help'
        'network cross-connect list' = 'all compartment-id cross-connect-group-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'network cross-connect update' = 'cross-connect-id customer-reference-name defined-tags display-name force freeform-tags from-json help if-match is-active max-wait-seconds wait-for-state wait-interval-seconds'
        'network cross-connect-group change-compartment' = 'compartment-id cross-connect-group-id from-json help'
        'network cross-connect-group create' = 'compartment-id customer-reference-name defined-tags display-name freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'network cross-connect-group delete' = 'cross-connect-group-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'network cross-connect-group get' = 'cross-connect-group-id from-json help'
        'network cross-connect-group list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'network cross-connect-group update' = 'cross-connect-group-id customer-reference-name defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'network cross-connect-location list' = 'all compartment-id from-json help limit page page-size'
        'network cross-connect-mapping-details-collection list-cross-connect-mappings' = 'all from-json help virtual-circuit-id'
        'network cross-connect-port-speed-shape list' = 'all compartment-id from-json help limit page page-size'
        'network cross-connect-status get' = 'cross-connect-id from-json help'
        'network dhcp-options change-compartment' = 'compartment-id dhcp-id from-json help'
        'network dhcp-options create' = 'compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds options vcn-id wait-for-state wait-interval-seconds'
        'network dhcp-options delete' = 'dhcp-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'network dhcp-options get' = 'dhcp-id from-json help'
        'network dhcp-options list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order vcn-id'
        'network dhcp-options update' = 'defined-tags dhcp-id display-name force freeform-tags from-json help if-match max-wait-seconds options wait-for-state wait-interval-seconds'
        'network drg change-compartment' = 'compartment-id drg-id from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'network drg create' = 'compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'network drg delete' = 'drg-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'network drg get' = 'drg-id from-json help'
        'network drg get-all-drg-attachments' = 'attachment-type drg-id from-json help is-cross-tenancy limit page'
        'network drg get-upgrade-status' = 'drg-id from-json help'
        'network drg list' = 'all compartment-id from-json help limit page page-size'
        'network drg update' = 'default-drg-route-tables defined-tags display-name drg-id force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'network drg upgrade' = 'drg-id from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'network drg-attachment create' = 'defined-tags display-name drg-id drg-route-table-id freeform-tags from-json help max-wait-seconds network-details route-table-id vcn-id wait-for-state wait-interval-seconds'
        'network drg-attachment delete' = 'drg-attachment-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'network drg-attachment get' = 'drg-attachment-id from-json help'
        'network drg-attachment list' = 'all attachment-type compartment-id display-name drg-id drg-route-table-id from-json help lifecycle-state limit network-id page page-size sort-by sort-order vcn-id'
        'network drg-attachment remove-export-route-distribution' = 'drg-attachment-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'network drg-attachment update' = 'defined-tags display-name drg-attachment-id drg-route-table-id export-drg-route-distribution-id force freeform-tags from-json help if-match max-wait-seconds network-details route-table-id wait-for-state wait-interval-seconds'
        'network drg-redundancy-status get' = 'drg-id from-json help'
        'network drg-route-distribution create' = 'defined-tags display-name distribution-type drg-id freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'network drg-route-distribution delete' = 'force from-json help if-match max-wait-seconds route-distribution-id wait-for-state wait-interval-seconds'
        'network drg-route-distribution get' = 'from-json help route-distribution-id'
        'network drg-route-distribution list' = 'all display-name drg-id from-json help lifecycle-state limit page page-size sort-by sort-order'
        'network drg-route-distribution update' = 'defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds route-distribution-id wait-for-state wait-interval-seconds'
        'network drg-route-distribution-statement add' = 'from-json help route-distribution-id statements'
        'network drg-route-distribution-statement list' = 'all from-json help limit page page-size route-distribution-id sort-by sort-order'
        'network drg-route-distribution-statement remove' = 'from-json help route-distribution-id statement-ids'
        'network drg-route-distribution-statement update' = 'from-json help route-distribution-id statements'
        'network drg-route-rule add' = 'drg-route-table-id from-json help route-rules'
        'network drg-route-rule list' = 'all drg-route-table-id from-json help limit page page-size route-type'
        'network drg-route-rule remove' = 'drg-route-table-id from-json help route-rule-ids'
        'network drg-route-rule update' = 'drg-route-table-id from-json help route-rules'
        'network drg-route-table create' = 'defined-tags display-name drg-id freeform-tags from-json help import-route-distribution-id is-ecmp-enabled max-wait-seconds wait-for-state wait-interval-seconds'
        'network drg-route-table delete' = 'drg-route-table-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'network drg-route-table get' = 'drg-route-table-id from-json help'
        'network drg-route-table list' = 'all display-name drg-id from-json help import-route-distribution-id lifecycle-state limit page page-size sort-by sort-order'
        'network drg-route-table remove-import-route-distribution' = 'drg-route-table-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'network drg-route-table update' = 'defined-tags display-name drg-route-table-id force freeform-tags from-json help if-match import-route-distribution-id is-ecmp-enabled max-wait-seconds wait-for-state wait-interval-seconds'
        'network fast-connect-provider-service get' = 'from-json help provider-service-id'
        'network fast-connect-provider-service list' = 'all compartment-id from-json help limit page page-size'
        'network fast-connect-provider-service virtual-circuit-bandwidth-shape list' = 'all from-json help limit page page-size provider-service-id'
        'network fast-connect-provider-service-key get' = 'from-json help provider-service-id provider-service-key-name'
        'network internet-gateway change-compartment' = 'compartment-id from-json help ig-id'
        'network internet-gateway create' = 'compartment-id defined-tags display-name freeform-tags from-json help is-enabled max-wait-seconds vcn-id wait-for-state wait-interval-seconds'
        'network internet-gateway delete' = 'force from-json help if-match ig-id max-wait-seconds wait-for-state wait-interval-seconds'
        'network internet-gateway get' = 'from-json help ig-id'
        'network internet-gateway list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order vcn-id'
        'network internet-gateway update' = 'defined-tags display-name force freeform-tags from-json help if-match ig-id is-enabled max-wait-seconds wait-for-state wait-interval-seconds'
        'network ip-sec-connection change-compartment' = 'compartment-id from-json help ipsc-id'
        'network ip-sec-connection create' = 'compartment-id cpe-id cpe-local-identifier cpe-local-identifier-type defined-tags display-name drg-id freeform-tags from-json help max-wait-seconds static-routes tunnel-configuration wait-for-state wait-interval-seconds'
        'network ip-sec-connection delete' = 'force from-json help if-match ipsc-id max-wait-seconds wait-for-state wait-interval-seconds'
        'network ip-sec-connection get' = 'from-json help ipsc-id'
        'network ip-sec-connection get-config' = 'from-json help ipsc-id'
        'network ip-sec-connection get-ipsec-cpe-device-config-content' = 'file from-json help ipsc-id'
        'network ip-sec-connection get-status' = 'from-json help ipsc-id'
        'network ip-sec-connection list' = 'all compartment-id cpe-id drg-id from-json help limit page page-size'
        'network ip-sec-connection update' = 'cpe-local-identifier cpe-local-identifier-type defined-tags display-name force freeform-tags from-json help if-match ipsc-id max-wait-seconds static-routes wait-for-state wait-interval-seconds'
        'network ip-sec-psk get' = 'from-json help ipsc-id tunnel-id'
        'network ip-sec-psk update' = 'from-json help if-match ipsc-id shared-secret tunnel-id'
        'network ip-sec-tunnel get' = 'from-json help ipsc-id tunnel-id'
        'network ip-sec-tunnel list' = 'all from-json help ipsc-id limit page page-size'
        'network ip-sec-tunnel update' = 'bgp-session-config display-name encryption-domain-config force from-json help if-match ike-version ipsc-id max-wait-seconds routing tunnel-id wait-for-state wait-interval-seconds'
        'network ipv6 create' = 'defined-tags display-name freeform-tags from-json help ip-address max-wait-seconds vnic-id wait-for-state wait-interval-seconds'
        'network ipv6 delete' = 'force from-json help if-match ipv6-id max-wait-seconds wait-for-state wait-interval-seconds'
        'network ipv6 get' = 'from-json help ipv6-id'
        'network ipv6 list' = 'all from-json help ip-address limit page page-size subnet-id vnic-id'
        'network ipv6 update' = 'defined-tags display-name force freeform-tags from-json help if-match ipv6-id max-wait-seconds vnic-id wait-for-state wait-interval-seconds'
        'network local-peering-gateway change-compartment' = 'compartment-id from-json help local-peering-gateway-id'
        'network local-peering-gateway connect' = 'from-json help local-peering-gateway-id peer-id'
        'network local-peering-gateway create' = 'compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds route-table-id vcn-id wait-for-state wait-interval-seconds'
        'network local-peering-gateway delete' = 'force from-json help if-match local-peering-gateway-id max-wait-seconds wait-for-state wait-interval-seconds'
        'network local-peering-gateway get' = 'from-json help local-peering-gateway-id'
        'network local-peering-gateway list' = 'all compartment-id from-json help limit page page-size vcn-id'
        'network local-peering-gateway update' = 'defined-tags display-name force freeform-tags from-json help if-match local-peering-gateway-id max-wait-seconds route-table-id wait-for-state wait-interval-seconds'
        'network nat-gateway change-compartment' = 'compartment-id from-json help nat-gateway-id'
        'network nat-gateway create' = 'block-traffic compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds public-ip-id vcn-id wait-for-state wait-interval-seconds'
        'network nat-gateway delete' = 'force from-json help if-match max-wait-seconds nat-gateway-id wait-for-state wait-interval-seconds'
        'network nat-gateway get' = 'from-json help nat-gateway-id'
        'network nat-gateway list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order vcn-id'
        'network nat-gateway update' = 'block-traffic defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds nat-gateway-id wait-for-state wait-interval-seconds'
        'network networking-topology get' = 'access-level cache-control compartment-id from-json help if-none-match query-compartment-subtree'
        'network nsg change-compartment' = 'compartment-id from-json help nsg-id'
        'network nsg create' = 'compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds vcn-id wait-for-state wait-interval-seconds'
        'network nsg delete' = 'force from-json help if-match max-wait-seconds nsg-id wait-for-state wait-interval-seconds'
        'network nsg get' = 'from-json help nsg-id'
        'network nsg list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order vcn-id'
        'network nsg rules add' = 'from-json help nsg-id security-rules'
        'network nsg rules list' = 'all direction from-json help limit nsg-id page page-size sort-by sort-order'
        'network nsg rules remove' = 'from-json help nsg-id security-rule-ids'
        'network nsg rules update' = 'from-json help nsg-id security-rules'
        'network nsg update' = 'defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds nsg-id wait-for-state wait-interval-seconds'
        'network nsg vnics list' = 'all from-json help limit nsg-id page page-size sort-by sort-order'
        'network private-ip delete' = 'force from-json help if-match private-ip-id'
        'network private-ip get' = 'from-json help private-ip-id'
        'network private-ip list' = 'all from-json help ip-address limit page page-size subnet-id vlan-id vnic-id'
        'network private-ip update' = 'defined-tags display-name force freeform-tags from-json help hostname-label if-match private-ip-id'
        'network public-ip change-compartment' = 'compartment-id from-json help public-ip-id'
        'network public-ip create' = 'compartment-id defined-tags display-name freeform-tags from-json help lifetime max-wait-seconds private-ip-id public-ip-pool-id wait-for-state wait-interval-seconds'
        'network public-ip delete' = 'force from-json help if-match max-wait-seconds public-ip-id wait-for-state wait-interval-seconds'
        'network public-ip get' = 'from-json help private-ip-id public-ip-address public-ip-id'
        'network public-ip list' = 'all availability-domain compartment-id from-json help lifetime limit page page-size public-ip-pool-id scope'
        'network public-ip update' = 'defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds private-ip-id public-ip-id wait-for-state wait-interval-seconds'
        'network public-ip-pool add' = 'byoip-range-id cidr-block from-json help max-wait-seconds public-ip-pool-id wait-for-state wait-interval-seconds'
        'network public-ip-pool change-compartment' = 'compartment-id from-json help public-ip-pool-id'
        'network public-ip-pool create' = 'compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'network public-ip-pool delete' = 'force from-json help if-match max-wait-seconds public-ip-pool-id wait-for-state wait-interval-seconds'
        'network public-ip-pool get' = 'from-json help public-ip-pool-id'
        'network public-ip-pool list' = 'all byoip-range-id compartment-id display-name from-json help limit page page-size sort-by sort-order'
        'network public-ip-pool remove' = 'cidr-block from-json help max-wait-seconds public-ip-pool-id wait-for-state wait-interval-seconds'
        'network public-ip-pool update' = 'defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds public-ip-pool-id wait-for-state wait-interval-seconds'
        'network remote-peering-connection change-compartment' = 'compartment-id from-json help remote-peering-connection-id'
        'network remote-peering-connection connect' = 'from-json help peer-id peer-region-name remote-peering-connection-id'
        'network remote-peering-connection create' = 'compartment-id defined-tags display-name drg-id freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'network remote-peering-connection delete' = 'force from-json help if-match max-wait-seconds remote-peering-connection-id wait-for-state wait-interval-seconds'
        'network remote-peering-connection get' = 'from-json help remote-peering-connection-id'
        'network remote-peering-connection list' = 'all compartment-id drg-id from-json help limit page page-size'
        'network remote-peering-connection update' = 'defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds remote-peering-connection-id wait-for-state wait-interval-seconds'
        'network route-table change-compartment' = 'compartment-id from-json help rt-id'
        'network route-table create' = 'compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds route-rules vcn-id wait-for-state wait-interval-seconds'
        'network route-table delete' = 'force from-json help if-match max-wait-seconds rt-id wait-for-state wait-interval-seconds'
        'network route-table get' = 'from-json help rt-id'
        'network route-table list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order vcn-id'
        'network route-table update' = 'defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds route-rules rt-id wait-for-state wait-interval-seconds'
        'network security-list change-compartment' = 'compartment-id from-json help security-list-id'
        'network security-list create' = 'compartment-id defined-tags display-name egress-security-rules freeform-tags from-json help ingress-security-rules max-wait-seconds vcn-id wait-for-state wait-interval-seconds'
        'network security-list delete' = 'force from-json help if-match max-wait-seconds security-list-id wait-for-state wait-interval-seconds'
        'network security-list get' = 'from-json help security-list-id'
        'network security-list list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order vcn-id'
        'network security-list update' = 'defined-tags display-name egress-security-rules force freeform-tags from-json help if-match ingress-security-rules max-wait-seconds security-list-id wait-for-state wait-interval-seconds'
        'network service get' = 'from-json help service-id'
        'network service list' = 'all from-json help limit page page-size'
        'network service-gateway attach' = 'from-json help if-match max-wait-seconds service-gateway-id service-id wait-for-state wait-interval-seconds'
        'network service-gateway change-compartment' = 'compartment-id from-json help service-gateway-id'
        'network service-gateway create' = 'compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds route-table-id services vcn-id wait-for-state wait-interval-seconds'
        'network service-gateway delete' = 'force from-json help if-match max-wait-seconds service-gateway-id wait-for-state wait-interval-seconds'
        'network service-gateway detach' = 'from-json help if-match max-wait-seconds service-gateway-id service-id wait-for-state wait-interval-seconds'
        'network service-gateway get' = 'from-json help service-gateway-id'
        'network service-gateway list' = 'all compartment-id from-json help lifecycle-state limit page page-size sort-by sort-order vcn-id'
        'network service-gateway update' = 'block-traffic defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds route-table-id service-gateway-id services wait-for-state wait-interval-seconds'
        'network subnet change-compartment' = 'compartment-id from-json help max-wait-seconds subnet-id wait-for-state wait-interval-seconds'
        'network subnet create' = 'availability-domain cidr-block compartment-id defined-tags dhcp-options-id display-name dns-label freeform-tags from-json help ipv6-cidr-block max-wait-seconds prohibit-internet-ingress prohibit-public-ip-on-vnic route-table-id security-list-ids vcn-id wait-for-state wait-interval-seconds'
        'network subnet delete' = 'force from-json help if-match max-wait-seconds subnet-id wait-for-state wait-interval-seconds'
        'network subnet get' = 'from-json help subnet-id'
        'network subnet list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order vcn-id'
        'network subnet update' = 'cidr-block defined-tags dhcp-options-id display-name force freeform-tags from-json help if-match ipv6-cidr-block max-wait-seconds route-table-id security-list-ids subnet-id wait-for-state wait-interval-seconds'
        'network tunnel-cpe-device-config get' = 'from-json help ipsc-id tunnel-id'
        'network tunnel-cpe-device-config get-tunnel-cpe-device-config-content' = 'file from-json help ipsc-id tunnel-id'
        'network tunnel-cpe-device-config update' = 'force from-json help if-match ipsc-id tunnel-cpe-device-config tunnel-id'
        'network vcn add-ipv6-vcn-cidr' = 'from-json help if-match max-wait-seconds vcn-id wait-for-state wait-interval-seconds'
        'network vcn add-vcn-cidr' = 'cidr-block from-json help if-match max-wait-seconds vcn-id wait-for-state wait-interval-seconds'
        'network vcn change-compartment' = 'compartment-id from-json help max-wait-seconds vcn-id wait-for-state wait-interval-seconds'
        'network vcn create' = 'cidr-block cidr-blocks compartment-id defined-tags display-name dns-label freeform-tags from-json help is-ipv6-enabled max-wait-seconds wait-for-state wait-interval-seconds'
        'network vcn delete' = 'force from-json help if-match max-wait-seconds vcn-id wait-for-state wait-interval-seconds'
        'network vcn get' = 'from-json help vcn-id'
        'network vcn list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'network vcn modify-vcn-cidr' = 'from-json help if-match max-wait-seconds new-cidr-block original-cidr-block vcn-id wait-for-state wait-interval-seconds'
        'network vcn remove-vcn-cidr' = 'cidr-block from-json help if-match max-wait-seconds vcn-id wait-for-state wait-interval-seconds'
        'network vcn update' = 'defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds vcn-id wait-for-state wait-interval-seconds'
        'network vcn-dns-resolver-association get' = 'from-json help vcn-id'
        'network vcn-topology get' = 'access-level cache-control compartment-id from-json help if-none-match query-compartment-subtree vcn-id'
        'network virtual-circuit change-compartment' = 'compartment-id from-json help virtual-circuit-id'
        'network virtual-circuit create' = 'bandwidth-shape-name compartment-id cross-connect-mappings customer-asn customer-bgp-asn defined-tags display-name freeform-tags from-json gateway-id help max-wait-seconds provider-name provider-service-id provider-service-key-name provider-service-name public-prefixes routing-policy type wait-for-state wait-interval-seconds'
        'network virtual-circuit delete' = 'force from-json help if-match max-wait-seconds virtual-circuit-id wait-for-state wait-interval-seconds'
        'network virtual-circuit get' = 'from-json help virtual-circuit-id'
        'network virtual-circuit list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'network virtual-circuit update' = 'bandwidth-shape-name cross-connect-mappings customer-asn customer-bgp-asn defined-tags display-name force freeform-tags from-json gateway-id help if-match max-wait-seconds provider-service-key-name provider-state reference-comment routing-policy virtual-circuit-id wait-for-state wait-interval-seconds'
        'network virtual-circuit-public-prefix bulk-add' = 'from-json help public-prefixes virtual-circuit-id'
        'network virtual-circuit-public-prefix bulk-delete' = 'from-json help public-prefixes virtual-circuit-id'
        'network virtual-circuit-public-prefix list' = 'all from-json help verification-state virtual-circuit-id'
        'network vlan change-compartment' = 'compartment-id from-json help if-match max-wait-seconds vlan-id wait-for-state wait-interval-seconds'
        'network vlan create' = 'availability-domain cidr-block compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds nsg-ids route-table-id vcn-id vlan-tag wait-for-state wait-interval-seconds'
        'network vlan delete' = 'force from-json help if-match max-wait-seconds vlan-id wait-for-state wait-interval-seconds'
        'network vlan get' = 'from-json help vlan-id'
        'network vlan list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order vcn-id'
        'network vlan update' = 'cidr-block defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds nsg-ids route-table-id vlan-id wait-for-state wait-interval-seconds'
        'network vnic assign-ipv6' = 'defined-tags display-name freeform-tags from-json help ip-address unassign-if-already-assigned vnic-id'
        'network vnic assign-private-ip' = 'defined-tags display-name freeform-tags from-json help hostname-label ip-address unassign-if-already-assigned vlan-id vnic-id'
        'network vnic get' = 'from-json help vnic-id'
        'network vnic unassign-ipv6' = 'from-json help ip-address vnic-id'
        'network vnic unassign-private-ip' = 'from-json help ip-address vnic-id'
        'network vnic update' = 'defined-tags display-name force freeform-tags from-json help hostname-label if-match max-wait-seconds nsg-ids skip-source-dest-check vnic-id wait-for-state wait-interval-seconds'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_network() {
    $ociCommandsToShortParams = @{
        'network byoip-allocated-range-summary list-byoip-allocated-ranges' = '? h'
        'network byoip-range advertise' = '? h'
        'network byoip-range change-compartment' = '? c h'
        'network byoip-range create' = '? c h'
        'network byoip-range delete' = '? h'
        'network byoip-range get' = '? h'
        'network byoip-range list' = '? c h'
        'network byoip-range update' = '? h'
        'network byoip-range validate' = '? h'
        'network byoip-range withdraw' = '? h'
        'network cpe change-compartment' = '? c h'
        'network cpe create' = '? c h'
        'network cpe delete' = '? h'
        'network cpe get' = '? h'
        'network cpe get-cpe-device-config-content' = '? h'
        'network cpe list' = '? c h'
        'network cpe update' = '? h'
        'network cpe-device-shape list' = '? h'
        'network cpe-device-shape-detail get-cpe-device-shape' = '? h'
        'network cross-connect change-compartment' = '? c h'
        'network cross-connect create' = '? c h'
        'network cross-connect delete' = '? h'
        'network cross-connect get' = '? h'
        'network cross-connect list' = '? c h'
        'network cross-connect update' = '? h'
        'network cross-connect-group change-compartment' = '? c h'
        'network cross-connect-group create' = '? c h'
        'network cross-connect-group delete' = '? h'
        'network cross-connect-group get' = '? h'
        'network cross-connect-group list' = '? c h'
        'network cross-connect-group update' = '? h'
        'network cross-connect-location list' = '? c h'
        'network cross-connect-mapping-details-collection list-cross-connect-mappings' = '? h'
        'network cross-connect-port-speed-shape list' = '? c h'
        'network cross-connect-status get' = '? h'
        'network dhcp-options change-compartment' = '? c h'
        'network dhcp-options create' = '? c h'
        'network dhcp-options delete' = '? h'
        'network dhcp-options get' = '? h'
        'network dhcp-options list' = '? c h'
        'network dhcp-options update' = '? h'
        'network drg change-compartment' = '? c h'
        'network drg create' = '? c h'
        'network drg delete' = '? h'
        'network drg get' = '? h'
        'network drg get-all-drg-attachments' = '? h'
        'network drg get-upgrade-status' = '? h'
        'network drg list' = '? c h'
        'network drg update' = '? h'
        'network drg upgrade' = '? h'
        'network drg-attachment create' = '? h'
        'network drg-attachment delete' = '? h'
        'network drg-attachment get' = '? h'
        'network drg-attachment list' = '? c h'
        'network drg-attachment remove-export-route-distribution' = '? h'
        'network drg-attachment update' = '? h'
        'network drg-redundancy-status get' = '? h'
        'network drg-route-distribution create' = '? h'
        'network drg-route-distribution delete' = '? h'
        'network drg-route-distribution get' = '? h'
        'network drg-route-distribution list' = '? h'
        'network drg-route-distribution update' = '? h'
        'network drg-route-distribution-statement add' = '? h'
        'network drg-route-distribution-statement list' = '? h'
        'network drg-route-distribution-statement remove' = '? h'
        'network drg-route-distribution-statement update' = '? h'
        'network drg-route-rule add' = '? h'
        'network drg-route-rule list' = '? h'
        'network drg-route-rule remove' = '? h'
        'network drg-route-rule update' = '? h'
        'network drg-route-table create' = '? h'
        'network drg-route-table delete' = '? h'
        'network drg-route-table get' = '? h'
        'network drg-route-table list' = '? h'
        'network drg-route-table remove-import-route-distribution' = '? h'
        'network drg-route-table update' = '? h'
        'network fast-connect-provider-service get' = '? h'
        'network fast-connect-provider-service list' = '? c h'
        'network fast-connect-provider-service virtual-circuit-bandwidth-shape list' = '? h'
        'network fast-connect-provider-service-key get' = '? h'
        'network internet-gateway change-compartment' = '? c h'
        'network internet-gateway create' = '? c h'
        'network internet-gateway delete' = '? h'
        'network internet-gateway get' = '? h'
        'network internet-gateway list' = '? c h'
        'network internet-gateway update' = '? h'
        'network ip-sec-connection change-compartment' = '? c h'
        'network ip-sec-connection create' = '? c h'
        'network ip-sec-connection delete' = '? h'
        'network ip-sec-connection get' = '? h'
        'network ip-sec-connection get-config' = '? h'
        'network ip-sec-connection get-ipsec-cpe-device-config-content' = '? h'
        'network ip-sec-connection get-status' = '? h'
        'network ip-sec-connection list' = '? c h'
        'network ip-sec-connection update' = '? h'
        'network ip-sec-psk get' = '? h'
        'network ip-sec-psk update' = '? h'
        'network ip-sec-tunnel get' = '? h'
        'network ip-sec-tunnel list' = '? h'
        'network ip-sec-tunnel update' = '? h'
        'network ipv6 create' = '? h'
        'network ipv6 delete' = '? h'
        'network ipv6 get' = '? h'
        'network ipv6 list' = '? h'
        'network ipv6 update' = '? h'
        'network local-peering-gateway change-compartment' = '? c h'
        'network local-peering-gateway connect' = '? h'
        'network local-peering-gateway create' = '? c h'
        'network local-peering-gateway delete' = '? h'
        'network local-peering-gateway get' = '? h'
        'network local-peering-gateway list' = '? c h'
        'network local-peering-gateway update' = '? h'
        'network nat-gateway change-compartment' = '? c h'
        'network nat-gateway create' = '? c h'
        'network nat-gateway delete' = '? h'
        'network nat-gateway get' = '? h'
        'network nat-gateway list' = '? c h'
        'network nat-gateway update' = '? h'
        'network networking-topology get' = '? c h'
        'network nsg change-compartment' = '? c h'
        'network nsg create' = '? c h'
        'network nsg delete' = '? h'
        'network nsg get' = '? h'
        'network nsg list' = '? c h'
        'network nsg rules add' = '? h'
        'network nsg rules list' = '? h'
        'network nsg rules remove' = '? h'
        'network nsg rules update' = '? h'
        'network nsg update' = '? h'
        'network nsg vnics list' = '? h'
        'network private-ip delete' = '? h'
        'network private-ip get' = '? h'
        'network private-ip list' = '? h'
        'network private-ip update' = '? h'
        'network public-ip change-compartment' = '? c h'
        'network public-ip create' = '? c h'
        'network public-ip delete' = '? h'
        'network public-ip get' = '? h'
        'network public-ip list' = '? c h'
        'network public-ip update' = '? h'
        'network public-ip-pool add' = '? h'
        'network public-ip-pool change-compartment' = '? c h'
        'network public-ip-pool create' = '? c h'
        'network public-ip-pool delete' = '? h'
        'network public-ip-pool get' = '? h'
        'network public-ip-pool list' = '? c h'
        'network public-ip-pool remove' = '? h'
        'network public-ip-pool update' = '? h'
        'network remote-peering-connection change-compartment' = '? c h'
        'network remote-peering-connection connect' = '? h'
        'network remote-peering-connection create' = '? c h'
        'network remote-peering-connection delete' = '? h'
        'network remote-peering-connection get' = '? h'
        'network remote-peering-connection list' = '? c h'
        'network remote-peering-connection update' = '? h'
        'network route-table change-compartment' = '? c h'
        'network route-table create' = '? c h'
        'network route-table delete' = '? h'
        'network route-table get' = '? h'
        'network route-table list' = '? c h'
        'network route-table update' = '? h'
        'network security-list change-compartment' = '? c h'
        'network security-list create' = '? c h'
        'network security-list delete' = '? h'
        'network security-list get' = '? h'
        'network security-list list' = '? c h'
        'network security-list update' = '? h'
        'network service get' = '? h'
        'network service list' = '? h'
        'network service-gateway attach' = '? h'
        'network service-gateway change-compartment' = '? c h'
        'network service-gateway create' = '? c h'
        'network service-gateway delete' = '? h'
        'network service-gateway detach' = '? h'
        'network service-gateway get' = '? h'
        'network service-gateway list' = '? c h'
        'network service-gateway update' = '? h'
        'network subnet change-compartment' = '? c h'
        'network subnet create' = '? c h'
        'network subnet delete' = '? h'
        'network subnet get' = '? h'
        'network subnet list' = '? c h'
        'network subnet update' = '? h'
        'network tunnel-cpe-device-config get' = '? h'
        'network tunnel-cpe-device-config get-tunnel-cpe-device-config-content' = '? h'
        'network tunnel-cpe-device-config update' = '? h'
        'network vcn add-ipv6-vcn-cidr' = '? h'
        'network vcn add-vcn-cidr' = '? h'
        'network vcn change-compartment' = '? c h'
        'network vcn create' = '? c h'
        'network vcn delete' = '? h'
        'network vcn get' = '? h'
        'network vcn list' = '? c h'
        'network vcn modify-vcn-cidr' = '? h'
        'network vcn remove-vcn-cidr' = '? h'
        'network vcn update' = '? h'
        'network vcn-dns-resolver-association get' = '? h'
        'network vcn-topology get' = '? c h'
        'network virtual-circuit change-compartment' = '? c h'
        'network virtual-circuit create' = '? c h'
        'network virtual-circuit delete' = '? h'
        'network virtual-circuit get' = '? h'
        'network virtual-circuit list' = '? c h'
        'network virtual-circuit update' = '? h'
        'network virtual-circuit-public-prefix bulk-add' = '? h'
        'network virtual-circuit-public-prefix bulk-delete' = '? h'
        'network virtual-circuit-public-prefix list' = '? h'
        'network vlan change-compartment' = '? c h'
        'network vlan create' = '? c h'
        'network vlan delete' = '? h'
        'network vlan get' = '? h'
        'network vlan list' = '? c h'
        'network vlan update' = '? h'
        'network vnic assign-ipv6' = '? h'
        'network vnic assign-private-ip' = '? h'
        'network vnic get' = '? h'
        'network vnic unassign-ipv6' = '? h'
        'network vnic unassign-private-ip' = '? h'
        'network vnic update' = '? h'
    }
    return $ociCommandsToShortParams
}