# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli.cli_root import cli
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias


@cli.command(cli_util.override('capacity_management.capacity_management_root_group.command_name', 'capacity-management'), cls=CommandGroupWithAlias, help=cli_util.override('capacity_management.capacity_management_root_group.help', """A description of the OciControlCenterCp API"""), short_help=cli_util.override('capacity_management.capacity_management_root_group.short_help', """OciControlCenterCp API"""))
@cli_util.help_option_group
def capacity_management_root_group():
    pass


@click.command(cli_util.override('capacity_management.occ_customer_group_collection_group.command_name', 'occ-customer-group-collection'), cls=CommandGroupWithAlias, help="""A list of customer groups.""")
@cli_util.help_option_group
def occ_customer_group_collection_group():
    pass


@click.command(cli_util.override('capacity_management.occ_capacity_request_group.command_name', 'occ-capacity-request'), cls=CommandGroupWithAlias, help="""A single request of some quantity of a specific server type, in a specific location and expected delivery date. The maximum amount possible to request is the smallest number between the number of servers available for purchase and the number of servers allowed by the constraints (For example, power, network, physical space, and so on).""")
@cli_util.help_option_group
def occ_capacity_request_group():
    pass


@click.command(cli_util.override('capacity_management.occ_availability_catalog_group.command_name', 'occ-availability-catalog'), cls=CommandGroupWithAlias, help="""Details of the availability catalog resource.""")
@cli_util.help_option_group
def occ_availability_catalog_group():
    pass


@click.command(cli_util.override('capacity_management.occ_capacity_request_collection_group.command_name', 'occ-capacity-request-collection'), cls=CommandGroupWithAlias, help="""A list of capacity requests.""")
@cli_util.help_option_group
def occ_capacity_request_collection_group():
    pass


@click.command(cli_util.override('capacity_management.occ_availability_catalog_collection_group.command_name', 'occ-availability-catalog-collection'), cls=CommandGroupWithAlias, help="""A list of availability catalogs.""")
@cli_util.help_option_group
def occ_availability_catalog_collection_group():
    pass


@click.command(cli_util.override('capacity_management.occ_customer_group_group.command_name', 'occ-customer-group'), cls=CommandGroupWithAlias, help="""Details of the customer group resource.""")
@cli_util.help_option_group
def occ_customer_group_group():
    pass


@click.command(cli_util.override('capacity_management.occ_overview_collection_group.command_name', 'occ-overview-collection'), cls=CommandGroupWithAlias, help="""A list representing response of overview API.""")
@cli_util.help_option_group
def occ_overview_collection_group():
    pass


@click.command(cli_util.override('capacity_management.occ_availability_collection_group.command_name', 'occ-availability-collection'), cls=CommandGroupWithAlias, help="""A list of capacity constraints.""")
@cli_util.help_option_group
def occ_availability_collection_group():
    pass


capacity_management_root_group.add_command(occ_customer_group_collection_group)
capacity_management_root_group.add_command(occ_capacity_request_group)
capacity_management_root_group.add_command(occ_availability_catalog_group)
capacity_management_root_group.add_command(occ_capacity_request_collection_group)
capacity_management_root_group.add_command(occ_availability_catalog_collection_group)
capacity_management_root_group.add_command(occ_customer_group_group)
capacity_management_root_group.add_command(occ_overview_collection_group)
capacity_management_root_group.add_command(occ_availability_collection_group)


@occ_availability_catalog_group.command(name=cli_util.override('capacity_management.create_occ_availability_catalog.command_name', 'create'), help=u"""Create availability catalog \n[Command Reference](createOccAvailabilityCatalog)""")
@cli_util.option('--occ-customer-group-id', required=True, help=u"""The OCID of the customer group.""")
@cli_util.option('--namespace', required=True, type=custom_types.CliCaseInsensitiveChoice(["COMPUTE"]), help=u"""The name of the OCI service in consideration. For example, Compute, Exadata, and so on.""")
@cli_util.option('--compartment-id', required=True, help=u"""Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.""")
@cli_util.option('--base64-encoded-catalog-details', required=True, help=u"""The base 64 encoded string corresponding to the catalog file contents.""")
@cli_util.option('--display-name', required=True, help=u"""The display name of the availability catalog.""")
@cli_util.option('--metadata-details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--description', help=u"""Additional information about the availability catalog.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'metadata-details': {'module': 'capacity_management', 'class': 'MetadataDetails'}, 'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'metadata-details': {'module': 'capacity_management', 'class': 'MetadataDetails'}, 'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'capacity_management', 'class': 'OccAvailabilityCatalog'})
@cli_util.wrap_exceptions
def create_occ_availability_catalog(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, occ_customer_group_id, namespace, compartment_id, base64_encoded_catalog_details, display_name, metadata_details, description, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['occCustomerGroupId'] = occ_customer_group_id
    _details['namespace'] = namespace
    _details['compartmentId'] = compartment_id
    _details['base64EncodedCatalogDetails'] = base64_encoded_catalog_details
    _details['displayName'] = display_name

    if metadata_details is not None:
        _details['metadataDetails'] = cli_util.parse_json_parameter("metadata_details", metadata_details)

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    result = client.create_occ_availability_catalog(
        create_occ_availability_catalog_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_occ_availability_catalog') and callable(getattr(client, 'get_occ_availability_catalog')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_occ_availability_catalog(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@occ_capacity_request_group.command(name=cli_util.override('capacity_management.create_occ_capacity_request.command_name', 'create'), help=u"""Create Capacity Request. \n[Command Reference](createOccCapacityRequest)""")
@cli_util.option('--compartment-id', required=True, help=u"""Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.""")
@cli_util.option('--namespace', required=True, type=custom_types.CliCaseInsensitiveChoice(["COMPUTE"]), help=u"""The name of the OCI service in consideration. For example, Compute, Exadata, and so on.""")
@cli_util.option('--region-parameterconflict', required=True, help=u"""The name of the region for which the capacity request is made.""")
@cli_util.option('--display-name', required=True, help=u"""An user-friendly name for the capacity request. Does not have to be unique, and it's changeable. Avoid entering confidential information.""")
@cli_util.option('--availability-domain', required=True, help=u"""The availability domain (AD) for which the capacity request is made. If this is specified then the capacity will be validated and fulfilled within the scope of this AD.""")
@cli_util.option('--date-expected-capacity-handover', required=True, type=custom_types.CLI_DATETIME, help=u"""The date by which the capacity requested by customers before dateFinalCustomerOrder needs to be fulfilled.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--details', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of different resources requested by the user.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--occ-availability-catalog-id', help=u"""The OCID of the availability catalog against which capacity request is made.""")
@cli_util.option('--request-type', help=u"""Type of Capacity Request(New or Transfer)""")
@cli_util.option('--description', help=u"""Meaningful text about the capacity request.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--lifecycle-details', help=u"""A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed State.""")
@cli_util.option('--request-state', type=custom_types.CliCaseInsensitiveChoice(["CREATED", "SUBMITTED"]), help=u"""The subset of request states available for creating the capacity request.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}, 'details': {'module': 'capacity_management', 'class': 'list[OccCapacityRequestBaseDetails]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}, 'details': {'module': 'capacity_management', 'class': 'list[OccCapacityRequestBaseDetails]'}}, output_type={'module': 'capacity_management', 'class': 'OccCapacityRequest'})
@cli_util.wrap_exceptions
def create_occ_capacity_request(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, namespace, region_parameterconflict, display_name, availability_domain, date_expected_capacity_handover, details, occ_availability_catalog_id, request_type, description, freeform_tags, defined_tags, lifecycle_details, request_state):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['namespace'] = namespace
    _details['region'] = region_parameterconflict
    _details['displayName'] = display_name
    _details['availabilityDomain'] = availability_domain
    _details['dateExpectedCapacityHandover'] = date_expected_capacity_handover
    _details['details'] = cli_util.parse_json_parameter("details", details)

    if occ_availability_catalog_id is not None:
        _details['occAvailabilityCatalogId'] = occ_availability_catalog_id

    if request_type is not None:
        _details['requestType'] = request_type

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if lifecycle_details is not None:
        _details['lifecycleDetails'] = lifecycle_details

    if request_state is not None:
        _details['requestState'] = request_state

    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    result = client.create_occ_capacity_request(
        create_occ_capacity_request_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_occ_capacity_request') and callable(getattr(client, 'get_occ_capacity_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_occ_capacity_request(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@occ_availability_catalog_group.command(name=cli_util.override('capacity_management.delete_occ_availability_catalog.command_name', 'delete'), help=u"""Deletes the availability catalog resource. \n[Command Reference](deleteOccAvailabilityCatalog)""")
@cli_util.option('--occ-availability-catalog-id', required=True, help=u"""The OCID of the availability catalog.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_occ_availability_catalog(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, occ_availability_catalog_id, if_match):

    if isinstance(occ_availability_catalog_id, six.string_types) and len(occ_availability_catalog_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-availability-catalog-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    result = client.delete_occ_availability_catalog(
        occ_availability_catalog_id=occ_availability_catalog_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_occ_availability_catalog') and callable(getattr(client, 'get_occ_availability_catalog')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                oci.wait_until(client, client.get_occ_availability_catalog(occ_availability_catalog_id), 'lifecycle_state', wait_for_state, succeed_on_not_found=True, **wait_period_kwargs)
            except oci.exceptions.ServiceError as e:
                # We make an initial service call so we can pass the result to oci.wait_until(), however if we are waiting on the
                # outcome of a delete operation it is possible that the resource is already gone and so the initial service call
                # will result in an exception that reflects a HTTP 404. In this case, we can exit with success (rather than raising
                # the exception) since this would have been the behaviour in the waiter anyway (as for delete we provide the argument
                # succeed_on_not_found=True to the waiter).
                #
                # Any non-404 should still result in the exception being thrown.
                if e.status == 404:
                    pass
                else:
                    raise
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Please retrieve the resource to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@occ_capacity_request_group.command(name=cli_util.override('capacity_management.delete_occ_capacity_request.command_name', 'delete'), help=u"""Deletes the capacity request resource. \n[Command Reference](deleteOccCapacityRequest)""")
@cli_util.option('--occ-capacity-request-id', required=True, help=u"""The OCID of the capacity request.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_occ_capacity_request(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, occ_capacity_request_id, if_match):

    if isinstance(occ_capacity_request_id, six.string_types) and len(occ_capacity_request_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-capacity-request-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    result = client.delete_occ_capacity_request(
        occ_capacity_request_id=occ_capacity_request_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_occ_capacity_request') and callable(getattr(client, 'get_occ_capacity_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                oci.wait_until(client, client.get_occ_capacity_request(occ_capacity_request_id), 'lifecycle_state', wait_for_state, succeed_on_not_found=True, **wait_period_kwargs)
            except oci.exceptions.ServiceError as e:
                # We make an initial service call so we can pass the result to oci.wait_until(), however if we are waiting on the
                # outcome of a delete operation it is possible that the resource is already gone and so the initial service call
                # will result in an exception that reflects a HTTP 404. In this case, we can exit with success (rather than raising
                # the exception) since this would have been the behaviour in the waiter anyway (as for delete we provide the argument
                # succeed_on_not_found=True to the waiter).
                #
                # Any non-404 should still result in the exception being thrown.
                if e.status == 404:
                    pass
                else:
                    raise
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Please retrieve the resource to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@occ_availability_catalog_group.command(name=cli_util.override('capacity_management.get_occ_availability_catalog.command_name', 'get'), help=u"""Get details about availability catalog. \n[Command Reference](getOccAvailabilityCatalog)""")
@cli_util.option('--occ-availability-catalog-id', required=True, help=u"""The OCID of the availability catalog.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccAvailabilityCatalog'})
@cli_util.wrap_exceptions
def get_occ_availability_catalog(ctx, from_json, occ_availability_catalog_id):

    if isinstance(occ_availability_catalog_id, six.string_types) and len(occ_availability_catalog_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-availability-catalog-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    result = client.get_occ_availability_catalog(
        occ_availability_catalog_id=occ_availability_catalog_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@occ_availability_catalog_group.command(name=cli_util.override('capacity_management.get_occ_availability_catalog_content.command_name', 'get-occ-availability-catalog-content'), help=u"""Returns the binary contents of the availability catalog. Can be saved as a csv file. \n[Command Reference](getOccAvailabilityCatalogContent)""")
@cli_util.option('--occ-availability-catalog-id', required=True, help=u"""The OCID of the availability catalog.""")
@cli_util.option('--file', type=click.File(mode='wb'), required=True, help="The name of the file that will receive the response data, or '-' to write to STDOUT.")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def get_occ_availability_catalog_content(ctx, from_json, file, occ_availability_catalog_id, if_match):

    if isinstance(occ_availability_catalog_id, six.string_types) and len(occ_availability_catalog_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-availability-catalog-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    result = client.get_occ_availability_catalog_content(
        occ_availability_catalog_id=occ_availability_catalog_id,
        **kwargs
    )

    # If outputting to stdout we don't want to print a progress bar because it will get mixed up with the output
    # Also we need a non-zero Content-Length in order to display a meaningful progress bar
    bar = None
    if hasattr(file, 'name') and file.name != '<stdout>' and 'Content-Length' in result.headers:
        content_length = int(result.headers['Content-Length'])
        if content_length > 0:
            bar = click.progressbar(length=content_length, label='Downloading file')

    try:
        if bar:
            bar.__enter__()

        # TODO: Make the download size a configurable option
        # use decode_content=True to automatically unzip service responses (this should be overridden for object storage)
        for chunk in result.data.raw.stream(cli_constants.MEBIBYTE, decode_content=True):
            if bar:
                bar.update(len(chunk))
            file.write(chunk)
    finally:
        if bar:
            bar.render_finish()
        file.close()


@occ_capacity_request_group.command(name=cli_util.override('capacity_management.get_occ_capacity_request.command_name', 'get'), help=u"""Get details about the capacity request. \n[Command Reference](getOccCapacityRequest)""")
@cli_util.option('--occ-capacity-request-id', required=True, help=u"""The OCID of the capacity request.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccCapacityRequest'})
@cli_util.wrap_exceptions
def get_occ_capacity_request(ctx, from_json, occ_capacity_request_id):

    if isinstance(occ_capacity_request_id, six.string_types) and len(occ_capacity_request_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-capacity-request-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    result = client.get_occ_capacity_request(
        occ_capacity_request_id=occ_capacity_request_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@occ_customer_group_group.command(name=cli_util.override('capacity_management.get_occ_customer_group.command_name', 'get'), help=u"""Gets information about the specified customer group. \n[Command Reference](getOccCustomerGroup)""")
@cli_util.option('--occ-customer-group-id', required=True, help=u"""The OCID of the customer group.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccCustomerGroup'})
@cli_util.wrap_exceptions
def get_occ_customer_group(ctx, from_json, occ_customer_group_id):

    if isinstance(occ_customer_group_id, six.string_types) and len(occ_customer_group_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-customer-group-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    result = client.get_occ_customer_group(
        occ_customer_group_id=occ_customer_group_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@occ_overview_collection_group.command(name=cli_util.override('capacity_management.list_internal_namespace_occ_overviews.command_name', 'list-internal-namespace-occ-overviews'), help=u"""Lists an overview of all resources in that namespace in a given time interval. \n[Command Reference](listInternalNamespaceOccOverviews)""")
@cli_util.option('--namespace', required=True, type=custom_types.CliCaseInsensitiveChoice(["COMPUTE"]), help=u"""The namespace by which we would filter the list.""")
@cli_util.option('--compartment-id', required=True, help=u"""The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.""")
@cli_util.option('--occ-customer-group-id', help=u"""The customer group ocid by which we would filter the list.""")
@cli_util.option('--workload-type', help=u"""Workload type using the resources in an availability catalog can be filtered.""")
@cli_util.option('---from', type=custom_types.CLI_DATETIME, help=u"""The month corresponding to this date would be considered as the starting point of the time period against which we would like to perform an aggregation.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--to', type=custom_types.CLI_DATETIME, help=u"""The month corresponding to this date would be considered as the ending point of the time period against which we would like to perform an aggregation.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["periodValue"]), help=u"""The field to sort by. Only one sort order may be provided. The default order for periodValue is chronological order(latest month item at the end).""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccOverviewCollection'})
@cli_util.wrap_exceptions
def list_internal_namespace_occ_overviews(ctx, from_json, all_pages, page_size, namespace, compartment_id, occ_customer_group_id, workload_type, _from, to, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(namespace, six.string_types) and len(namespace.strip()) == 0:
        raise click.UsageError('Parameter --namespace cannot be whitespace or empty string')

    kwargs = {}
    if occ_customer_group_id is not None:
        kwargs['occ_customer_group_id'] = occ_customer_group_id
    if workload_type is not None:
        kwargs['workload_type'] = workload_type
    if _from is not None:
        kwargs['_from'] = _from
    if to is not None:
        kwargs['to'] = to
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_internal_namespace_occ_overviews,
            namespace=namespace,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_internal_namespace_occ_overviews,
            limit,
            page_size,
            namespace=namespace,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_internal_namespace_occ_overviews(
            namespace=namespace,
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@occ_availability_collection_group.command(name=cli_util.override('capacity_management.list_occ_availabilities.command_name', 'list-occ-availabilities'), help=u"""Lists availabilities for a particular availability catalog. \n[Command Reference](listOccAvailabilities)""")
@cli_util.option('--occ-availability-catalog-id', required=True, help=u"""The OCID of the availability catalog.""")
@cli_util.option('--date-expected-capacity-handover', help=u"""The capacity handover date of the capacity constraint to filter the list of capacity constraints.""")
@cli_util.option('--resource-name', help=u"""The name of the resource to filter the list of capacity constraints.""")
@cli_util.option('--resource-type', help=u"""Resource type using which the capacity constraints of an availability catalog can be filtered.""")
@cli_util.option('--workload-type', help=u"""Workload type using the resources in an availability catalog can be filtered.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["dateExpectedCapacityHandover", "resourceName"]), help=u"""The field to sort by.  Only one sort order may be provided. The default order for resource name is ascending. The default order for date of capacity handover is descending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccAvailabilityCollection'})
@cli_util.wrap_exceptions
def list_occ_availabilities(ctx, from_json, all_pages, page_size, occ_availability_catalog_id, date_expected_capacity_handover, resource_name, resource_type, workload_type, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(occ_availability_catalog_id, six.string_types) and len(occ_availability_catalog_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-availability-catalog-id cannot be whitespace or empty string')

    kwargs = {}
    if date_expected_capacity_handover is not None:
        kwargs['date_expected_capacity_handover'] = date_expected_capacity_handover
    if resource_name is not None:
        kwargs['resource_name'] = resource_name
    if resource_type is not None:
        kwargs['resource_type'] = resource_type
    if workload_type is not None:
        kwargs['workload_type'] = workload_type
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_occ_availabilities,
            occ_availability_catalog_id=occ_availability_catalog_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_occ_availabilities,
            limit,
            page_size,
            occ_availability_catalog_id=occ_availability_catalog_id,
            **kwargs
        )
    else:
        result = client.list_occ_availabilities(
            occ_availability_catalog_id=occ_availability_catalog_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@occ_availability_catalog_collection_group.command(name=cli_util.override('capacity_management.list_occ_availability_catalogs.command_name', 'list-occ-availability-catalogs'), help=u"""Lists all availability catalogs. \n[Command Reference](listOccAvailabilityCatalogs)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.""")
@cli_util.option('--namespace', type=custom_types.CliCaseInsensitiveChoice(["COMPUTE"]), help=u"""The namespace by which we would filter the list.""")
@cli_util.option('--id', help=u"""The OCID of the availability catalog to filter the list of availability catalogs.""")
@cli_util.option('--display-name', help=u"""A filter to return only the resources that match the entire display name. The match is not case sensitive.""")
@cli_util.option('--catalog-state', type=custom_types.CliCaseInsensitiveChoice(["NOT_UPLOADED", "UPLOAD_FAILED", "STAGED", "PUBLISHED", "OUTDATED", "DELETED"]), help=u"""Filter the list of availability catalogs based on the catalog state.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["displayName", "timeCreated"]), help=u"""The field to sort by. Only one sort order may be provided. The default order for displayName is ascending. The default order for timeCreated is descending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccAvailabilityCatalogCollection'})
@cli_util.wrap_exceptions
def list_occ_availability_catalogs(ctx, from_json, all_pages, page_size, compartment_id, namespace, id, display_name, catalog_state, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if namespace is not None:
        kwargs['namespace'] = namespace
    if id is not None:
        kwargs['id'] = id
    if display_name is not None:
        kwargs['display_name'] = display_name
    if catalog_state is not None:
        kwargs['catalog_state'] = catalog_state
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_occ_availability_catalogs,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_occ_availability_catalogs,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_occ_availability_catalogs(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@occ_availability_catalog_collection_group.command(name=cli_util.override('capacity_management.list_occ_availability_catalogs_internal.command_name', 'list-occ-availability-catalogs-internal'), help=u"""An internal api to list availability catalogs. \n[Command Reference](listOccAvailabilityCatalogsInternal)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.""")
@cli_util.option('--namespace', type=custom_types.CliCaseInsensitiveChoice(["COMPUTE"]), help=u"""The namespace by which we would filter the list.""")
@cli_util.option('--id', help=u"""The OCID of the availability catalog to filter the list of availability catalogs.""")
@cli_util.option('--display-name', help=u"""A filter to return only the resources that match the entire display name. The match is not case sensitive.""")
@cli_util.option('--catalog-state', type=custom_types.CliCaseInsensitiveChoice(["NOT_UPLOADED", "UPLOAD_FAILED", "STAGED", "PUBLISHED", "OUTDATED", "DELETED"]), help=u"""Filter the list of availability catalogs based on the catalog state.""")
@cli_util.option('--occ-customer-group-id', help=u"""The customer group ocid by which we would filter the list.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["displayName", "timeCreated"]), help=u"""The field to sort by. Only one sort order may be provided. The default order for displayName is ascending. The default order for timeCreated is descending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccAvailabilityCatalogCollection'})
@cli_util.wrap_exceptions
def list_occ_availability_catalogs_internal(ctx, from_json, all_pages, page_size, compartment_id, namespace, id, display_name, catalog_state, occ_customer_group_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if namespace is not None:
        kwargs['namespace'] = namespace
    if id is not None:
        kwargs['id'] = id
    if display_name is not None:
        kwargs['display_name'] = display_name
    if catalog_state is not None:
        kwargs['catalog_state'] = catalog_state
    if occ_customer_group_id is not None:
        kwargs['occ_customer_group_id'] = occ_customer_group_id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_occ_availability_catalogs_internal,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_occ_availability_catalogs_internal,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_occ_availability_catalogs_internal(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@occ_capacity_request_collection_group.command(name=cli_util.override('capacity_management.list_occ_capacity_requests.command_name', 'list-occ-capacity-requests'), help=u"""Lists all capacity requests. \n[Command Reference](listOccCapacityRequests)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.""")
@cli_util.option('--occ-availability-catalog-id', help=u"""A filter to return the list of capacity requests based on the OCID of the availability catalog against which they were created.""")
@cli_util.option('--namespace', type=custom_types.CliCaseInsensitiveChoice(["COMPUTE"]), help=u"""The namespace by which we would filter the list.""")
@cli_util.option('--request-type', type=custom_types.CliCaseInsensitiveChoice(["NEW", "TRANSFER"]), help=u"""A filter to return only the resources that match the request type. The match is not case sensitive.""")
@cli_util.option('--display-name', help=u"""A filter to return only the resources that match the entire display name. The match is not case sensitive.""")
@cli_util.option('--id', help=u"""A filter to return the list of capacity requests based on the OCID of the capacity request. This is done for the users who have INSPECT permission on the resource but do not have READ permission.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["displayName", "timeCreated"]), help=u"""The field to sort by. Only one sort order may be provided. The default order for display name is ascending. The default order for time created is reverse chronological order(latest date at the top).""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccCapacityRequestCollection'})
@cli_util.wrap_exceptions
def list_occ_capacity_requests(ctx, from_json, all_pages, page_size, compartment_id, occ_availability_catalog_id, namespace, request_type, display_name, id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if occ_availability_catalog_id is not None:
        kwargs['occ_availability_catalog_id'] = occ_availability_catalog_id
    if namespace is not None:
        kwargs['namespace'] = namespace
    if request_type is not None:
        kwargs['request_type'] = request_type
    if display_name is not None:
        kwargs['display_name'] = display_name
    if id is not None:
        kwargs['id'] = id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_occ_capacity_requests,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_occ_capacity_requests,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_occ_capacity_requests(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@occ_capacity_request_collection_group.command(name=cli_util.override('capacity_management.list_occ_capacity_requests_internal.command_name', 'list-occ-capacity-requests-internal'), help=u"""An internal api to list all capacity requests. \n[Command Reference](listOccCapacityRequestsInternal)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.""")
@cli_util.option('--occ-customer-group-id', help=u"""The customer group ocid by which we would filter the list.""")
@cli_util.option('--occ-availability-catalog-id', help=u"""A filter to return the list of capacity requests based on the OCID of the availability catalog against which they were created.""")
@cli_util.option('--namespace', type=custom_types.CliCaseInsensitiveChoice(["COMPUTE"]), help=u"""The namespace by which we would filter the list.""")
@cli_util.option('--display-name', help=u"""A filter to return only the resources that match the entire display name. The match is not case sensitive.""")
@cli_util.option('--request-type', type=custom_types.CliCaseInsensitiveChoice(["NEW", "TRANSFER"]), help=u"""A filter to return only the resources that match the request type. The match is not case sensitive.""")
@cli_util.option('--id', help=u"""A filter to return the list of capacity requests based on the OCID of the capacity request. This is done for the users who have INSPECT permission on the resource but do not have READ permission.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["displayName", "timeCreated"]), help=u"""The field to sort by. Only one sort order may be provided. The default order for display name is ascending. The default order for time created is reverse chronological order(latest date at the top).""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccCapacityRequestCollection'})
@cli_util.wrap_exceptions
def list_occ_capacity_requests_internal(ctx, from_json, all_pages, page_size, compartment_id, occ_customer_group_id, occ_availability_catalog_id, namespace, display_name, request_type, id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if occ_customer_group_id is not None:
        kwargs['occ_customer_group_id'] = occ_customer_group_id
    if occ_availability_catalog_id is not None:
        kwargs['occ_availability_catalog_id'] = occ_availability_catalog_id
    if namespace is not None:
        kwargs['namespace'] = namespace
    if display_name is not None:
        kwargs['display_name'] = display_name
    if request_type is not None:
        kwargs['request_type'] = request_type
    if id is not None:
        kwargs['id'] = id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_occ_capacity_requests_internal,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_occ_capacity_requests_internal,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_occ_capacity_requests_internal(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@occ_customer_group_collection_group.command(name=cli_util.override('capacity_management.list_occ_customer_groups.command_name', 'list-occ-customer-groups'), help=u"""Lists all the customer groups. \n[Command Reference](listOccCustomerGroups)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ENABLED", "DISABLED"]), help=u"""A query filter to return the list result based on status.""")
@cli_util.option('--display-name', help=u"""A filter to return only the resources that match the entire display name. The match is not case sensitive.""")
@cli_util.option('--id', help=u"""A query filter to return the list result based on the customer group OCID. This is done for users who have INSPECT permission but do not have READ permission.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["compartmentId", "name", "timeCreated"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for name and compartment ID is ascending. Default order for time created is descending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccCustomerGroupCollection'})
@cli_util.wrap_exceptions
def list_occ_customer_groups(ctx, from_json, all_pages, page_size, compartment_id, status, display_name, id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if status is not None:
        kwargs['status'] = status
    if display_name is not None:
        kwargs['display_name'] = display_name
    if id is not None:
        kwargs['id'] = id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_occ_customer_groups,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_occ_customer_groups,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_occ_customer_groups(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@occ_overview_collection_group.command(name=cli_util.override('capacity_management.list_occ_overviews.command_name', 'list-occ-overviews'), help=u"""Lists an overview of all resources in that namespace in a given time interval. \n[Command Reference](listOccOverviews)""")
@cli_util.option('--namespace', required=True, type=custom_types.CliCaseInsensitiveChoice(["COMPUTE"]), help=u"""The namespace by which we would filter the list.""")
@cli_util.option('--compartment-id', required=True, help=u"""The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.""")
@cli_util.option('---from', type=custom_types.CLI_DATETIME, help=u"""The month corresponding to this date would be considered as the starting point of the time period against which we would like to perform an aggregation.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--to', type=custom_types.CLI_DATETIME, help=u"""The month corresponding to this date would be considered as the ending point of the time period against which we would like to perform an aggregation.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--workload-type', help=u"""Workload type using the resources in an availability catalog can be filtered.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["periodValue"]), help=u"""The field to sort by. Only one sort order may be provided. The default order for periodValue is chronological order(latest month item at the end).""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccOverviewCollection'})
@cli_util.wrap_exceptions
def list_occ_overviews(ctx, from_json, all_pages, page_size, namespace, compartment_id, _from, to, workload_type, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(namespace, six.string_types) and len(namespace.strip()) == 0:
        raise click.UsageError('Parameter --namespace cannot be whitespace or empty string')

    kwargs = {}
    if _from is not None:
        kwargs['_from'] = _from
    if to is not None:
        kwargs['to'] = to
    if workload_type is not None:
        kwargs['workload_type'] = workload_type
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_occ_overviews,
            namespace=namespace,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_occ_overviews,
            limit,
            page_size,
            namespace=namespace,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_occ_overviews(
            namespace=namespace,
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@occ_capacity_request_group.command(name=cli_util.override('capacity_management.patch_internal_occ_capacity_request.command_name', 'patch-internal'), help=u"""Updates the OccCapacityRequest by evaluating a sequence of instructions. \n[Command Reference](patchInternalOccCapacityRequest)""")
@cli_util.option('--occ-capacity-request-id', required=True, help=u"""The OCID of the capacity request.""")
@cli_util.option('--items', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of patch instructions.

This option is a JSON list with items of type PatchInstruction.  For documentation on PatchInstruction please see our API reference: https://docs.cloud.oracle.com/api/#/en/capacitymanagement/20231107/datatypes/PatchInstruction.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({'items': {'module': 'capacity_management', 'class': 'list[PatchInstruction]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'items': {'module': 'capacity_management', 'class': 'list[PatchInstruction]'}}, output_type={'module': 'capacity_management', 'class': 'OccCapacityRequest'})
@cli_util.wrap_exceptions
def patch_internal_occ_capacity_request(ctx, from_json, occ_capacity_request_id, items, if_match):

    if isinstance(occ_capacity_request_id, six.string_types) and len(occ_capacity_request_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-capacity-request-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if items is not None:
        _details['items'] = cli_util.parse_json_parameter("items", items)

    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    result = client.patch_internal_occ_capacity_request(
        occ_capacity_request_id=occ_capacity_request_id,
        patch_occ_capacity_request_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@occ_capacity_request_group.command(name=cli_util.override('capacity_management.patch_occ_capacity_request.command_name', 'patch'), help=u"""Updates the OccCapacityRequest by evaluating a sequence of instructions. \n[Command Reference](patchOccCapacityRequest)""")
@cli_util.option('--occ-capacity-request-id', required=True, help=u"""The OCID of the capacity request.""")
@cli_util.option('--items', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of patch instructions.

This option is a JSON list with items of type PatchInstruction.  For documentation on PatchInstruction please see our API reference: https://docs.cloud.oracle.com/api/#/en/capacitymanagement/20231107/datatypes/PatchInstruction.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({'items': {'module': 'capacity_management', 'class': 'list[PatchInstruction]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'items': {'module': 'capacity_management', 'class': 'list[PatchInstruction]'}}, output_type={'module': 'capacity_management', 'class': 'OccCapacityRequest'})
@cli_util.wrap_exceptions
def patch_occ_capacity_request(ctx, from_json, occ_capacity_request_id, items, if_match):

    if isinstance(occ_capacity_request_id, six.string_types) and len(occ_capacity_request_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-capacity-request-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if items is not None:
        _details['items'] = cli_util.parse_json_parameter("items", items)

    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    result = client.patch_occ_capacity_request(
        occ_capacity_request_id=occ_capacity_request_id,
        patch_occ_capacity_request_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@occ_availability_catalog_group.command(name=cli_util.override('capacity_management.publish_occ_availability_catalog.command_name', 'publish'), help=u"""Publishes the version of availability catalog specified by the operator. This makes that catalog version visible to customers. \n[Command Reference](publishOccAvailabilityCatalog)""")
@cli_util.option('--occ-availability-catalog-id', required=True, help=u"""The OCID of the availability catalog.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def publish_occ_availability_catalog(ctx, from_json, occ_availability_catalog_id, if_match):

    if isinstance(occ_availability_catalog_id, six.string_types) and len(occ_availability_catalog_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-availability-catalog-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    result = client.publish_occ_availability_catalog(
        occ_availability_catalog_id=occ_availability_catalog_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@occ_capacity_request_group.command(name=cli_util.override('capacity_management.update_internal_occ_capacity_request.command_name', 'update-internal'), help=u"""The internal api to update the capacity request. This api will be used by operators for updating the capacity request to either completed, resubmitted or rejected. \n[Command Reference](updateInternalOccCapacityRequest)""")
@cli_util.option('--occ-capacity-request-id', required=True, help=u"""The OCID of the capacity request.""")
@cli_util.option('--request-state', type=custom_types.CliCaseInsensitiveChoice(["RESOLVED", "REJECTED", "IN_PROGRESS"]), help=u"""The subset of request states available internally for updating the capacity request.""")
@cli_util.option('--lifecycle-details', help=u"""A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed State.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccCapacityRequest'})
@cli_util.wrap_exceptions
def update_internal_occ_capacity_request(ctx, from_json, occ_capacity_request_id, request_state, lifecycle_details, if_match):

    if isinstance(occ_capacity_request_id, six.string_types) and len(occ_capacity_request_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-capacity-request-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if request_state is not None:
        _details['requestState'] = request_state

    if lifecycle_details is not None:
        _details['lifecycleDetails'] = lifecycle_details

    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    result = client.update_internal_occ_capacity_request(
        occ_capacity_request_id=occ_capacity_request_id,
        update_internal_occ_capacity_request_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@occ_availability_catalog_group.command(name=cli_util.override('capacity_management.update_occ_availability_catalog.command_name', 'update'), help=u"""The request to update the availability catalog. Currently only freeform tags can be updated via this api. \n[Command Reference](updateOccAvailabilityCatalog)""")
@cli_util.option('--occ-availability-catalog-id', required=True, help=u"""The OCID of the availability catalog.""")
@cli_util.option('--display-name', help=u"""The display name of the availability catalog.""")
@cli_util.option('--description', help=u"""Additional information about the availability catalog.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'capacity_management', 'class': 'OccAvailabilityCatalog'})
@cli_util.wrap_exceptions
def update_occ_availability_catalog(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, occ_availability_catalog_id, display_name, description, freeform_tags, defined_tags, if_match):

    if isinstance(occ_availability_catalog_id, six.string_types) and len(occ_availability_catalog_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-availability-catalog-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    result = client.update_occ_availability_catalog(
        occ_availability_catalog_id=occ_availability_catalog_id,
        update_occ_availability_catalog_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_occ_availability_catalog') and callable(getattr(client, 'get_occ_availability_catalog')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_occ_availability_catalog(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@occ_capacity_request_group.command(name=cli_util.override('capacity_management.update_occ_capacity_request.command_name', 'update'), help=u"""The request to update the capacity request. The user can perform actions like closing a partially completed request so that it doesn't go ahead for full completion. \n[Command Reference](updateOccCapacityRequest)""")
@cli_util.option('--occ-capacity-request-id', required=True, help=u"""The OCID of the capacity request.""")
@cli_util.option('--display-name', help=u"""The display name of the capacity request.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--request-state', type=custom_types.CliCaseInsensitiveChoice(["SUBMITTED", "CANCELLED"]), help=u"""The subset of request states available for updating the capacity request.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'capacity_management', 'class': 'OccCapacityRequest'})
@cli_util.wrap_exceptions
def update_occ_capacity_request(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, occ_capacity_request_id, display_name, freeform_tags, defined_tags, request_state, if_match):

    if isinstance(occ_capacity_request_id, six.string_types) and len(occ_capacity_request_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-capacity-request-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if request_state is not None:
        _details['requestState'] = request_state

    client = cli_util.build_client('capacity_management', 'capacity_management', ctx)
    result = client.update_occ_capacity_request(
        occ_capacity_request_id=occ_capacity_request_id,
        update_occ_capacity_request_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_occ_capacity_request') and callable(getattr(client, 'get_occ_capacity_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_occ_capacity_request(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
