# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _activearea
else:
    import _activearea

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import ooflib.SWIG.common.cmicrostructure
import ooflib.SWIG.common.coord
import ooflib.SWIG.common.pixelgroup
import ooflib.SWIG.common.pixelattribute
import ooflib.SWIG.common.timestamp
import ooflib.SWIG.common.cpixelselection
import ooflib.SWIG.common.IO.bitoverlay
import ooflib.SWIG.common.ccolor
import ooflib.SWIG.common.abstractimage
class ActiveArea(ooflib.SWIG.common.cpixelselection.CPixelSelection):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, iPoint, Point, arg4):
        _activearea.ActiveArea_swiginit(self, _activearea.new_ActiveArea(iPoint, Point, arg4))
    __swig_destroy__ = _activearea.delete_ActiveArea

    def clone(self):
        return _activearea.ActiveArea_clone(self)

    def isActive(self, iPoint):
        return _activearea.ActiveArea_isActive(self, iPoint)

    def override(self, arg2):
        return _activearea.ActiveArea_override(self, arg2)

    def getOverride(self):
        return _activearea.ActiveArea_getOverride(self)

    def add_pixels(self, iPointList):
        return _activearea.ActiveArea_add_pixels(self, iPointList)

# Register ActiveArea in _activearea:
_activearea.ActiveArea_swigregister(ActiveArea)
class ActiveAreasAttributeRegistration(ooflib.SWIG.common.pixelattribute.PxlAttributeRegistration):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _activearea.ActiveAreasAttributeRegistration_swiginit(self, _activearea.new_ActiveAreasAttributeRegistration())

    def createAttribute(self, arg2):
        return _activearea.ActiveAreasAttributeRegistration_createAttribute(self, arg2)
    __swig_destroy__ = _activearea.delete_ActiveAreasAttributeRegistration

# Register ActiveAreasAttributeRegistration in _activearea:
_activearea.ActiveAreasAttributeRegistration_swigregister(ActiveAreasAttributeRegistration)
class ActiveAreaList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def add(self, arg2):
        return _activearea.ActiveAreaList_add(self, arg2)

    def remove(self, arg2):
        return _activearea.ActiveAreaList_remove(self, arg2)

    def getNames(self):
        return _activearea.ActiveAreaList_getNames(self)

    def __init__(self):
        _activearea.ActiveAreaList_swiginit(self, _activearea.new_ActiveAreaList())
    __swig_destroy__ = _activearea.delete_ActiveAreaList

# Register ActiveAreaList in _activearea:
_activearea.ActiveAreaList_swigregister(ActiveAreaList)

def areaListFromPixel(arg1, iPoint):
    return _activearea.areaListFromPixel(arg1, iPoint)
# -*- python -*-


# This software was produced by NIST, an agency of the U.S. government,
# and by statute is not subject to copyright in the United States.
# Recipients of this software assume all responsibilities associated
# with its operation, modification and maintenance. However, to
# facilitate maintenance we ask that before distributing modified
# versions of this software, you first contact the authors at
# oof_manager@nist.gov.

## The active regions of a Microstructure are stored in an ActiveArea
## object, which is basically the same as a PixelSelection.
## ActiveAreas and PixelSelections share a C++ base class,
## CPixelSelection.  Each Python Microstructure holds a Python
## ActiveAreaContext, which is the WhoDoUndoClass for ActiveAreas.
## The CMicrostructures contain a pointer to the current ActiveArea in
## the ActiveAreaContext.

## In the CPixelSelection object, it's the INactive pixels that are
## explicitly stored, so that clearing the ActiveArea is the same as
## making all pixels active.

from ooflib.SWIG.common import switchboard
from ooflib.SWIG.common import config
from ooflib.common import color
from ooflib.common import debug
from ooflib.common.IO import mainmenu
from ooflib.common.IO import oofmenu
from ooflib.common.IO import parameter
from ooflib.common.IO import whoville
from ooflib.common.IO import ghostgfxwindow
from ooflib.common.IO import bitoverlaydisplay
from ooflib.common.IO import topwho            # defines <top activearea>

class NamedActiveArea:
    def __init__(self, name, activearea):
        self.name = name
        self.activearea = activearea

#####################################

class ActiveAreaContext(whoville.WhoDoUndo):
    def __init__(self, path, classname, obj, parent):
# override==1 means that all pixels are active, despite what's
# stored in the pixel selection.
        self._override = 0
        whoville.WhoDoUndo.__init__(self, path, classname, obj, parent)
    def start(self):
        newselection = self.getObject().clone()
        self.pushModification(newselection)
    def selectWithoutCheck(self, selectioncourier):
        self.getObject().selectWithoutCheck(selectioncourier)
        switchboard.notify('pixel selection changed')
    def unselectWithoutCheck(self, selectioncourier):
        self.getObject().unselectWithoutCheck(selectioncourier)
        switchboard.notify('pixel selection changed')
    def toggleWithoutCheck(self, selectioncourier):
        self.getObject().toggleWithoutCheck(selectioncourier)
        switchboard.notify('pixel selection changed')
    def clear(self):
        self.getObject().clearWithoutCheck()
    def invert(self):
        self.getObject().invertWithoutCheck()
    def undo(self):
        self.undoModification()
    def redo(self):
        self.redoModification()
    def clearable(self):
        return self.size() != 0
    def size(self):
        return len(self.getObject())
    def override(self, flag):
# Keep the C++ flags in the ActiveAreas synchronized
# with the Python flag in the ActiveAreaContext.
        for aa in self.undobuffer:
            aa.override(flag)
        self.getTimeStamp(None).increment()
        self._override = flag
    def getOverride(self):
        return self._override
    def isActive(self, pixel):
        return self.getObject().isActive(pixel)
    def getBitmap(self):
        if not self._override:
            return self.getObject().getBitmap()
# This doesn't do what you think.  Active areas store lists of
# *inactive* pixels, and this returns the list of selected pixels,
# which are *inactive*.  Did I mention *inactive*?
    def getSelection(self):
        return self.getObject().members()
    def getSelectionAsGroup(self):
        return self.getObject().getPixelGroup()

activeareaWhoClass = whoville.WhoDoUndoClass(
    'Active Area',
    instanceClass=ActiveAreaContext,
    ordering=998,
    secret=0,
    proxyClasses=['<top activearea>'])

defaultActiveAreaColor = color.TranslucentGray(1.0, 0.5)

def _setDefaultActiveAreaParams(menuitem, color):
    global defaultActiveAreaColor
    defaultActiveAreaColor = color

mainmenu.gfxdefaultsmenu.Pixels.addItem(oofmenu.OOFMenuItem(
    'Active_Area',
    callback=_setDefaultActiveAreaParams,
    ordering=3,
    params=[
        color.TranslucentColorParameter(
            'color', defaultActiveAreaColor,
            tip='Color of inactive pixels.')
    ],
    help="Set default parameters for displaying active areas.",
    discussion="""<para>

    Set default parameters for the <xref
    linkend="RegisteredClass-BitmapOverlayDisplayMethod"/> that is used
    to display <link linkend="Section-Concepts-Microstructure-ActiveArea">active areas</link>.
    This command can be put in the &oof2rc; file to set defaults for all
    &oof2; sessions.

    </para>"""))

def predefinedActiveAreaLayer():
    return bitoverlaydisplay.bitmapOverlay(color=defaultActiveAreaColor)

ghostgfxwindow.PredefinedLayer('Active Area', '<top activearea>',
                               predefinedActiveAreaLayer)

#####

aa_attr_reg = ActiveAreasAttributeRegistration()

# writeData command, called from microstructureIO.py in the definition
# of pixel categories.  Writes out the active areas to which the
# representative pixel belongs, or False if there are none.
def _AAReg_writeData(self, datafile, ms, reppxl):
    if reppxl is None:
        return False
    alist = areaListFromPixel(ms, reppxl);
    namelist = alist.getNames()
    if len(namelist)==0:
        return False
    datafile.argument('active_areas', namelist)
    return True

ActiveAreasAttributeRegistration.writeData = _AAReg_writeData


