/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.macos;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.peer.ListPeer;
import sun.awt.macos.MComponentPeer;
import sun.awt.macos.MToolkit;

class MListPeer
extends MComponentPeer
implements ListPeer {
    MListPeer(List list) {
        super(list);
    }

    native void create(MComponentPeer var1);

    void initialize() {
        List list = (List)this.target;
        int n = list.countItems();
        int n2 = 0;
        while (n2 < n) {
            this.addItem(list.getItem(n2), -1);
            ++n2;
        }
        this.setMultipleSelections(list.allowsMultipleSelections());
        int n3 = list.getVisibleIndex();
        if (n3 >= 0) {
            this.makeVisible(n3);
        }
        int[] nArray = list.getSelectedIndexes();
        int n4 = 0;
        while (n4 < nArray.length) {
            this.select(nArray[n4]);
            ++n4;
        }
        super.initialize();
    }

    public native void setMultipleSelections(boolean var1);

    public native boolean isSelected(int var1);

    public native void addItem(String var1, int var2);

    public native void delItems(int var1, int var2);

    public native void select(int var1);

    public native void deselect(int var1);

    public native void makeVisible(int var1);

    public void clear() {
        List list = (List)this.target;
        this.delItems(0, list.countItems());
    }

    public int[] getSelectedIndexes() {
        List list = (List)this.target;
        int n = list.countItems();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.isSelected(n3)) {
                nArray[n2++] = n3;
            }
            ++n3;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public void handleAction(int n) {
        List list = (List)this.target;
        list.select(n);
        MToolkit.postEvent(new ActionEvent(this.target, 1001, list.getItem(n)));
    }

    public void handleListChanged(int n) {
        List list = (List)this.target;
        MToolkit.postEvent(new ItemEvent(list, 701, new Integer(n), this.isSelected(n) ? 1 : 2));
    }

    public Dimension minimumSize() {
        return this.minimumSize(4);
    }

    public Dimension preferredSize(int n) {
        return this.minimumSize(n);
    }

    public Dimension minimumSize(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        return new Dimension(20 + fontMetrics.stringWidth("0123456789abcde"), (fontMetrics.getHeight() + 2) * n + 11);
    }

    public void add(String string, int n) {
        this.addItem(string, n);
    }

    public void removeAll() {
        this.clear();
    }

    public void setMultipleMode(boolean bl) {
        this.setMultipleSelections(bl);
    }

    public Dimension getPreferredSize(int n) {
        return this.preferredSize(n);
    }

    public Dimension getMinimumSize(int n) {
        return this.minimumSize(n);
    }

    public boolean isFocusTraversable() {
        return true;
    }
}

