/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;

public final class DatagramPacket {
    byte[] buf;
    int length;
    InetAddress address;
    int port;

    public DatagramPacket(byte[] byArray, int n) {
        if (n > byArray.length) {
            throw new IllegalArgumentException("illegal length");
        }
        this.buf = byArray;
        this.length = n;
        this.address = null;
        this.port = -1;
    }

    public DatagramPacket(byte[] byArray, int n, InetAddress inetAddress, int n2) {
        if (n > byArray.length) {
            throw new IllegalArgumentException("illegal length");
        }
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("Port out of range:" + n2);
        }
        this.buf = byArray;
        this.length = n;
        this.address = inetAddress;
        this.port = n2;
    }

    public synchronized InetAddress getAddress() {
        return this.address;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized byte[] getData() {
        return this.buf;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public synchronized void setPort(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Port out of range:" + n);
        }
        this.port = n;
    }

    public synchronized void setData(byte[] byArray) {
        this.buf = byArray;
    }

    public synchronized void setLength(int n) {
        if (n > this.buf.length) {
            throw new IllegalArgumentException("illegal length");
        }
        this.length = n;
    }
}

